/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import problems.BorderArray;

public class Shikaku
implements ProblemAPI {
    int nRows;
    int nCols;
    Room[] rooms;

    public void model() {
        int nRooms = this.rooms.length;
        IVar.Var[] l = this.array("l", this.size(nRooms), this.dom(this.range(this.nCols + 1)), "l[i] is the position of the left border of the ith room", new Types.TypeClass[0]);
        IVar.Var[] r = this.array("r", this.size(nRooms), this.dom(this.range(this.nCols + 1)), "r[i] is the position of the right border of the ith room", new Types.TypeClass[0]);
        IVar.Var[] t = this.array("t", this.size(nRooms), this.dom(this.range(this.nRows + 1)), "t[i] is the position of the top border of the ith room", new Types.TypeClass[0]);
        IVar.Var[] b = this.array("b", this.size(nRooms), this.dom(this.range(this.nRows + 1)), "b[i] is the position of the bottom border of the ith room", new Types.TypeClass[0]);
        this.forall(this.range(nRooms), i -> this.lessEqual(l[i], this.rooms[i].col));
        this.forall(this.range(nRooms), i -> this.greaterThan(r[i], this.rooms[i].col));
        this.forall(this.range(nRooms), i -> this.lessEqual(t[i], this.rooms[i].row));
        this.forall(this.range(nRooms), i -> this.greaterThan(b[i], this.rooms[i].row));
        this.forall(this.range(nRooms), i -> this.equal(new Object[]{this.mul(new Object[]{this.sub(r[i], l[i]), this.sub(b[i], t[i])}), this.rooms[i].value}));
        this.forall(this.range(nRooms).range(nRooms), (i, j) -> {
            if (i < j) {
                int leftmost = this.rooms[i].col <= this.rooms[j].col ? i : j;
                int rightmost = leftmost == i ? j : i;
                XNodeParent p = this.le(r[leftmost], l[rightmost]);
                if (this.rooms[leftmost].row == this.rooms[rightmost].row) {
                    this.intension(p);
                } else if (this.rooms[leftmost].row > this.rooms[rightmost].row) {
                    this.disjunction(new Object[]{p, this.ge(t[leftmost], b[rightmost])});
                } else {
                    this.disjunction(new Object[]{p, this.le(b[leftmost], t[rightmost])});
                }
            }
        }).note("rooms must not overlap");
    }

    public void prettyDisplay(String[] values) {
        int nRooms = this.rooms.length;
        BorderArray ba = new BorderArray(this.nRows + 1, this.nCols + 1);
        IntStream.range(0, nRooms).forEach(i -> ba.writeBorder(values[i], values[i + nRooms], values[i + 2 * nRooms], values[i + 3 * nRooms]));
        Arrays.stream(this.rooms).forEach(r -> ba.writeValue(r.row, r.col, r.value));
        System.out.println(ba.toString());
    }

    class Room {
        int row;
        int col;
        int value;

        Room() {
        }
    }
}

