/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import variables.Variable;

public class RectPacking
implements ProblemAPI {
    Rectangle container;
    Rectangle[] boxes;

    public void model() {
        int nBoxes = this.boxes.length;
        IVar.Var[] x = this.array("x", this.size(nBoxes), this.dom(this.range(this.container.width)), "x[i] is the x-coordinate where is put the ith rectangle", new Types.TypeClass[0]);
        IVar.Var[] y = this.array("y", this.size(nBoxes), this.dom(this.range(this.container.height)), "y[i] is the y-coordinate where is put the ith rectangle", new Types.TypeClass[0]);
        this.forall(this.range(nBoxes), i -> this.lessEqual(this.add(new Object[]{x[i], this.boxes[i].width}), this.container.width)).note("unary constraints on x");
        this.forall(this.range(nBoxes), i -> this.lessEqual(this.add(new Object[]{y[i], this.boxes[i].height}), this.container.height)).note("unary constraints on y");
        this.noOverlap((IVar.Var[][])this.transpose(new IVar.Var[][]{x, y}), (int[][])Stream.of(this.boxes).map(b -> this.tuple(b.width, new int[]{b.height})).toArray(x$0 -> new int[x$0][])).note("no overlap on boxes");
        if (this.container.width == this.container.height) {
            this.block(() -> {
                this.lessEqual(x[nBoxes - 1], (int)Math.floor((double)(this.container.width - this.boxes[nBoxes - 1].width) / 2.0));
                this.lessEqual(y[nBoxes - 1], x[nBoxes - 1]);
            }).tag(new Types.TypeClass[]{SYMMETRY_BREAKING});
        }
        if (this.imp() instanceof Problem) {
            ((Problem)this.imp()).annotateVarhStatic((Variable[])IntStream.range(0, nBoxes * 2).mapToObj(i -> i % 2 == 0 ? x[nBoxes - 1 - i / 2] : y[nBoxes - 1 - i / 2]).toArray(Variable[]::new));
        }
    }

    class Rectangle {
        int width;
        int height;

        Rectangle() {
        }
    }
}

