/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class ProgressiveParty
implements ProblemAPI {
    int nPeriods;
    Boat[] boats;

    public void model() {
        int nBoats = this.boats.length;
        int[] crewSizes = Stream.of(this.boats).mapToInt(b -> b.crewSize).toArray();
        IVar.Var[] h = this.array("h", this.size(nBoats), this.dom(0, new int[]{1}), "h[b] indicates if the boat b is a host boat", new Types.TypeClass[0]);
        IVar.Var[][] s = this.array("s", this.size(nBoats, this.nPeriods), this.dom(this.range(nBoats)), "s[b][p] is the scheduled (visited) boat by the crew of boat b at period p", new Types.TypeClass[0]);
        IVar.Var[][][] g = this.array("g", this.size(nBoats, this.nPeriods, nBoats), this.dom(0, new int[]{1}), "g[b1][p][b2] is 1 if s[b1][p] = b2", new Types.TypeClass[0]);
        this.forall(this.range(nBoats).range(this.nPeriods), (b, p) -> this.equivalence(new Object[]{this.eq(new Object[]{s[b][p], b}), h[b]})).note("identifying host boats (when receiving)");
        this.forall(this.range(nBoats).range(nBoats).range(this.nPeriods), (b1, b2, p) -> {
            if (b1 != b2) {
                this.implication(this.eq(new Object[]{s[b1][p], b2}), h[b2]);
            }
        }).note("identifying host boats (when visiting)");
        this.forall(this.range(nBoats).range(this.nPeriods), (b, p) -> this.channel(g[b][p], s[b][p])).note("channeling variables from arrays s and g");
        this.forall(this.range(nBoats).range(this.nPeriods), (b, p) -> this.sum((IVar.Var[])this.select(g, (i, j, k) -> j == p && k == b), crewSizes, LE, this.boats[b].capacity)).note("boat capacities must be respected");
        this.forall(this.range(nBoats), b -> this.allDifferent(s[b], new int[]{this.exceptValue(b)})).note("a guest boat cannot revisit a host");
        this.forall(this.range(nBoats).range(nBoats), (b1, b2) -> {
            if (b1 < b2) {
                this.sum(this.treesFrom(this.range(this.nPeriods), p -> this.eq(new Object[]{s[b1][p], s[b2][p]})), LE, 2L);
            }
        }).note("guest crews cannot meet more than once");
        this.minimize(SUM, (IVar[])h).note("minimizing the number of host boats");
    }

    class Boat {
        int capacity;
        int crewSize;

        Boat() {
        }
    }
}

