/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNode;
import org.xcsp.modeler.api.ProblemAPI;

public class Mario
implements ProblemAPI {
    int marioHouse;
    int luigiHouse;
    int fuelLimit;
    House[] houses;

    public void model() {
        int nHouses = this.houses.length;
        int[][] fuels = (int[][])IntStream.range(0, nHouses).mapToObj(i -> this.houses[i].fuelConsumption).toArray(x$0 -> new int[x$0][]);
        IVar.Var[] s = this.array("s", this.size(nHouses), this.dom(this.range(nHouses)), "s[i] is the house succeeding to the ith house (itself if not part of the route)", new Types.TypeClass[0]);
        IVar.Var[] f = this.array("f", this.size(nHouses), i -> this.dom(this.houses[i].fuelConsumption), "f[i] is the fuel consumed at each step (from house i to its successor)", new Types.TypeClass[0]);
        if (this.modelVariant("table")) {
            this.forall(this.range(nHouses), i -> this.extension((IVar.Var[])this.vars(s[i], (IVar)f[i]), this.indexing(this.houses[i].fuelConsumption))).note("fuel consumption at each step");
        } else {
            this.forall(this.range(nHouses), i -> this.element(fuels[i], s[i], f[i])).note("fuel consumption at each step");
        }
        this.sum(f, LE, this.fuelLimit).note("we cannot consume more than the available fuel");
        this.circuit(s).note("Mario must make a tour (not necessarily complete)");
        this.equal(new Object[]{s[this.luigiHouse], this.marioHouse}).note("Mario's house succeeds to Luigi's house");
        Stream<XNode> trees = IntStream.range(0, nHouses).filter(i -> i != this.marioHouse && i != this.luigiHouse).mapToObj(i -> this.ne(new Object[]{s[i], i}));
        int[] coeffs = IntStream.range(0, nHouses).filter(i -> i != this.marioHouse && i != this.luigiHouse).map(i -> this.houses[i].gold).toArray();
        this.maximize(SUM, trees, coeffs).note("maximizing collected gold");
    }

    class House {
        int[] fuelConsumption;
        int gold;

        House() {
        }
    }
}

