/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class LinearArrangement
implements ProblemAPI {
    int n;
    long[][] adjacence;

    public void model() {
        IVar.Var[] x = this.array("x", this.size(this.n), this.dom(this.range(this.n)), "x[i] denotes the 'node' at the i-th position of the stack to be built (primal variables)", new Types.TypeClass[0]);
        IVar.Var[] y = this.array("y", this.size(this.n), this.dom(this.range(this.n)), "y[i] denotes the position of the 'node' whose value is i (dual variables)", new Types.TypeClass[0]);
        IVar.Var[][] d = this.array("d", this.size(this.n, this.n), (i, j) -> i < j && this.adjacence[i][j] == 1L ? this.dom(this.range(1, this.n)) : null, "d[i][j] denotes the distance between the ith and jth nodes (if they are adjacent)", new Types.TypeClass[0]);
        this.allDifferent(x);
        this.allDifferent(y);
        this.channel(x, y);
        this.forall(this.range(this.n).range(this.n), (i, j) -> {
            if (d[i][j] != null) {
                this.equal(new Object[]{d[i][j], this.dist(x[i], x[j])});
            }
        }).note("linking primal and distance variables");
        boolean test = true;
        if (test) {
            this.forall(this.range(this.n).range(this.n).range(this.n), (i, j, k) -> {
                if (d[i][j] != null && this.adjacence[i][k] == 1L && this.adjacence[j][k] == 1L) {
                    this.intension(this.le(d[i][j], this.add(new Object[]{i < k ? d[i][k] : d[k][i], j < k ? d[j][k] : d[k][j]})));
                }
            }).note("triangle constraints: distance(i,j) <= distance(i,k) + distance(k,j)").tag(new Types.TypeClass[]{REDUNDANT_CONSTRAINTS});
        }
        this.minimize(SUM, this.vars((IVar[][])d));
    }
}

