/*
 * Decompiled with CFR 0.152.
 */
package problems.g3_pattern;

import java.util.ArrayList;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class Lightup
implements ProblemAPI {
    int[][] grid;

    IVar.Var[] sequenceScope(IVar.Var[][] x, int i, int j, boolean horizontal) {
        ArrayList<IVar.Var> list;
        block4: {
            block3: {
                list = new ArrayList<IVar.Var>();
                if (!horizontal) break block3;
                if (j != 0 && (this.grid[i][j - 1] == -1 || this.grid[i][j] != -1)) break block4;
                while (j < this.grid[i].length && this.grid[i][j] == -1) {
                    list.add(x[i][j++]);
                }
                break block4;
            }
            if (i == 0 || this.grid[i - 1][j] != -1 && this.grid[i][j] == -1) {
                while (i < this.grid.length && this.grid[i][j] == -1) {
                    list.add(x[i++][j]);
                }
            }
        }
        return list.size() > 1 ? list.toArray(new IVar.Var[0]) : null;
    }

    IVar.Var[] fullScope(IVar.Var[][] x, int i, int j) {
        int base;
        if (this.grid[i][j] != -1) {
            return null;
        }
        ArrayList<IVar.Var> list = new ArrayList<IVar.Var>();
        for (base = j; base >= 0 && this.grid[i][base] == -1; --base) {
        }
        for (int jj = base + 1; jj < this.grid[i].length && this.grid[i][jj] == -1; ++jj) {
            list.add(x[i][jj]);
        }
        for (base = i; base >= 0 && this.grid[base][j] == -1; --base) {
        }
        for (int ii = base + 1; ii < this.grid.length && this.grid[ii][j] == -1; ++ii) {
            if (ii == i) continue;
            list.add(x[ii][j]);
        }
        return list.toArray(new IVar.Var[0]);
    }

    IVar.Var[] sideScope(IVar.Var[][] x, int i, int j) {
        ArrayList<IVar.Var> list = new ArrayList<IVar.Var>();
        if (i > 0 && this.grid[i - 1][j] == -1) {
            list.add(x[i - 1][j]);
        }
        if (i < this.grid.length - 1 && this.grid[i + 1][j] == -1) {
            list.add(x[i + 1][j]);
        }
        if (j > 0 && this.grid[i][j - 1] == -1) {
            list.add(x[i][j - 1]);
        }
        if (j < this.grid[i].length - 1 && this.grid[i][j + 1] == -1) {
            list.add(x[i][j + 1]);
        }
        return list.toArray(new IVar.Var[0]);
    }

    public void model() {
        int nRows = this.grid.length;
        int nCols = this.grid[0].length;
        IVar.Var[][] x = this.array("x", this.size(nRows, nCols), (i, j) -> this.dom(0, new int[]{1}).when(this.grid[i][j] == -1), "x[i][j] is 1 iff a light bulb is put at row i and col j", new Types.TypeClass[0]);
        this.forall(this.range(nRows).range(nCols), (i, j) -> {
            IVar.Var[] scp = this.sequenceScope(x, i, j, true);
            if (scp != null) {
                this.atMost1(scp, this.takingValue(1));
            }
        }).note("at most 1 bulb on each maximal sequence of white cells on rows");
        this.forall(this.range(nRows).range(nCols), (i, j) -> {
            IVar.Var[] scp = this.sequenceScope(x, i, j, false);
            if (scp != null) {
                this.atMost1(scp, this.takingValue(1));
            }
        }).note("at most 1 bulb on each maximal sequence of white cells on columns");
        this.forall(this.range(nRows).range(nCols), (i, j) -> {
            IVar.Var[] scp = this.fullScope(x, i, j);
            if (scp != null) {
                this.atLeast1(scp, this.takingValue(1));
            }
        });
        this.forall(this.range(nRows).range(nCols), (i, j) -> {
            if (0 <= this.grid[i][j] && this.grid[i][j] <= 4) {
                this.exactly(this.sideScope(x, i, j), this.takingValue(1), this.grid[i][j]);
            }
        }).tag(new Types.TypeClass[]{CLUES});
    }
}

