/*
 * Decompiled with CFR 0.152.
 */
package problems.g2_academic;

import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.modeler.api.ProblemAPI;

public class PeacableArmies
implements ProblemAPI {
    int n;

    public void model() {
        if (this.modelVariant("m1")) {
            IVar.Var[][] b = this.array("b", this.size(this.n, this.n), this.dom(0, new int[]{1}), "b[i][j] is 1 if a black queen is in the cell at row i and column j", new Types.TypeClass[0]);
            IVar.Var[][] w = this.array("w", this.size(this.n, this.n), this.dom(0, new int[]{1}), "w[i][j] is 1 if a white queen is in the cell at row i and column j", new Types.TypeClass[0]);
            this.forall(this.range(this.n).range(this.n).range(this.n).range(this.n), (i1, j1, i2, j2) -> {
                if (i1 == i2 && j1 == j2) {
                    this.lessEqual(this.add(new Object[]{b[i1][j1], w[i1][j1]}), 1);
                } else if ((i1 < i2 || i1 == i2 && j1 < j2) && (i1 == i2 || j1 == j2 || Math.abs(i1 - i2) == Math.abs(j1 - j2))) {
                    this.lessEqual(this.add(new Object[]{b[i1][j1], w[i2][j2]}), 1);
                    this.lessEqual(this.add(new Object[]{w[i1][j1], b[i2][j2]}), 1);
                }
            }).note("no two opponent queens can attack each other");
            int[] coeffs = this.range(this.n * this.n * 2).map(i -> i < this.n * this.n ? 1 : -1);
            this.sum((IVar.Var[])this.vars(b, (IVar[][])w), this.weightedBy(coeffs), EQ, 0L).note("ensuring the same numbers of black and white queens");
            this.maximize(SUM, (IVar[][])b).note("maximizing the number of black queens (and consequently, the size of the armies)");
        }
        if (this.modelVariant("m2")) {
            IVar.Var[][] x = this.array("x", this.size(this.n, this.n), this.dom(0, new int[]{1, 2}), "x[i][j] is 1 (resp., 2), if a black (resp., white) queen is in the cell at row i and column j. It is 0 otherwise.", new Types.TypeClass[0]);
            IVar.Var nb = this.var("nb", this.dom(this.range(this.n * this.n / 2)), "nb is the number of black queens", new Types.TypeClass[0]);
            IVar.Var nw = this.var("nw", this.dom(this.range(this.n * this.n / 2)), "nw is the number of white queens", new Types.TypeClass[0]);
            this.forall(this.range(this.n).range(this.n).range(this.n).range(this.n), (i1, j1, i2, j2) -> {
                if ((i1 < i2 || i1 == i2 && j1 < j2) && (i1 == i2 || j1 == j2 || Math.abs(i1 - i2) == Math.abs(j1 - j2))) {
                    this.different(new Object[]{this.add(new Object[]{x[i1][j1], x[i2][j2]}), 3});
                }
            }).note("no two opponent queens can attack each other");
            this.count((IVar.Var[])this.vars((IVar[][])x), this.takingValue(1), EQ, nb).note("counting the number of black queens");
            this.count((IVar.Var[])this.vars((IVar[][])x), this.takingValue(2), EQ, nw).note("counting the number of white queens");
            this.equal(new Object[]{nb, nw}).note("ensuring equal-sized armies");
            this.maximize((IVar)nb).note("maximizing the number of black queens (and consequently, the size of the armies)");
        }
    }
}

