/*
 * Decompiled with CFR 0.152.
 */
package problems.g1_single;

import constraints.hard.extension.CtrExtensionSmart;
import constraints.hard.extension.structures.SmartTuple;
import java.util.ArrayList;
import java.util.stream.IntStream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.api.ProblemAPI;
import problem.Problem;
import variables.Variable;

public class Solitaire
implements ProblemAPI {
    private boolean isValidPosition(int i, int j) {
        return !(i < 2 && j < 2 || i < 2 && j > 4 || i > 4 && j < 2 || i > 4 && j > 4);
    }

    private boolean isValidPosition(int v) {
        return 0 <= v && v < 49 && this.isValidPosition(v / 7, v % 7);
    }

    private int[] validPositions() {
        return IntStream.range(0, 49).filter(v -> this.isValidPosition(v)).toArray();
    }

    private boolean onSameRow(int v1, int v2, int v3) {
        return v1 / 7 == v2 / 7 && v2 / 7 == v3 / 7;
    }

    private int[] l2r() {
        return IntStream.of(this.validPositions()).filter(v -> this.isValidPosition(v + 1) && this.isValidPosition(v + 2) && this.onSameRow(v, v + 1, v + 2)).toArray();
    }

    private int[] r2l() {
        return IntStream.of(this.validPositions()).filter(v -> this.isValidPosition(v - 1) && this.isValidPosition(v - 2) && this.onSameRow(v, v - 1, v - 2)).toArray();
    }

    private int[] t2b() {
        return IntStream.of(this.validPositions()).filter(v -> this.isValidPosition(v + 7) && this.isValidPosition(v + 14)).toArray();
    }

    private int[] b2t() {
        return IntStream.of(this.validPositions()).filter(v -> this.isValidPosition(v - 7) && this.isValidPosition(v - 14)).toArray();
    }

    private SmartTuple[] smartTuples(IVar.Var m1, IVar.Var[][] x1, IVar.Var[][] x2) {
        ArrayList<Object> restrictions;
        ArrayList<SmartTuple> list = new ArrayList<SmartTuple>();
        int cnt = 0;
        for (int v : this.l2r()) {
            restrictions = new ArrayList<XNodeParent<? extends IVar>>();
            restrictions.add(this.eq(new Object[]{m1, cnt++}));
            for (int w : this.validPositions()) {
                if (w == v || w == v + 1) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 1}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 0}));
                    continue;
                }
                if (w == v + 2) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 0}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 1}));
                    continue;
                }
                restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], x2[w / 7][w % 7]}));
            }
            list.add(new SmartTuple(restrictions));
        }
        for (int v : this.r2l()) {
            restrictions = new ArrayList();
            restrictions.add(this.eq(new Object[]{m1, cnt++}));
            for (int w : this.validPositions()) {
                if (w == v || w == v - 1) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 1}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 0}));
                    continue;
                }
                if (w == v - 2) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 0}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 1}));
                    continue;
                }
                restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], x2[w / 7][w % 7]}));
            }
            list.add(new SmartTuple(restrictions));
        }
        for (int v : this.t2b()) {
            restrictions = new ArrayList();
            restrictions.add((XNodeParent<? extends IVar>)this.eq(new Object[]{m1, cnt++}));
            for (int w : this.validPositions()) {
                if (w == v || w == v + 7) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 1}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 0}));
                    continue;
                }
                if (w == v + 14) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 0}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 1}));
                    continue;
                }
                restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], x2[w / 7][w % 7]}));
            }
            list.add(new SmartTuple(restrictions));
        }
        for (int v : this.b2t()) {
            restrictions = new ArrayList();
            restrictions.add((XNodeParent<? extends IVar>)this.eq(new Object[]{m1, cnt++}));
            for (int w : this.validPositions()) {
                if (w == v || w == v - 7) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 1}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 0}));
                    continue;
                }
                if (w == v - 14) {
                    restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], 0}));
                    restrictions.add(this.eq(new Object[]{x2[w / 7][w % 7], 1}));
                    continue;
                }
                restrictions.add(this.eq(new Object[]{x1[w / 7][w % 7], x2[w / 7][w % 7]}));
            }
            list.add(new SmartTuple(restrictions));
        }
        return list.toArray(new SmartTuple[0]);
    }

    public void model() {
        int nMoves = 31;
        IVar.Var[][][] x = this.array("x", this.size(nMoves + 1, 7, 7), (t, i, j) -> this.isValidPosition(i, j) ? this.dom(0, new int[]{1}) : null, "x[t][i][j] is the value of the board at time t and row i and col j", new Types.TypeClass[0]);
        IVar.Var[] m = this.array("m", this.size(nMoves), this.dom(this.range(76)), "m[t] is the move at time t", new Types.TypeClass[0]);
        this.instantiation((IVar.Var[])this.vars((IVar[][])x[0]), this.vals(new Object[]{this.repeat(1, 16), 0, this.repeat(1, 16)}));
        this.equal(new Object[]{m[0], 8});
        this.instantiation((IVar.Var[])this.vars((IVar[][])x[31]), this.vals(new Object[]{this.repeat(0, 16), 1, this.repeat(0, 16)}));
        this.forall(this.range(nMoves), t -> ((Problem)this.imp()).addCtr(new CtrExtensionSmart((Problem)this.imp(), (Variable[])this.vars(m[t], new Object[]{x[t], x[t + 1]}), this.smartTuples(m[t], x[t], x[t + 1])), new Types.TypeClass[0]));
    }
}

