/*
 * Decompiled with CFR 0.152.
 */
package problem.cliques;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.Arrays;
import java.util.LinkedList;
import problem.Problem;
import problem.cliques.Clique;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class CliqueManager {
    private Problem pb;
    private int nCliques;
    public Clique[][] cliques;

    public CliqueManager(Problem pb) {
        this.pb = pb;
        Kit.control(Constraint.nPairsOfCtrsWithSimilarScopeIn(pb.constraints) == 0);
        this.fixCliques();
    }

    public void fixCliques() {
        this.nCliques = 0;
        LinkedList[] cliquesLists = new LinkedList[this.pb.constraints.length];
        for (int i = 0; i < cliquesLists.length; ++i) {
            cliquesLists[i] = new LinkedList();
        }
        for (Constraint c1 : this.pb.constraints) {
            if (c1.scp.length != 2) continue;
            for (Variable x : this.pb.variables) {
                Constraint c3;
                Constraint c2;
                if (c1.involves(x) || (c2 = c1.scp[0].firstBinaryConstraintWith(x)) == null || c2.num < c1.num || (c3 = c1.scp[1].firstBinaryConstraintWith(x)) == null || c3.num < c1.num) continue;
                if (c2.num > c3.num) {
                    Constraint tmp = c2;
                    c2 = c3;
                    c3 = tmp;
                }
                Clique clique = new Clique(c1, c2, c3);
                cliquesLists[c1.num].add(clique);
                cliquesLists[c2.num].add(clique);
                cliquesLists[c3.num].add(clique);
                ++this.nCliques;
            }
        }
        int nbConstraintsInvolvedInCliques = 0;
        this.cliques = new Clique[this.pb.constraints.length][];
        for (Constraint ctr : this.pb.constraints) {
            this.cliques[ctr.num] = cliquesLists[ctr.num].toArray(new Clique[cliquesLists[ctr.num].size()]);
            Arrays.sort(this.cliques[ctr.num]);
            for (int i = 0; i < this.cliques[ctr.num].length; ++i) {
                this.cliques[ctr.num][i].setPosition(ctr, i);
            }
            if (cliquesLists[ctr.num].size() <= 0) continue;
            ++nbConstraintsInvolvedInCliques;
        }
        Kit.log.fine("nbConstraintsInvolvedInCliques=" + nbConstraintsInvolvedInCliques + "  " + "nbCliques=" + this.nCliques);
    }

    public static int getPathSupport(Variable x, Variable y, int a, int b, Variable z, int idxStart3, Constraint c1, Constraint c2) {
        int[] tuple1 = c1.tupleManager.localTuple;
        int vap1 = c1.scp[0] == x ? 0 : 1;
        int bro1 = vap1 == 0 ? 1 : 0;
        tuple1[vap1] = a;
        int[] tuple2 = c2.tupleManager.localTuple;
        int vap2 = c2.scp[0] == y ? 0 : 1;
        int bro2 = vap2 == 0 ? 1 : 0;
        tuple2[vap2] = b;
        Domain dom3 = z.dom;
        if (idxStart3 == -1) {
            idxStart3 = dom3.first();
        } else if (!dom3.isPresent(idxStart3)) {
            idxStart3 = dom3.next(idxStart3);
        }
        int idx3 = idxStart3;
        while (idx3 != -1) {
            tuple1[bro1] = idx3;
            tuple2[bro2] = idx3;
            if (((CtrHard)c1).checkIndexes(tuple1) && ((CtrHard)c2).checkIndexes(tuple2)) {
                return idx3;
            }
            idx3 = dom3.next(idx3);
        }
        return -1;
    }

    public int getPathSupport(Constraint c, int[] tuple, Clique clique, int start) {
        Variable x = c.scp[0];
        Variable y = c.scp[1];
        Variable z = clique.setWorkingSet(x, y);
        return CliqueManager.getPathSupport(x, y, tuple[0], tuple[1], z, start, clique.wrk1, clique.wrk2);
    }

    public boolean isPathConsistent(Variable x, Variable y, int a, int b, Clique[] cliques) {
        for (Clique clique : cliques) {
            Variable var3 = clique.setWorkingSet(x, y);
            if (CliqueManager.getPathSupport(x, y, a, b, var3, -1, clique.wrk1, clique.wrk2) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean isPathConsistent(Constraint c, int[] tuple) {
        assert (c.scp.length == 2);
        return this.isPathConsistent(c.scp[0], c.scp[1], tuple[0], tuple[1], this.cliques[c.num]);
    }

    public void displayCliques(boolean restricted) {
        System.out.println("Cliques :");
        for (Constraint c : this.pb.constraints) {
            System.out.println("Cliques from " + c);
            for (Clique clique : this.cliques[c.num]) {
                if (restricted && clique.c1 != c) continue;
                System.out.println("  clique = " + clique);
            }
        }
        System.out.println("  => " + this.nCliques + " cliques");
    }
}

