/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import objectives.Obj;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class ObjMinimum
extends Obj {
    @Override
    public long objectiveValue() {
        int min = this.scp[0].dom.uniqueValue();
        for (int i = 1; i < this.scp.length; ++i) {
            int m = this.scp[i].dom.uniqueValue();
            if (m >= min) continue;
            min = m;
        }
        return min;
    }

    public ObjMinimum(Problem pb, Variable[] scp, int limit) {
        super(pb, scp, limit);
    }

    @Override
    public boolean checkValues(int[] vals) {
        int min = vals[0];
        for (int i = 1; i < vals.length; ++i) {
            if (vals[i] >= min) continue;
            min = vals[i];
        }
        return this instanceof ObjMinimumGE ? min >= this.limit : min <= this.limit;
    }

    public static final class ObjMinimumLE
    extends ObjMinimum {
        private int sentinel1 = 0;
        private int sentinel2;

        public ObjMinimumLE(Problem pb, Variable[] scp, int limit) {
            super(pb, scp, limit);
            this.sentinel2 = scp.length - 1;
            Kit.control(scp[this.sentinel1].dom.firstValue() <= limit && scp[this.sentinel2].dom.firstValue() <= limit, () -> "unsound sentinels");
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            if (this.scp[this.sentinel1].dom.firstValue() > this.limit) {
                for (i = 0; i < this.scp.length && (i == this.sentinel2 || this.scp[i].dom.firstValue() > this.limit); ++i) {
                }
                if (i < this.scp.length) {
                    this.sentinel1 = i;
                } else {
                    if (this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                        return x.dom.fail();
                    }
                    return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.GT, this.limit);
                }
            }
            if (this.scp[this.sentinel2].dom.firstValue() > this.limit) {
                for (i = 0; i < this.scp.length && (i == this.sentinel1 || this.scp[i].dom.firstValue() > this.limit); ++i) {
                }
                if (i < this.scp.length) {
                    this.sentinel2 = i;
                } else {
                    assert (this.scp[this.sentinel1].dom.firstValue() <= this.limit);
                    return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.GT, this.limit);
                }
            }
            return true;
        }
    }

    public static final class ObjMinimumGE
    extends ObjMinimum {
        public ObjMinimumGE(Problem pb, Variable[] scp, int limit) {
            super(pb, scp, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            for (Variable y : this.scp) {
                if (y.dom.removeValues(Types.TypeOperatorRel.LT, this.limit)) continue;
                return false;
            }
            this.entailed = true;
            return Variable.firstWipeoutVariableIn(this.scp) == null;
        }
    }
}

