/*
 * Decompiled with CFR 0.152.
 */
package objectives;

import objectives.Obj;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public abstract class ObjMaximum
extends Obj {
    @Override
    public long objectiveValue() {
        int max = this.scp[0].dom.uniqueValue();
        for (int i = 1; i < this.scp.length; ++i) {
            int m = this.scp[i].dom.uniqueValue();
            if (m <= max) continue;
            max = m;
        }
        return max;
    }

    public ObjMaximum(Problem pb, Variable[] scp, int limit) {
        super(pb, scp, limit);
    }

    @Override
    public boolean checkValues(int[] t) {
        int max = t[0];
        for (int i = 1; i < t.length; ++i) {
            if (t[i] <= max) continue;
            max = t[i];
        }
        return this instanceof ObjMaximumGE ? max >= this.limit : max <= this.limit;
    }

    public static final class ObjMaximumLE
    extends ObjMaximum {
        public ObjMaximumLE(Problem pb, Variable[] scp, int limit) {
            super(pb, scp, limit);
        }

        @Override
        public boolean runPropagator(Variable x) {
            if (this.entailed) {
                return true;
            }
            Kit.control(this.pb.solver.depth() == 0);
            for (Variable y : this.scp) {
                if (y.dom.removeValues(Types.TypeOperatorRel.GT, this.limit)) continue;
                return false;
            }
            this.entailed = true;
            return Variable.firstWipeoutVariableIn(this.scp) == null;
        }
    }

    public static final class ObjMaximumGE
    extends ObjMaximum {
        private int sentinel1 = 0;
        private int sentinel2;

        public ObjMaximumGE(Problem pb, Variable[] scp, int limit) {
            super(pb, scp, limit);
            this.sentinel2 = scp.length - 1;
            Kit.control(scp[this.sentinel1].dom.lastValue() >= limit && scp[this.sentinel2].dom.lastValue() >= limit, () -> "unsound sentinels");
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            if (this.scp[this.sentinel1].dom.lastValue() < this.limit) {
                for (i = 0; i < this.scp.length && (i == this.sentinel2 || this.scp[i].dom.lastValue() < this.limit); ++i) {
                }
                if (i < this.scp.length) {
                    this.sentinel1 = i;
                } else {
                    if (this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                        return x.dom.fail();
                    }
                    return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.LT, this.limit);
                }
            }
            if (this.scp[this.sentinel2].dom.lastValue() < this.limit) {
                for (i = 0; i < this.scp.length && (i == this.sentinel1 || this.scp[i].dom.lastValue() < this.limit); ++i) {
                }
                if (i < this.scp.length) {
                    this.sentinel2 = i;
                } else {
                    assert (this.scp[this.sentinel1].dom.lastValue() >= this.limit);
                    return this.scp[this.sentinel2].dom.removeValues(Types.TypeOperatorRel.LT, this.limit);
                }
            }
            return true;
        }
    }
}

