/*
 * Decompiled with CFR 0.152.
 */
package heuristics.variables;

import heuristics.Heuristic;
import java.util.stream.Stream;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public abstract class HeuristicVariables
extends Heuristic {
    protected BestScoredVariable bestScoredVariable = new BestScoredVariable();
    protected final SolverBacktrack solver;
    protected Variable[] priorityVars;
    private int nStrictlyPriorityVars;

    public final void setPriorityVars(Variable[] priorityVars, int nbStrictPriorityVars) {
        this.priorityVars = priorityVars;
        this.nStrictlyPriorityVars = nbStrictPriorityVars;
    }

    public final void resetPriorityVars() {
        this.priorityVars = Variable.EMPTY_ARRAY;
        this.nStrictlyPriorityVars = 0;
    }

    public HeuristicVariables(SolverBacktrack solver, boolean antiHeuristic) {
        super(antiHeuristic);
        this.solver = solver;
        if (solver.rs.cp.cpv.priorityVars.length > 0) {
            this.priorityVars = (Variable[])Stream.of(solver.rs.cp.cpv.priorityVars).map(o -> solver.pb.findVarWithNumOrId(o)).toArray(Variable[]::new);
            this.nStrictlyPriorityVars = solver.rs.cp.cpv.nStrictPriorityVars;
        } else {
            this.priorityVars = solver.pb.priorityVars;
            this.nStrictlyPriorityVars = solver.pb.nStrictPriorityVars;
        }
    }

    public abstract double scoreOf(Variable var1);

    public final double scoreOptimizedOf(Variable var) {
        return this.scoreOf(var) * (double)this.scoreCoeff;
    }

    private Variable bestPriorityVar() {
        int nPast = this.solver.futVars.nDiscarded();
        if (nPast < this.priorityVars.length) {
            Variable x;
            if (nPast < this.nStrictlyPriorityVars) {
                return this.priorityVars[nPast];
            }
            if (this.solver.rs.cp.varh.lastConflictSize > 0 && (x = this.solver.lcReasoner.lastConflictPriorityVar()) != null && Kit.isPresent(x, this.priorityVars)) {
                return x;
            }
            Variable bestVar = null;
            double bestScore = Double.NEGATIVE_INFINITY;
            for (int i = this.nStrictlyPriorityVars; i < this.priorityVars.length; ++i) {
                double score;
                if (this.priorityVars[i].isAssigned() || !((score = this.scoreOf(this.priorityVars[i]) * (double)this.scoreCoeff) > bestScore)) continue;
                bestVar = this.priorityVars[i];
                bestScore = score;
            }
            return bestVar;
        }
        return null;
    }

    protected abstract Variable bestUnpriorityVar();

    public final Variable bestVar() {
        Variable x = this.bestPriorityVar();
        return x != null ? x : this.bestUnpriorityVar();
    }

    public static class BestScoredVariable {
        public Variable variable;
        public double score;
        private boolean minimization;

        public BestScoredVariable reset(boolean minimization) {
            this.variable = null;
            this.score = minimization ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY;
            this.minimization = minimization;
            return this;
        }

        public boolean update(Variable x, double s) {
            if (this.minimization) {
                if (s < this.score) {
                    this.variable = x;
                    this.score = s;
                    return true;
                }
            } else if (s > this.score) {
                this.variable = x;
                this.score = s;
                return true;
            }
            return false;
        }
    }
}

