/*
 * Decompiled with CFR 0.152.
 */
package executables;

import dashboard.Arguments;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xcsp.common.Utilities;
import utility.Kit;
import utility.XMLManager;

public final class ResolutionVariants {
    public static final String VARIANT = "variant";
    public static final String VARIANT_PARALLEL = "variantParallel";
    public static final String NAME = "name";
    public static final String MODIFICATION = "modification";
    public static final String PATH = "path";
    public static final String ATTRIBUTE = "attribute";
    public static final String VALUE = "value";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String STEP = "step";
    public static final String SEED = "seed";

    public static final String[] loadSequentialVariants(String configurationFileName, String configurationVariantsFileName, String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        Document variantsDocument = XMLManager.load(configurationVariantsFileName);
        NodeList nodeList = variantsDocument.getElementsByTagName(VARIANT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element variantElement = (Element)nodeList.item(i);
            Element variantParent = (Element)variantElement.getParentNode();
            if (!variantsDocument.getDocumentElement().getTagName().equals(VARIANT_PARALLEL) && variantParent.getTagName().equals(VARIANT_PARALLEL)) continue;
            Document variantDocument = XMLManager.load(configurationFileName);
            String variantFileName = prefix + (variantParent.getTagName().equals(VARIANT_PARALLEL) ? variantParent.getAttribute(NAME) + "_" : "") + variantElement.getAttribute(NAME) + ".xml";
            NodeList modificationList = variantElement.getElementsByTagName(MODIFICATION);
            int nModifications = modificationList.getLength();
            boolean iteration = nModifications > 0 && !((Element)modificationList.item(nModifications - 1)).getAttribute(MIN).equals("");
            int limit = nModifications - (iteration ? 1 : 0);
            for (int j = 0; j < limit; ++j) {
                Element modificationElement = (Element)modificationList.item(j);
                String path = modificationElement.getAttribute(PATH);
                String attributeName = modificationElement.getAttribute(ATTRIBUTE);
                String attributeValue = modificationElement.getAttribute(VALUE);
                XMLManager.modify(variantDocument, path, attributeName, attributeValue);
            }
            if (iteration) {
                Element modification = (Element)modificationList.item(nModifications - 1);
                String path = modification.getAttribute(PATH);
                Kit.control(path.equals(SEED));
                String attributeName = modification.getAttribute(ATTRIBUTE);
                int min = Integer.parseInt(modification.getAttribute(MIN));
                int max = Integer.parseInt(modification.getAttribute(MAX));
                int step = Integer.parseInt(modification.getAttribute(STEP));
                String basis = variantFileName.substring(0, variantFileName.lastIndexOf(".xml"));
                for (int cnt = min; cnt <= max; cnt += step) {
                    XMLManager.modify(variantDocument, path, attributeName, cnt + "");
                    list.add(Utilities.save((Document)variantDocument, (String)(basis + cnt + ".xml")));
                }
                continue;
            }
            list.add(Utilities.save((Document)variantDocument, (String)variantFileName));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] loadParallelVariants(String configurationVariantsFileName, String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        Document variantsDocument = XMLManager.load(configurationVariantsFileName);
        if (!variantsDocument.getDocumentElement().getTagName().equals(VARIANT_PARALLEL)) {
            NodeList nodeList = variantsDocument.getElementsByTagName(VARIANT_PARALLEL);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Document document = XMLManager.createNewDocument();
                Element element = (Element)document.importNode(nodeList.item(i), true);
                document.appendChild(element);
                list.add(Utilities.save((Document)document, (String)(prefix + element.getAttribute(NAME) + ".xml")));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] loadVariantNames() {
        if (Arguments.multiThreads) {
            File file;
            String prefix = XMLManager.getAttValueFor(Arguments.userSettingsFilename, "xml", "exportMode");
            if (prefix.equals("NO")) {
                prefix = ".";
            }
            if (prefix != "") {
                prefix = prefix + File.separator;
            }
            if (!(file = new File(prefix = prefix + "configurations" + File.separator)).exists()) {
                file.mkdirs();
            } else {
                Kit.control(file.isDirectory());
            }
            return ResolutionVariants.loadSequentialVariants(Arguments.userSettingsFilename, Arguments.lastArgument(), prefix);
        }
        return new String[]{Arguments.userSettingsFilename};
    }
}

