/*
 * Decompiled with CFR 0.152.
 */
package executables;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.soft.extension.LayeredSoftTable;
import dashboard.Arguments;
import executables.Extraction;
import executables.Resolution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import utility.operations.Calculator;

public class Integration
extends Resolution {
    private List<LayeredSoftTable> collectedLayeredSoftTableDuringInitialization = new ArrayList<LayeredSoftTable>();
    private LayeredSoftTable[] layeredSoftTables;
    private int[] currentFront;
    private TreeSet<FrontDecorated> queueOfFrontDecorated = new TreeSet((o1, o2) -> o1.cost < o2.cost ? -1 : (o1.cost > o2.cost ? 1 : (o1.score > o2.score ? -1 : (o1.score < o2.score ? 1 : Kit.lexComparatorGeneral.compare(o1.front, o2.front)))));
    private long[] constraintScores;
    private Map<Constraint, Integer> idBases = new HashMap<Constraint, Integer>();

    public void addLayeredSoftTable(LayeredSoftTable layeredSoftTable) {
        this.collectedLayeredSoftTableDuringInitialization.add(layeredSoftTable);
    }

    private int getIdBaseOf(Constraint c) {
        return this.idBases.computeIfAbsent(c, cc -> Kit.parseInteger(cc.getId().substring(1)));
    }

    public Integration() {
        this.cp.framework = Types.TypeFramework.WCSP;
        this.cp.constraints.normalizeCtrs = false;
        this.problem = this.buildProblem(0);
        this.layeredSoftTables = this.collectedLayeredSoftTableDuringInitialization.toArray(new LayeredSoftTable[this.collectedLayeredSoftTableDuringInitialization.size()]);
        this.currentFront = new int[this.problem.constraints.length];
        this.constraintScores = new long[this.problem.constraints.length];
    }

    private FrontDecorated buildInitialFrontDecoratedFor(Constraint[] mucConstraints) {
        int[] front = new int[mucConstraints.length];
        long cost = 0L;
        for (int i = 0; i < front.length; ++i) {
            int idBase = this.getIdBaseOf(mucConstraints[i]);
            front[i] = this.currentFront[idBase];
            cost = Calculator.add(cost, this.layeredSoftTables[idBase].levelCosts[front[i]]);
        }
        return new FrontDecorated(front, cost, 0L);
    }

    private void addNeighBorsOf(Set<FrontDecorated> queue, Constraint[] selectedConstraints, FrontDecorated frontDecorated) {
        for (int i = 0; i < frontDecorated.front.length; ++i) {
            int idBase = this.getIdBaseOf(selectedConstraints[i]);
            int costIndex = frontDecorated.front[i];
            long[] costs = this.layeredSoftTables[idBase].levelCosts;
            if (costIndex >= costs.length - 1) continue;
            int[] newFront = (int[])frontDecorated.front.clone();
            newFront[i] = costIndex + 1;
            long newCost = Calculator.add(Calculator.add(frontDecorated.cost, -costs[costIndex]), costs[costIndex + 1]);
            long newScore = this.cp.integrating.mucHeuristic >= 3 ? this.constraintScores[idBase] : 0L;
            queue.add(new FrontDecorated(newFront, newCost, newScore));
        }
    }

    private void addNeighBorsOf2(Set<FrontDecorated> queue, Constraint[] mucConstraints, FrontDecorated frontDecorated) {
        for (int i = 0; i < mucConstraints.length; ++i) {
            long[] costs;
            int idBase = this.getIdBaseOf(mucConstraints[i]);
            int costIndex = frontDecorated.front[idBase];
            if (costIndex >= (costs = this.layeredSoftTables[idBase].levelCosts).length - 1) continue;
            int[] newFront = (int[])frontDecorated.front.clone();
            newFront[idBase] = costIndex + 1;
            long newCost = Calculator.add(Calculator.add(frontDecorated.cost, -costs[costIndex]), costs[costIndex + 1]);
            long newScore = this.cp.integrating.mucHeuristic >= 3 ? this.constraintScores[idBase] : 0L;
            queue.add(new FrontDecorated(newFront, newCost, newScore));
        }
    }

    private void relaxMuc(Constraint[] mucConstraints, Problem currentMuc) {
        if (this.cp.integrating.mucHeuristic == 6) {
            for (Constraint ctr : mucConstraints) {
                int n = this.getIdBaseOf(ctr);
                this.constraintScores[n] = this.constraintScores[n] + 1L;
            }
        }
        this.queueOfFrontDecorated.clear();
        FrontDecorated initialFrontDecorated = this.buildInitialFrontDecoratedFor(mucConstraints);
        int[] previousFront = initialFrontDecorated.front;
        this.addNeighBorsOf(this.queueOfFrontDecorated, mucConstraints, initialFrontDecorated);
        while (!this.queueOfFrontDecorated.isEmpty()) {
            int i;
            FrontDecorated selectedFrontDecorated = this.queueOfFrontDecorated.pollFirst();
            for (i = 0; i < mucConstraints.length; ++i) {
                int frontLevel = selectedFrontDecorated.front[i];
                if (frontLevel == previousFront[i]) continue;
                LayeredSoftTable layeredSoftTable = this.layeredSoftTables[this.getIdBaseOf(mucConstraints[i])];
                boolean defaulCostSmaller = layeredSoftTable.defaultCost <= layeredSoftTable.levelCosts[frontLevel];
                ((CtrExtension)mucConstraints[i]).storeTuples(layeredSoftTable.buildTuplesFromLayersLessThanOrEqualTo(layeredSoftTable.levelCosts[frontLevel]), !defaulCostSmaller);
            }
            currentMuc.solver.reset();
            currentMuc.solver.solve();
            if (currentMuc.solver.solManager.nSolutionsFound == 0L) {
                previousFront = selectedFrontDecorated.front;
                this.addNeighBorsOf(this.queueOfFrontDecorated, mucConstraints, selectedFrontDecorated);
                continue;
            }
            for (i = 0; i < mucConstraints.length; ++i) {
                this.currentFront[this.getIdBaseOf((Constraint)mucConstraints[i])] = selectedFrontDecorated.front[i];
            }
        }
    }

    private void relaxProblem(FrontDecorated frontDecorated, Problem problem, int[] previousFront) {
        for (int i = 0; i < problem.constraints.length; ++i) {
            if (frontDecorated.front[i] == previousFront[i]) continue;
            LayeredSoftTable layeredSoftTable = this.layeredSoftTables[i];
            boolean defaulCostEqual = layeredSoftTable.defaultCost == layeredSoftTable.levelCosts[frontDecorated.front[i]];
            ((CtrExtension)problem.constraints[i]).storeTuples(layeredSoftTable.buildTuplesFromLayerEqualTo(layeredSoftTable.levelCosts[frontDecorated.front[i]]), !defaulCostEqual);
        }
    }

    public static void main(String[] args) {
        Arguments.loadArguments(args);
        Integration integration = new Integration();
        Extraction extraction = new Extraction(integration.problem);
        Kit.control(Constraint.nPairsOfCtrsWithSimilarScopeIn(extraction.problem.constraints) == 0);
        if (integration.cp.integrating.mucCompleteApproach) {
            FrontDecorated initialFrontDecorated = integration.buildInitialFrontDecoratedFor(extraction.problem.constraints);
            int[] previousFront = initialFrontDecorated.front;
            integration.queueOfFrontDecorated.add(initialFrontDecorated);
            while (!integration.queueOfFrontDecorated.isEmpty()) {
                FrontDecorated selectedFrontDecorated = integration.queueOfFrontDecorated.pollFirst();
                Kit.log.info("OUT : cost = " + selectedFrontDecorated.cost + ", size of queue = " + integration.queueOfFrontDecorated.size());
                integration.relaxProblem(selectedFrontDecorated, extraction.problem, previousFront);
                ((Resolution)extraction).solveInstance(0);
                List<Constraint> list = extraction.lastCore();
                if (list == null) {
                    Kit.log.info("OUT UB FOUND = " + selectedFrontDecorated.cost);
                    break;
                }
                previousFront = selectedFrontDecorated.front;
                integration.addNeighBorsOf2(integration.queueOfFrontDecorated, list.toArray(new Constraint[list.size()]), selectedFrontDecorated);
            }
            Kit.log.info("SOLUTION : " + Kit.join((Object)extraction.solver.solManager.lastSolution, new String[0]));
        } else {
            while (true) {
                ((Resolution)extraction).solveInstance(0);
                List<Constraint> list = extraction.lastCore();
                if (list == null) break;
                integration.relaxMuc(list.toArray(new Constraint[list.size()]), extraction.problem);
            }
            Kit.log.info("SOLUTION : " + Kit.join((Object)extraction.solver.solManager.lastSolution, new String[0]));
        }
    }

    static class PoolOfFrontDecorated {
        private List<FrontDecorated> available = new LinkedList<FrontDecorated>();

        private PoolOfFrontDecorated(int nResources, Integration integration) {
            for (int i = 0; i < nResources; ++i) {
                this.available.add(new FrontDecorated());
            }
        }

        public FrontDecorated getFrontDecorated() {
            return this.available.size() > 0 ? this.available.remove(0) : null;
        }
    }

    private static class FrontDecorated {
        public int[] front;
        public long cost;
        public long score;

        public FrontDecorated() {
        }

        public FrontDecorated(int[] t, long cost, long score) {
            this.front = t;
            this.cost = cost;
            this.score = score;
        }

        public String toString() {
            return Kit.join((Object)this.front, new String[0]) + " , cost=" + this.cost + " , score=" + this.score;
        }
    }
}

