/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import constraints.hard.extension.structures.Bits;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.Matrix3D;
import dashboard.ControlPanelSettings;
import dashboard.ControlPanelVariables;
import executables.Extraction;
import heuristics.revisions.HeuristicRevisions;
import heuristics.revisions.HeuristicRevisionsDynamic;
import heuristics.values.HeuristicValues;
import heuristics.values.direct.First;
import heuristics.values.direct.Last;
import heuristics.values.direct.MinCost;
import heuristics.variables.HeuristicVariables;
import heuristics.variables.dynamic.WDegOnDom;
import java.io.File;
import java.util.logging.Level;
import org.xcsp.common.Types;
import org.xcsp.modeler.Compiler;
import propagation.order1.AC;
import propagation.order1.failed.FailedValueBasedConsistency;
import propagation.soft.pfc.RDAC_WCSP_STR;
import propagation.soft.sac.SoftAC;
import propagation.structures.forSac.QueueOfCells;
import propagation.structures.revisers.Reviser;
import propagation.structures.revisers.Reviser1;
import propagation.structures.revisers.Reviser3;
import search.SolutionManager;
import search.backtrack.LNS.heuristics.HeuristicFreezing;
import search.backtrack.LNS.heuristics.Rand;
import search.backtrack.SolverBacktrack;
import search.backtrack.localBranching.LBAtMostDistanceSum;
import search.backtrack.localBranching.LocalBranchingConstraints;
import search.local.neighborHeuristics.BestGlobal;
import search.local.neighborHeuristics.TabuManagerVariableValue;
import utility.Enums;
import utility.Kit;
import utility.Reflector;

public class ControlPanel {
    public final String settingsFilename = staticUserSettingsFilename;
    public final ControlPanelSettings settings = new ControlPanelSettings(this.settingsFilename);
    public final Xml xml = new Xml();
    public final boolean export;
    public final boolean competitionMode;
    public final General general;
    public Types.TypeFramework framework;
    public final int verbose;
    public final Problem problem;
    public final boolean symmetryBreaking;
    public final Variables variables;
    public final ControlPanelVariables cpv;
    public final Constraints constraints;
    public final Global global;
    public final Extension extension;
    public final Optimizing optimizing;
    public final Propagating propagating;
    public final Shaving shaving;
    public final LargeNeighborhoodSearch lns;
    public final LocalBranching lb;
    public final Solving solving;
    public final Restarting restarting;
    public final Learning learning;
    public final Extracting extracting;
    public final VariableHeuristic varh;
    public final ValueHeuristic valh;
    public final RevisionHeuristic revh;
    public final NeighborHeuristic nghh;
    public final Integrating integrating;
    public final Experimental experimental;
    public final HardCoding hardCoding;
    public final boolean mustBuildConflictStructures;
    public static final String DEFAULT_CONFIGURATION = "defaultConfiguration";
    public static final String CONFIGURATION = "configuration";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String ALL = "all";
    private static String staticUserSettingsFilename;

    public void toCOP() {
        this.general.framework = Types.TypeFramework.COP;
        this.general.nSearchedSolutions = Long.MAX_VALUE;
        this.framework = Types.TypeFramework.COP;
    }

    private ControlPanel() {
        this.export = this.xml.export != Enums.EExport.NO;
        this.competitionMode = this.xml.competitionMode;
        this.general = new General();
        this.framework = this.general.framework;
        this.verbose = this.general.verbose;
        this.problem = new Problem();
        this.symmetryBreaking = this.problem.symmetryBreaking != Enums.ESymmetryBreaking.NO;
        this.variables = new Variables();
        this.cpv = new ControlPanelVariables(this.variables);
        this.constraints = new Constraints();
        this.global = new Global();
        this.extension = new Extension();
        this.optimizing = new Optimizing();
        this.propagating = new Propagating();
        this.shaving = new Shaving();
        this.lns = new LargeNeighborhoodSearch();
        this.lb = new LocalBranching();
        this.solving = new Solving();
        this.restarting = new Restarting();
        this.learning = new Learning();
        this.extracting = new Extracting();
        this.varh = new VariableHeuristic();
        this.valh = new ValueHeuristic();
        this.revh = new RevisionHeuristic();
        this.nghh = new NeighborHeuristic();
        this.integrating = new Integrating();
        this.experimental = new Experimental();
        this.hardCoding = new HardCoding();
        this.mustBuildConflictStructures = this.settings.addB(3, "constraints", "mustBuildConflictStructures", "mbcs", !this.propagating.classForRevisions.equals(Reviser1.class.getSimpleName()) || !this.valh.classForValHeuristic.equals(First.class.getSimpleName()) && !this.valh.classForValHeuristic.equals(Last.class.getSimpleName()), "");
        Kit.control(this.verbose >= 0 && this.verbose <= 3, () -> "Verbose must be in 0..3");
        Kit.log.setLevel(this.verbose == 0 ? Level.CONFIG : (this.verbose == 1 ? Level.FINE : (this.verbose == 2 ? Level.FINER : Level.FINEST)));
        if (this.general.conditionForSatisfaction.trim().length() != 0) {
            String s = this.general.conditionForSatisfaction;
            Kit.control(s.matches("\\((lt|le|ge|gt|ne|eq),\\d+\\)"), () -> "Bad form of the condition for satisfaction : " + s);
        }
        Kit.control(!this.propagating.clazz.equals(SoftAC.class.getSimpleName()) || this.optimizing.costTranfer != Enums.ECostTranfer.INVARIABLE, () -> "SoftAC requires tranferts of cost. See -ct.");
        Kit.control(!this.propagating.clazz.equals(RDAC_WCSP_STR.class.getSimpleName()) || this.extension.positive == Enums.EExtension.STR1 || this.extension.positive == Enums.EExtension.STR2, () -> "WSTR requires str1 or str2 as representation. See -rn.");
        Kit.control(0 <= this.lns.pVariablesToFreeze && this.lns.pVariablesToFreeze < 100, () -> "percentageOfVariablesToFreeze should be between 0 and 100 (excluded)");
        Kit.control(this.problem.symmetryBreaking == Enums.ESymmetryBreaking.REC || this.learning.nogood != Enums.ELearningNogood.RST_SYM);
        Kit.control(this.optimizing.lowerBound <= this.optimizing.upperBound);
        Kit.control(this.framework != Types.TypeFramework.WCSP || 0L <= this.optimizing.lowerBound && this.optimizing.lowerBound < this.optimizing.upperBound);
        Kit.control(!this.constraints.normalizeCtrs || !this.symmetryBreaking && this.framework != Types.TypeFramework.MAXCSP);
        this.settings.controlKeys();
        if (this.general.makeExceptionsVisible) {
            Compiler.ev = true;
        }
    }

    public void updateBoundsForWCSP(long initialCost, long maximalCost) {
        Kit.control(this.framework == Types.TypeFramework.WCSP);
        if (initialCost > this.optimizing.lowerBound) {
            this.optimizing.lowerBound = initialCost;
            Kit.log.warning("Nullary cost (c0) for WCSP increased to " + this.optimizing.lowerBound);
        }
        if (maximalCost < this.optimizing.upperBound) {
            this.optimizing.upperBound = maximalCost;
            Kit.log.warning("Upper Bound for WCSP reduced to " + this.optimizing.upperBound);
        }
        Kit.control(0L <= this.optimizing.lowerBound && this.optimizing.lowerBound < this.optimizing.upperBound);
    }

    public static synchronized ControlPanel buildControlPanelFor(String userSettingsFilename) {
        staticUserSettingsFilename = userSettingsFilename;
        return new ControlPanel();
    }

    public static void main(String[] args) {
        Integer maximumPriority;
        Integer n = maximumPriority = args.length != 2 ? null : Kit.parseInteger(args[1]);
        if (args.length != 2 || maximumPriority == null || maximumPriority < 1 || maximumPriority > 3) {
            System.out.println("\tTool used to generate a default configuration file.");
            System.out.println("\tUsage : " + ControlPanel.class.getName() + " <outputFileName> <maximumPriority>");
            System.out.println("\n\toutputFileName : name of the generated configuration file.");
            System.out.println("\n\tmaximumPriority : the generated file contains only parameters with a priority value lower than this number (must be between 1 and 3)");
        } else {
            new File(Kit.getPathOf(args[0])).mkdirs();
            ControlPanelSettings.saveControlPanelSettings(ControlPanel.buildControlPanelFor(null), args[0] + (args[0].endsWith(".xml") ? "" : ".xml"), maximumPriority);
        }
    }

    public class HardCoding
    extends SettingGroup {
        public final boolean localSearchAtPreprocessing = false;
        public final int limitOfNbValuesForStrongConsistency = 50000;
        public boolean splitMDDConstraints;
        public final boolean weightingIncrementInConflictManager = true;
        public final String classForDecompositionSolver = "Decomposer2";
        public final long relationContractionLimit = 100000000L;
        public boolean convertBooleanSumAsCountingCtr;

        public HardCoding() {
            this.localSearchAtPreprocessing = false;
            this.limitOfNbValuesForStrongConsistency = 50000;
            this.splitMDDConstraints = false;
            this.weightingIncrementInConflictManager = true;
            this.classForDecompositionSolver = "Decomposer2";
            this.relationContractionLimit = 100000000L;
            this.convertBooleanSumAsCountingCtr = false;
        }
    }

    public class Experimental
    extends SettingGroup {
        public final boolean testB;
        public int testI1;
        public int testI2;
        public int testI3;
        public final boolean helene;
        public final boolean save4Baudouin;

        public Experimental() {
            this.testB = this.addB("testB", "test", false, "", 4);
            this.testI1 = this.addI("testI1", "testI1", 0, "", 4);
            this.testI2 = this.addI("testI2", "testI2", 0, "", 4);
            this.testI3 = this.addI("testI3", "testI3", 0, "", 4);
            this.helene = this.addB("helene", "helene", false, "", 4);
            this.save4Baudouin = this.addB("save4Baudouin", "s4b", false, "for synthetizing smart tables", 4);
        }
    }

    public class Integrating
    extends SettingGroup {
        String s_much;
        String s_ca;
        String QueuePatternAndDominance;
        String StackPattern;
        String MustBuildConflictStructures;
        public final int mucHeuristic;
        public final boolean mucCompleteApproach;

        public Integrating() {
            this.s_much = "The available heuristics for extraction of MUCS in wcsp context approach.\n\tIf the value of this parameter is 1, then random relaxation of MUC.\n\tIf the value of this parameter is 2, then relaxation of MUC with minimal cost and greater random score of the current constraint relaxed.\n\tIf the value of this parameter is 3, then relaxation of MUC with minimal cost and greater weighted degreee of the current constraint relaxed.\n\tIf the value of this parameter is 4, then relaxation of MUC with minimal cost and greater nb filterings of the current constraint relaxed.\n\tIf the value of this parameter is 5, then relaxation of MUC with minimal cost and greater product of weighted degrees of variables of the scope of the current constraint relaxed.\n\tIf the value of this parameter is 6, then relaxation of MUC with minimal cost and greater age of the current constraint relaxed.";
            this.s_ca = "If the value of this parameter is true, then complete approach of relaxation of MUC is used, otherwiwe greedy approach is used.";
            this.QueuePatternAndDominance = "If the value of this parameter is true, then complete approach of relaxation of MUC is used with a queue and patterns.";
            this.StackPattern = "If the value of this parameter is true, then complete approach of relaxation of MUC is used with a stack and patterns.";
            this.MustBuildConflictStructures = "";
            this.mucHeuristic = this.addI("mucHeuristic", "i_much", 5, this.s_much, new int[0]);
            this.mucCompleteApproach = this.addB("mucCompleteApproach", "i_ca", true, this.s_ca, new int[0]);
        }
    }

    public class NeighborHeuristic
    extends SettingGroup {
        public final String classForNeighborHeuristic;
        public final String classForTabu;
        public final int tabuListSize;
        public final double thresholdForRandomVariableSelection;
        public final double thresholdForRandomValueSelection;

        public NeighborHeuristic() {
            this.classForNeighborHeuristic = this.addS("classForNeighborHeuristic", "cnh", BestGlobal.class, "", new int[0]);
            this.classForTabu = this.addS("classForTabu", "cft", TabuManagerVariableValue.class, "", new int[0]);
            this.tabuListSize = this.addI("tabuListSize", "tabs", 5, "", new int[0]);
            this.thresholdForRandomVariableSelection = this.addD("thresholdForRandomVariableSelection", "trvars", 0.0, "", new int[0]);
            this.thresholdForRandomValueSelection = this.addD("thresholdForRandomValueSelection", "trvals", 0.0, "", new int[0]);
        }
    }

    public class RevisionHeuristic
    extends SettingGroup {
        String s1;
        String s2;
        public final String classForRevHeuristic;
        public final boolean anti;

        public RevisionHeuristic() {
            this.s1 = "The name of the class that represents the revision ordering heuristic.";
            this.s2 = "Indicates if we must follow the anti-heuristic.";
            this.classForRevHeuristic = this.addS("classForRevHeuristic", "revh", HeuristicRevisionsDynamic.Dom.class, HeuristicRevisions.class, this.s1, new int[0]);
            this.anti = this.addB("anti", "anti_revh", false, this.s2, new int[0]);
        }
    }

    public class ValueHeuristic
    extends SettingGroup {
        String s1;
        String s2;
        private final Class<?> valohDefault;
        public String classForValHeuristic;
        public final boolean anti;
        public final boolean optValHeuristic;

        public ValueHeuristic() {
            this.s1 = "The name of the class that selects the next value to be assigned to the last selected variable.\n\tAn example is valh=First that indicates that at each step the next value to be assigned is the first value in the current domain (a kind of lexicographic order).";
            this.s2 = "Indicates if we must follow the anti-heuristic.";
            this.valohDefault = ControlPanel.this.framework == Types.TypeFramework.WCSP ? MinCost.class : First.class;
            this.classForValHeuristic = this.addS("classForValHeuristic", "valh", this.valohDefault, HeuristicValues.class, this.s1, new int[0]);
            this.anti = this.addB("anti", "anti_valh", false, this.s2, new int[0]);
            this.optValHeuristic = this.addB("optValHeuristic", "ovh", false, "", new int[0]);
        }
    }

    public class VariableHeuristic
    extends SettingGroup {
        String s1;
        String s2;
        String s3;
        String s4;
        String s5;
        String s6;
        public String classForVarHeuristic;
        public final boolean anti;
        public int lastConflictSize;
        public final int initialWdeg;
        public final Enums.EWeighting weighting;
        public final Enums.ESingletonAssignment singletonAssignment;

        public VariableHeuristic() {
            this.s1 = "The name of the class that selects the variables to be assigned.\n\tFor example, Dom indicates that at each step the next variable to be instantiated is the one with the smallest domain.\n\tAnother example is varh=WDegOnDom that indicates that at each step the next variable to be instantiated is the one with the greatest ratio wdeg/dom,\n\t(which is equivalent to min dom/wdeg).";
            this.s2 = "Indicates if we must follow the anti-heuristic.";
            this.s3 = "With a value greater than or equal to 1, indicates that a reasoning from last conflicts must be used.";
            this.s4 = "";
            this.s5 = "";
            this.s6 = "";
            this.classForVarHeuristic = this.addS("classForVarHeuristic", "varh", WDegOnDom.class, HeuristicVariables.class, this.s1, new int[0]);
            this.anti = this.addB("anti", "anti_varh", false, this.s2, new int[0]);
            this.lastConflictSize = this.addI("lastConflictSize", "lc", 2, this.s3, new int[0]);
            this.initialWdeg = this.addI("initialWdeg", "iwd", 1, this.s4, new int[0]);
            this.weighting = this.addE("weighting", "wt", ControlPanel.this.framework == Types.TypeFramework.WCSP ? Enums.EWeighting.VAR : Enums.EWeighting.CA_CD, this.s5, new int[0]);
            this.singletonAssignment = this.addE("singletonAssignment", "sing", Enums.ESingletonAssignment.LAST, this.s6, new int[0]);
        }
    }

    public class Extracting
    extends SettingGroup {
        String s_m;
        String s_nc;
        String s_sc;
        public final Enums.EExtractionMethod method;
        public final int nCores;
        public final boolean saveCores;

        public Extracting() {
            this.s_m = "The way the unsatisfiable cores will be identified.\n\tValid only with the command: java " + Extraction.class.getName();
            this.s_nc = "The number of cores (MUCs) that must be found.\n\tValid only with the command: java " + Extraction.class.getName();
            this.s_sc = "Indicates if cores must be saved in XCSP";
            this.method = this.addE("method", "e_m", Enums.EExtractionMethod.VAR, this.s_m, new int[0]);
            this.nCores = this.addI("nCores", "e_nc", 1, this.s_nc, new int[0]);
            this.saveCores = this.addB("saveCores", "e_sc", false, this.s_sc, new int[0]);
        }
    }

    public class Learning
    extends SettingGroup {
        String s_ng;
        String s_bgbl;
        String s_ps;
        String s_pso;
        public Enums.ELearningNogood nogood;
        public final int nogoodBaseLimit;
        public final int nogoodArityLimit;
        public final int unarySymmetryLimit;
        public final int nonunarySymmetryLimit;
        public final boolean incrementNogoodWeight;
        public final Enums.ELearningState state;
        public final String stateOperators;
        public final int compressionLevelForStateEquivalence;
        public final int compressionLimitForStateEquivalence;

        public Learning() {
            this.s_ng = "Indicates the way nogoods are collected.\nBy default, this is nogood recording from restarts.";
            this.s_bgbl = "The limit, in term of number of nogoods, for the base.";
            this.s_ps = "Indicates the way partial states are collected.\nBy default, no such learning.";
            this.s_pso = "Indicates which operators are used to extract partial states: a sequence of 5 bits is used.";
            this.nogood = this.addE("nogood", "l_ng", Enums.ELearningNogood.RST, this.s_ng, new int[0]);
            this.nogoodBaseLimit = this.addI("nogoodBaseLimit", "l_ngbl", 2000000, this.s_bgbl, new int[0]);
            this.nogoodArityLimit = this.addI("nogoodArityLimit", "l_ngal", Integer.MAX_VALUE, "", 4);
            this.unarySymmetryLimit = this.addI("unarySymmetryLimit", "l_usl", Integer.MAX_VALUE, "", 4);
            this.nonunarySymmetryLimit = this.addI("nonunarySymmetryLimit", "l_nsl", 2000, "", 4);
            this.incrementNogoodWeight = this.addB("incrementNogoodWeight", "l_inw", false, "", 4);
            this.state = this.addE("state", "l_ps", Enums.ELearningState.NO, this.s_ps, new int[0]);
            this.stateOperators = this.addS("stateOperators", "l_pso", "11011", this.s_pso, new int[0]).trim();
            this.compressionLevelForStateEquivalence = this.addI("compressionLevelForStateEquivalence", "l_clevel", 0, "", 4);
            this.compressionLimitForStateEquivalence = this.addI("compressionLimitForStateEquivalence", "l_climit", 300, "", 4);
        }
    }

    public class Restarting
    extends SettingGroup {
        String s_n;
        String s_c;
        String s_f;
        String s_m;
        String s_rrp;
        String s_rrc;
        String s_rp;
        public int n;
        public long cutoff;
        public double factor;
        public final Enums.ERestartsMeasure measure;
        public int nRestartsResetPeriod;
        public final int nRestartsResetCoefficient;
        public final int hMeasureResetPeriod;

        public Restarting() {
            this.s_n = "The number of runs (restarts) to be performed.\n\tA value strictly greater than 1 is relevant only if a cutoff value is given.";
            this.s_c = "The number of the counter (number of backtracks, number of failed assignments, ...) before the solver restarts.\n\tWhen no value is given, the cutoff is set to Integer.MAX_VALUE.";
            this.s_f = "The geometric increasing factor of the number (e.g. the number of failed assignments) used to break successive runs.";
            this.s_m = "The kind of events to be counted so as to force restarts when the cutoof is reached.";
            this.s_rrp = "Period, in term of number of restarts, for resetting restart data.";
            this.s_rrc = "Coefficient used for increasing the cutoff, when restart data are reset";
            this.s_rp = "";
            this.n = this.addI("n", "r_n", Integer.MAX_VALUE, this.s_n, new int[0]);
            this.cutoff = this.addL("cutoff", "r_c", 10L, this.s_c, new int[0]);
            this.factor = this.addD("factor", "r_f", 1.1, this.s_f, new int[0]);
            this.measure = this.addE("measure", "r_m", Enums.ERestartsMeasure.FAILED, this.s_m, new int[0]);
            this.nRestartsResetPeriod = this.addI("nRestartsResetPeriod", "r_rrp", Integer.MAX_VALUE, this.s_rrp, new int[0]);
            this.nRestartsResetCoefficient = this.addI("nRestartsResetCoefficient", "r_rrc", 2, this.s_rrc, new int[0]);
            this.hMeasureResetPeriod = this.addI("hMeasureResetPeriod", "rp", Integer.MAX_VALUE, this.s_rp, new int[0]);
        }
    }

    public class Solving
    extends SettingGroup {
        String s_class;
        String s_prepro;
        String s_search;
        String s_branching;
        public String clazz;
        public boolean enablePrepro;
        public boolean enableSearch;
        public final Enums.EBranching branching;

        public Solving() {
            this.s_class = "The name of the class used to explore the search space.\n\tTypically, this is " + SolverBacktrack.class.getSimpleName();
            this.s_prepro = "If true, a preprocessing stage must be performed.";
            this.s_search = "If true, search must be performed.";
            this.s_branching = "The branching scheme used for search.\n\tPossible values are bin for binary branching, non for non-binary (or d-way) branching, and res for restricted binarybranching.";
            this.clazz = this.addS("clazz", "s_class", SolverBacktrack.class, this.s_class, new int[0]);
            this.enablePrepro = ControlPanel.this.export ? false : this.addB("enablePrepro", "prepro", true, this.s_prepro, new int[0]);
            this.enableSearch = ControlPanel.this.export ? false : this.addB("enableSearch", "search", true, this.s_search, new int[0]);
            this.branching = this.addE("branching", "branching", Enums.EBranching.BIN, this.s_branching, new int[0]);
        }
    }

    public class LocalBranching
    extends SettingGroup {
        private String s_e;
        private String s_n;
        private String s_bd;
        private String s_mr;
        public final boolean enabled;
        public final String neighborhood;
        public final int baseDistance;
        public final int maxRestarts;

        public LocalBranching() {
            this.s_e = "If true, local branching search is activated.";
            this.s_n = "The name of the class used for local branching constraints.";
            this.s_bd = "The maximum distance when exploring the neighborhood.";
            this.s_mr = "The max number of restarts for local branching before switching to classical search.";
            this.enabled = this.addB("enabled", "lb_e", false, this.s_e, new int[0]);
            this.neighborhood = this.addS("neighborhood", "lb_n", LBAtMostDistanceSum.class, LocalBranchingConstraints.class, this.s_n, new int[0]);
            this.baseDistance = this.addI("baseDistance", "lb_bd", 1, this.s_bd, new int[0]);
            this.maxRestarts = this.addI("maxRestarts", "lb_mr", 10, this.s_mr, new int[0]);
        }
    }

    public class LargeNeighborhoodSearch
    extends SettingGroup {
        String s_e;
        String s_n;
        String s_p;
        String s_frzh;
        public final boolean enabled;
        public final int nVariablesToFreeze;
        public final int pVariablesToFreeze;
        public final String freezingHeuristic;

        public LargeNeighborhoodSearch() {
            this.s_e = "If true, large neighborhood search is activated.";
            this.s_n = "The number of variables to freeze when restarting.";
            this.s_p = "The percentage of variables to freeze when restarting.";
            this.s_frzh = "The name of the class used to select the frozen variables when restarting.";
            this.enabled = this.addB("enabled", "lns_e", false, this.s_e, new int[0]);
            this.nVariablesToFreeze = this.addI("nVariablesToFreeze", "lns_n", 0, this.s_n, new int[0]);
            this.pVariablesToFreeze = this.addI("pVariablesToFreeze", "lns_p", 10, this.s_p, new int[0]);
            this.freezingHeuristic = this.addS("freezingHeuristic", "lns_frzh", Rand.class, HeuristicFreezing.class, this.s_frzh, new int[0]);
        }
    }

    public class Shaving
    extends SettingGroup {
        public int parameter;
        public final double eligibilityThreshod;
        public final int limitedPropagationSamplingSize;
        public final double ratio;
        public final double alpha;

        public Shaving() {
            this.parameter = this.addI("parameter", "s_p", 1, "", 4);
            this.eligibilityThreshod = this.addD("eligibilityThreshod", "s_et", 3.0, "", 4);
            this.limitedPropagationSamplingSize = this.addI("limitedPropagationSamplingSize", "s_lpss", 100, "", 4);
            this.ratio = this.addD("ratio", "s_r", 0.0, "", new int[0]);
            this.alpha = this.addD("alpha", "s_a", 0.0, "", new int[0]);
        }
    }

    public class Propagating
    extends SettingGroup {
        String s_p;
        String s_pv;
        String s_uaq;
        String s_rm;
        String r1;
        String r2;
        String q1;
        String q2;
        String q3;
        public String clazz;
        public final int variant;
        public final boolean useAuxiliaryQueues;
        public String classForRevisions;
        public boolean residues;
        public boolean bitResidues;
        public final boolean multidirectionality;
        public final int residueLimitForBitRm;
        public final int memoryLimitForBitRm;
        public final int futureLimitation;
        public final int spaceLimitation;
        public final int arityLimitForGACGuaranteed;
        public boolean strongOnlyAtPreprocessing;
        public final boolean strongOnlyWhenACEffective;
        public final boolean strongOnlyWhenNotSingleton;
        public final String classForSACSelector;
        public final int weakCutoff;
        public final String classForFailedValues;

        public Propagating() {
            this.s_p = "The name of the class used to propagate constraints.\n\tFor (G)AC, use AC. Among other possible values, we find SAC1, SAC3, ESAC3, CDC1, CPC1, DC1, DC2.";
            this.s_pv = "Variant for a second order consistency";
            this.s_uaq = "If enabled, queues of constraints are used in addition to the queue of variables. The purpose is to propagate less often the most costly constraints.";
            this.s_rm = "The name of the class used to perform revisions.";
            this.r1 = "Determines if residues must be exploited.\n\tFor CSP, that corresponds to use either (G)AC3 or (G)AC3rm";
            this.r2 = "Determines if bit residues must be exploited.";
            this.q1 = "For intension constraints, control the effort for (G)AC.\n\tGAC is not enforced if the current number of future variables is more than the specified value.";
            this.q2 = "For intension constraints, control the effort for (G)AC.\n\tGAC is not enforced if the size of the current Cartesian product is more than than 2 up the specified value.";
            this.q3 = "For intension constraints, GAC is guaranteed to be enforced if the arity is not more than the specified value.";
            this.clazz = this.addS("clazz", "p", AC.class, this.s_p, new int[0]);
            this.variant = this.addI("variant", "pv", 0, this.s_pv, 4);
            this.useAuxiliaryQueues = this.addB("useAuxiliaryQueues", "uaq", false, this.s_uaq, new int[0]);
            this.classForRevisions = this.addS("classForRevisions", "cr", Reviser3.class, Reviser.class, this.s_rm, new int[0]);
            this.residues = this.addB("residues", "res", true, this.r1, new int[0]);
            this.bitResidues = this.addB("bitResidues", "bres", true, this.r2, new int[0]);
            this.multidirectionality = this.addB("multidirectionality", "mul", true, "", new int[0]);
            this.residueLimitForBitRm = this.addI("residueLimitForBitRm", "rbit", 499, "", new int[0]);
            this.memoryLimitForBitRm = this.addI("memoryLimitForBitRm", "mbit", 550000000, "", new int[0]);
            this.futureLimitation = this.addI("futureLimitation", "fl", -1, this.q1, new int[0]);
            this.spaceLimitation = this.addI("spaceLimitation", "sl", 20, this.q2, new int[0]);
            this.arityLimitForGACGuaranteed = this.addI("arityLimitForGACGuaranteed", "aggac", 2, this.q3, new int[0]);
            this.strongOnlyAtPreprocessing = this.addB("strongOnlyAtPreprocessing", "sop", false, "", new int[0]);
            this.strongOnlyWhenACEffective = this.addB("strongOnlyWhenACEffective", "soe", false, "", new int[0]);
            this.strongOnlyWhenNotSingleton = this.addB("strongOnlyWhenNotSingleton", "sons", true, "", new int[0]);
            this.classForSACSelector = this.addS("classForSACSelector", "csac", QueueOfCells.WDegOnDomSelector.class, "", new int[0]);
            this.weakCutoff = this.addI("weakCutoff", "wc", 15, "", new int[0]);
            this.classForFailedValues = this.addS("classForFailedValues", "fvc", null, FailedValueBasedConsistency.class, "", 4);
        }
    }

    public class Optimizing
    extends SettingGroup {
        String s_lb;
        String s_ub;
        String s_os;
        String s_ct;
        String s_astr;
        String s_estr;
        public long lowerBound;
        public long upperBound;
        public final Enums.EOptimizationStrategy optimizationStrategy;
        public final Enums.ECostTranfer costTranfer;
        public final int arityLimitForSoftSTR;
        public final boolean ecostForSoftSTR;
        public final int softSubstituability;

        public Optimizing() {
            this.s_lb = "The specified value indicates the initial lower bound. When the solver gets a solution less than or equal to this value, it stops.";
            this.s_ub = "The specified value indicates the initial upper bound.\n\tFor a WCSP instance, this is the initial forbidden cost (allowed maximal cost plus one).";
            this.s_os = "For COP, the way bound intervals are managed.";
            this.s_ct = "For WCSP, the way cost transferts are managed.";
            this.s_astr = "The specified value indicates the arity that determines the use of Soft STR constraints (if required by other configuration parameters; for a WCSP instance.";
            this.s_estr = "The specified value indicates if GAC or GACw is enforced for Soft STR constraints, for a WCSP instance.";
            this.lowerBound = this.addL("lowerBound", "lb", ControlPanel.this.framework == Types.TypeFramework.WCSP || ControlPanel.this.framework == Types.TypeFramework.MAXCSP ? 0L : Long.MIN_VALUE, this.s_lb, new int[0]);
            this.upperBound = this.addL("upperBound", "ub", Long.MAX_VALUE, this.s_ub, new int[0]);
            this.optimizationStrategy = this.addE("optimizationStrategy", "os", Enums.EOptimizationStrategy.DECREASING, this.s_os, new int[0]);
            this.costTranfer = this.addE("costTranfer", "ct", Enums.ECostTranfer.INVARIABLE, this.s_ct, new int[0]);
            this.arityLimitForSoftSTR = this.addI("arityLimitForSoftSTR", "astr", 2, this.s_astr, 4);
            this.ecostForSoftSTR = this.addB("ecostForSoftSTR", "estr", false, this.s_estr, 4);
            this.softSubstituability = this.addI("softSubstituability", "ss", 0, "", 4);
        }
    }

    public class Extension
    extends SettingGroup {
        String s_positive;
        String s_negative;
        String s_ma;
        String s_mt;
        String s_wcnc;
        public final Enums.EExtension positive;
        public final Enums.EExtension negative;
        public final boolean validForBinary;
        public final String classForBinaryExtensionStructure;
        public final String classForTernaryExtensionStructure;
        public final int arityLimitForSwitchingToPositive;
        public final int arityLimitForSwitchingToNegative;
        public final boolean decremental;
        public final int variant;
        public final int arityLimitForIntensionToExtension;
        public final long validLimitForIntensionToExtension;
        public final boolean miningApriori;
        public double miningThreshold;
        public final Enums.EWCNConversion wcnConversion;
        public final boolean recordOriginalTuples;

        public Extension() {
            this.s_positive = "For (non-binary) constraints defined in extension, there are many ways of representing and propagating them.\n\tWe have v for GAC-valid, a for GAC-allowed, va for GAC-valid+allowed, str1 for simple tabular reduction, str2 and mdd...";
            this.s_negative = "For non-binary constraints defined in extension, representation of negative table constraints...";
            this.s_ma = "Indicates whether we must use the algorithm apriori for mining items in tables.";
            this.s_mt = "The threshold used for the selected mining technique.";
            this.s_wcnc = "When an instance is aimed at being saved in XCSP format, it is possible to convert a CN (in extensional form) into a WCN one.\n\tIf the value of this parameter is RANDOM, then random costs are generated:\n\t a) positive table : for supports (in table; random cost between [0,...,k-1] and defaultCost=k.\n\tb) negative table : for conflicts (in table; random cost between [1,...,k] and defaultCost=0.\n\tIf the value of this parameter is NATURAL, supports have cost 0 and conflicts have cost 1.\n\tNote that is is only currently implemented for instances with extensional constraints.";
            this.positive = this.addE("positive", "positive", Enums.EExtension.CT, this.s_positive, new int[0]);
            this.negative = this.addE("negative", "negative", Enums.EExtension.V, this.s_negative, new int[0]);
            this.validForBinary = this.addB("validForBinary", "vfor2", true, "", new int[0]);
            this.classForBinaryExtensionStructure = this.addS("classForBinaryExtensionStructure", "cfor2", Bits.class, "", new int[0]);
            this.classForTernaryExtensionStructure = this.addS("classForTernaryExtensionStructure", "cfor3", Matrix3D.class, "", new int[0]);
            this.arityLimitForSwitchingToPositive = this.addI("arityLimitForSwitchingToPositive", "ntop", -1, "", new int[0]);
            this.arityLimitForSwitchingToNegative = this.addI("arityLimitForSwitchingToNegative", "pton", -1, "", new int[0]);
            this.decremental = this.addB("decremental", "exd", true, "", new int[0]);
            this.variant = this.addI("variant", "exv", 0, "", new int[0]);
            this.arityLimitForIntensionToExtension = this.addI("arityLimitForIntensionToExtension", "aie", 0, "", new int[0]);
            this.validLimitForIntensionToExtension = this.addL("validLimitForIntensionToExtension", "vie", 2000000L, "", new int[0]);
            this.miningApriori = this.addB("miningApriori", "ma", false, this.s_ma, 4);
            this.miningThreshold = this.addD("miningThreshold", "mt", 0.1, this.s_mt, 4);
            this.wcnConversion = this.addE("wcnConversion", "wcnc", Enums.EWCNConversion.NO, this.s_wcnc, 4);
            this.recordOriginalTuples = ControlPanel.this.export ? true : this.addB("recordOriginalTuples", "rot", false, "Keep original tuples in " + ExtensionStructureHard.class.getName(), 4);
        }
    }

    public class Global
    extends SettingGroup {
        String s1;
        String s;
        String r1;
        String r2;
        String r3;
        public final boolean priorityType0;
        public final int typeAllDifferent;
        public final int typeDistinctVectors2;
        public final int typeDistinctVectorsK;
        public final int typeAllDifferentMatrix;
        public final int typeAllEqual;
        public final int typeNotAllEqual;
        public final int typeInstantiation;
        public final int typeClause;
        public final int typeOrdered;
        public final int typeNoOverlap;
        public final boolean basicTable;
        public final boolean jokerTable;
        public final boolean smartTable;

        public Global() {
            this.s1 = "Type 0 for propagators will be the priority choice in case of export.";
            this.s = "Allows the user to select the propagator for ";
            this.r1 = "When set to yes, some global constraints are encoded into classical table constraintss.";
            this.r2 = "When set to yes, some global constraints are encoded into joker table constraintss.";
            this.r3 = "When set to yes, some global constraints are encoded into smart table constraints.";
            this.priorityType0 = this.addB("priorityType0", "g_pt0", true, this.s1, new int[0]);
            this.typeAllDifferent = this.addI("typeAllDifferent", "g_ad", 0, this.s + "allDifferent", new int[0]);
            this.typeDistinctVectors2 = this.addI("typeDistinctVectors2", "g_dv2", 0, this.s + "distinctvectors2", new int[0]);
            this.typeDistinctVectorsK = this.addI("typeDistinctVectorsK", "g_dvk", 1, this.s + "distinctVectorsK", new int[0]);
            this.typeAllDifferentMatrix = this.addI("typeAllDifferentMatrix", "g_adm", 1, this.s + "allDifferentMatrix", new int[0]);
            this.typeAllEqual = this.addI("typeAllEqual", "g_ae", 0, this.s + "allEqual", new int[0]);
            this.typeNotAllEqual = this.addI("typeNotAllEqual", "g_nae", 0, this.s + "notAllEqual", new int[0]);
            this.typeInstantiation = this.addI("typeInstantiation", "g_ins", 1, this.s + "instantiation", new int[0]);
            this.typeClause = this.addI("typeClause", "g_cla", 1, this.s + "clause", new int[0]);
            this.typeOrdered = this.addI("typeOrdered", "g_ord", 1, this.s + "odered", new int[0]);
            this.typeNoOverlap = this.addI("typeNoOverlap", "g_no", 10, this.s + "noOverlap", new int[0]);
            this.basicTable = this.addB("basicTable", "bt", false, this.r1, new int[0]);
            this.jokerTable = this.addB("jokerTable", "jt", false, this.r2, new int[0]);
            this.smartTable = this.addB("smartTable", "st", false, this.r3, new int[0]);
        }
    }

    public class Constraints
    extends SettingGroup {
        String s_ignoreType;
        String s_ignoreArity;
        String r2;
        String r5;
        public boolean preserveUnaryCtrs;
        public final Types.TypeCtr ignoredCtrType;
        public final int ignoreCtrArity;
        public final boolean inferAllDifferent;
        public final int inferAllDifferentNb;
        public final int inferAllDifferentSize;
        public final boolean recognizePermutations;
        public final boolean recognizeBoundOrientedCtrs;
        public final int recognizeBoundOrientedCtrsLimit;
        public final int arityLimitForVapArray;
        public final int arityLimitForVapArrayUB;
        public boolean normalizeCtrs;

        public Constraints() {
            this.s_ignoreType = "Ignore all constraints of this type. Works for XCSP3";
            this.s_ignoreArity = "Ignore all constraints of this arity. Works for XCSP3";
            this.r2 = "When set to yes, redundant allDifferent constraints are sought and posted (if any) to improve the filtering capability of the solver.\n\tTry this on a pigeons instance.";
            this.r5 = "Create Permutation constraints instead of classic AllDifferent when possible. Less filtering but may be faster.";
            this.preserveUnaryCtrs = this.addB("preserveUnaryCtrs", "puc", true, "", new int[0]);
            this.ignoredCtrType = (Types.TypeCtr)Types.valueOf(Types.TypeCtr.class, (String)this.addS("ignoreCtrType", "ignoreType", "", this.s_ignoreType, new int[0]));
            this.ignoreCtrArity = this.addI("ignoreCtrArity", "ignoreArity", -1, this.s_ignoreArity, new int[0]);
            this.inferAllDifferent = this.addB("inferAllDifferent", "iad", false, this.r2, new int[0]);
            this.inferAllDifferentNb = this.addI("inferAllDifferentNb", "iadnb", Integer.MAX_VALUE, "", new int[0]);
            this.inferAllDifferentSize = this.addI("inferAllDifferentSize", "iadsz", 3, "", new int[0]);
            this.recognizePermutations = this.addB("recognizePermutations", "perm", false, this.r5, new int[0]);
            this.recognizeBoundOrientedCtrs = this.addB("recognizeBoundOrientedCtrs", "boc", false, "", new int[0]);
            this.recognizeBoundOrientedCtrsLimit = this.addI("recognizeBoundOrientedCtrLimit", "bocl", 300, "", new int[0]);
            this.arityLimitForVapArray = this.addI("arityLimitForVapArray", "alvalb", 2, "", new int[0]);
            this.arityLimitForVapArrayUB = this.addI("arityLimitForVapArrayUB", "alvaub", 100000, "", new int[0]);
            this.normalizeCtrs = this.addB("normalizeCtrs", "nc", false, "Merging constraints of similar scope (when possible)", 4);
        }
    }

    public class Variables
    extends SettingGroup {
        String s_sel;
        String s_ins;
        String s_pr1;
        String s_pr2;
        String s_riv;
        protected final String selection;
        protected final String instantiation;
        protected final String priority1Vars;
        protected final String priority2Vars;
        public final boolean reduceIsolatedVars;

        public Variables() {
            this.s_sel = "Allows us to give a list of variable that will form the subproblem to be solved.\n\tThis list is composed of a sequence of tokens separated by commas (no whitespace).\n\tEach token is a variable id a variable number or an interval of the form i..j with i and j integers.\n\tFor example, -sel=2..10,31,-4 will denote the list 2 3 5 6 7 8 9 10 31.\n\tThis is only valid for a XCSP instance.";
            this.s_ins = "Allows us to give an instantiation of variables for the problem to be solved.\n\tThis instantiation is given under the form vars:values.\n\tvars is a sequence of variable ids or numbers separated by commas (no whitespace).\n\tvalues is a sequence of integers (the values for variables) separated by commas (no whitespace).\n\tFor example, -ins=x2,x4,x9:1,11,4 will denote the instantiation {x2=1,x4=11,x9=4}.";
            this.s_pr1 = "Allows us to give a list of variables that will become strict priority variables (to be used by the variable ordering heuristic).\n\tThis list is composed of a sequence of strings (ids of variables) or integers (numbers of variables) separated by commas (no whitespace).\n\tFor example, -pr1=2,8,1,10 will denote the list 2 8 1 10.";
            this.s_pr2 = "Allows us to give a list of variables that will become (non strict) priority variables.\n\tThis list is composed of a sequence of tokens separated by commas (no whitespace).\n\tEach token is variable id, a variable number (integer) or an interval of the form i..j with i and j integers..\n\tFor example, -pr2=2..10,31,-4 will denote the list 2 3 5 6 7 8 9 10 31.";
            this.s_riv = "When set to true, only keep one arbitrary value in the domain of each variable involved in no constraint.";
            this.selection = this.addS("selection", "sel", "", this.s_sel, new int[0]);
            this.instantiation = this.addS("instantiation", "ins", "", this.s_ins, new int[0]);
            this.priority1Vars = this.addS("priority1Vars", "pr1", "", this.s_pr1, new int[0]);
            this.priority2Vars = this.addS("priority2Vars", "pr2", "", this.s_pr2, new int[0]);
            this.reduceIsolatedVars = this.addB("reduceIsolatedVars", "riv", true, this.s_riv, new int[0]);
        }
    }

    public class Problem
    extends SettingGroup {
        String s_data;
        String s_dataFormat;
        String s_dataexport;
        String s_variant;
        String s_sb;
        String s_sbv;
        String s_cg;
        String s_be;
        public final String data;
        public final String dataFormat;
        public final boolean dataexport;
        public final String variant;
        public final Enums.ESymmetryBreaking symmetryBreaking;
        public final boolean shareBitVectors;
        public final boolean completeGraph;
        public final Enums.EBinaryEncoding binaryEncoding;

        public Problem() {
            this.s_data = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_dataFormat = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_dataexport = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_variant = "Parameter similar to the one defined for " + Compiler.class.getName();
            this.s_sb = "Allows us to post (if possible) symmetry breaking constraints using the method described in [Lecoutre and Tabary 2009].\n\tSaucy is required to run the different methods.";
            this.s_sbv = "Try to save space by sharing bit vectors.";
            this.s_cg = "Add binary constraints to get a complete constraint graph.";
            this.s_be = "Transforms a CN only involving (non-binary) extensional constraints into a binary CN.\n\tCurrently, only works for XCSP2. To be implemented for XCSP3 for just the hidden encoding.";
            this.data = this.addS("data", "data", "", this.s_data, new int[0]);
            this.dataFormat = this.addS("dataFormat", "dataFormat", "", this.s_dataFormat, new int[0]);
            this.dataexport = this.addB("dataexport", "dataexport", false, this.s_dataexport, new int[0]);
            this.variant = this.addS("variant", "variant", "", this.s_variant, new int[0]);
            this.symmetryBreaking = this.addE("symmetryBreaking", "sb", Enums.ESymmetryBreaking.NO, this.s_sb, new int[0]);
            this.shareBitVectors = this.addB("shareBitVectors", "sbv", false, this.s_sbv, 4);
            this.completeGraph = this.addB("completeGraph", "cg", false, this.s_cg, 4);
            this.binaryEncoding = this.addE("binaryEncoding", "be", Enums.EBinaryEncoding.NO, this.s_be, 4);
        }
    }

    public class General
    extends SettingGroup {
        String s_framework;
        String s_s;
        String s_timeout;
        String s_verbose;
        String s_trace;
        String s_seed;
        String s_ev;
        String s_ea;
        String l_cfs;
        String s_cfs;
        String s_rs;
        public Types.TypeFramework framework;
        public long nSearchedSolutions;
        public final long timeout;
        public final int verbose;
        public final String trace;
        public final long seed;
        public final boolean makeExceptionsVisible;
        public final boolean enableAnnotations;
        public final long limitForSatisfaction;
        public final String conditionForSatisfaction;
        public final boolean recordSolutions;
        public final String saveNetworkGraph;

        public General() {
            this.s_framework = "The kind of problem instance to be solved (the specified value is case-insensitive).";
            this.s_s = "The number of solutions that must be found before the solver stops.\n\tFor all solutions, use -s=all or -s=max.";
            this.s_timeout = "The number of milliseconds that are passed before the solver stops.\n\tYou can use the letter s as a suffix to denote seconds as e.g., -t=10s.\n\tFor no timeout, use -t= or -t=max.";
            this.s_verbose = "Displays more or less precise information concerning the problem instance and the solution(s) found.\n\tThe specified value must belong  in {0,1,2,3}.\n\tThis mode is used as follows.\n\t0 : only some global statistics are listed ;\n\t1 : in addition, solutions are  shown ;\n\t2 : in addition, additionnal information about the problem instance to be solved is given ;\n\t3 : in addition, for each constraint, allowed or unallowed tuples are displayed.";
            this.s_trace = "Displays every decision taken during search with -trace.\n\tYou can control the trace with a required min depth and/or max depth as eg -trace=10-20.";
            this.s_seed = "The seed that can be used for some random-based methods.";
            this.s_ev = "Makes exceptions visible.";
            this.s_ea = "Enables annotations (currently, mainly concerns priority variables).";
            this.l_cfs = "Only valid if a COP is loaded and if the framework is set to CSP by the user.\n\tIn that case, the objective is turned into a constraint specified by this limit.";
            this.s_cfs = "Only valid if a COP is loaded and if the framework is set to CSP by the user.\n\tIn that case, the objective is turned into a constraint specified by this condition.\t The condition has the form (operator,value) as e.g., (lt,10). Currently, not operative, so must be implemented for XCSP3";
            this.s_rs = "Records all found solutions in a list of " + SolutionManager.class.getName();
            this.framework = this.addE("framework", "f", Types.TypeFramework.CSP, this.s_framework, new int[0]);
            this.nSearchedSolutions = this.addL("nSearchedSolutions", "s", this.framework == Types.TypeFramework.CSP ? 1L : Long.MAX_VALUE, this.s_s, new int[0]);
            this.timeout = this.addL("timeout", "t", Long.MAX_VALUE, this.s_timeout, new int[0]);
            this.verbose = this.addI("verbose", "v", ControlPanel.this.xml.export != Enums.EExport.NO ? 0 : 1, this.s_verbose, new int[0]);
            this.trace = this.addS("trace", "trace", "", this.s_trace, new int[0]);
            this.seed = this.addL("seed", "seed", 0L, this.s_seed, new int[0]);
            this.makeExceptionsVisible = this.addB("makeExceptionsVisible", "ev", false, this.s_ev, new int[0]);
            this.enableAnnotations = this.addB("enableAnnotations", "ea", false, this.s_ea, new int[0]);
            this.limitForSatisfaction = this.addL("limitForSatisfaction", "lfs", Long.MAX_VALUE, this.l_cfs, new int[0]);
            this.conditionForSatisfaction = this.addS("conditionForSatisfaction", "cfs", "", this.s_cfs, 4);
            this.recordSolutions = this.addB("recordSolutions", "rs", false, this.s_rs, 4);
            this.saveNetworkGraph = this.addS("saveNetworkGraph", "sng", "", "Three bits indicating if we need respectively a macro, positive and primal graph", new int[0]);
        }
    }

    public class Xml
    extends SettingGroup {
        String s_dc;
        String s_ic;
        String s_cm;
        String s_export;
        String s_exportMoment;
        String s_dir;
        String s_kin;
        String s_iag;
        String s_sis;
        String s_dpri;
        public final String discardedClasses;
        public final boolean indentAndCompressUnderLinux;
        public final boolean competitionMode;
        public final Enums.EExport export;
        public final Enums.EExportMoment exportMoment;
        public final String dirForCampaign;
        public final boolean keepInstanceName;
        public final boolean ignoreAutomaticGroups;
        public final boolean saveImmediatelyStored;
        public final boolean displayPrimitives;

        public Xml() {
            this.s_dc = "Names of classes (tags) to discard (use comma as separator if several classes). Effective iff an XCSP3 file is loaded.";
            this.s_ic = "Operations to perform when saving an XCSP3 file.";
            this.s_cm = "Output made compatible with XCSP3 competitions";
            this.s_export = "Indicates if the instance must be printed in XCSP3 format on the standard output, or in a file. No export by default.";
            this.s_exportMoment = "Indicates at which moment the export operation should be conducted.";
            this.s_dir = "Indicates the name of a directory where results (XML files) for a campaign will be stored.\n\tIf the value is the empty string, results are not saved.";
            this.s_kin = "When saving in XCSP3, indicates if the initial name of the instance must be preserved.";
            this.s_iag = "When compiling to XCSP3, avoids to build groups automatically";
            this.s_sis = "When compiling to XCSP3, avoids to group constraints that are separated";
            this.s_dpri = "Displays recognized primitives, at parsing time";
            this.discardedClasses = this.addS("discardedClasses", "dc", "", this.s_dc, new int[0]);
            this.indentAndCompressUnderLinux = this.addB("indentAndCompressUnderLinux", "ic", true, this.s_ic, new int[0]);
            this.competitionMode = this.addB("competitionMode", "cm", false, this.s_cm, new int[0]);
            this.export = this.addE("export", "export", Enums.EExport.NO, this.s_export, new int[0]);
            this.exportMoment = this.addE("exportMoment", "exportMoment", Enums.EExportMoment.CONSTRUCTION, this.s_exportMoment, 4);
            this.dirForCampaign = this.addS("dirForCampaign", "dir", "", this.s_dir, new int[0]);
            this.keepInstanceName = this.addB("keepInstanceName", "kin", false, this.s_kin, 4);
            this.ignoreAutomaticGroups = this.addB("ignoreAutomaticGroups", "iag", false, this.s_iag, 4);
            this.saveImmediatelyStored = this.addB("saveImmediatelyStored", "sis", true, this.s_sis, 4);
            this.displayPrimitives = this.addB("displayPrimitives", "dpri", false, this.s_dpri, 4);
        }
    }

    class SettingGroup {
        protected static final int HIDDEN = 4;
        protected static final int TO_IMPLEMENT = 4;

        SettingGroup() {
        }

        protected String tag() {
            return this.getClass().getSimpleName().substring(0, 1).toLowerCase() + this.getClass().getSimpleName().substring(1);
        }

        private int pr(int[] t) {
            return t.length == 0 ? 1 : (t.length == 1 ? t[0] : (Integer)Kit.exit("Only zero or one priority value expected"));
        }

        protected int addI(String attribute, String shortcut, int defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addI(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected long addL(String attribute, String shortcut, long defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addL(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected double addD(String attribute, String shortcut, double defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addD(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected boolean addB(String attribute, String shortcut, boolean defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addB(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected String addS(String attribute, String shortcut, String defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addS(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }

        protected String addS(String attribute, String shortcut, Class<?> defaultValue, Class<?> root, String description, int ... priority) {
            return ControlPanel.this.settings.addS(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, root, description);
        }

        protected String addS(String attribute, String shortcut, Class<?> defaultValue, String description, int ... priority) {
            return this.addS(attribute, shortcut, defaultValue, Reflector.getLastButOneSuperclassOf(defaultValue), description, new int[0]);
        }

        protected <T extends Enum<T>> T addE(String attribute, String shortcut, T defaultValue, String description, int ... priority) {
            return ControlPanel.this.settings.addE(this.pr(priority), this.tag(), attribute, shortcut, defaultValue, description);
        }
    }
}

