/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.CtrSoftExtensionSTR1;
import constraints.soft.extension.structures.SoftTable;
import java.util.Arrays;
import java.util.TreeSet;
import org.xcsp.common.Utilities;
import utility.Kit;
import utility.interfaces.ObjectIdentifiable;
import utility.observers.ObserverBacktrackingUnsystematic;
import utility.observers.ObserverConstructionProblem;
import utility.operations.Calculator;
import utility.sets.SetSparse;
import utility.sets.SetSparseMapLong;
import utility.sets.SetSparsePool;
import variables.Variable;
import variables.domains.Domain;

public final class SoftTableDelta
extends SoftTable
implements ObserverConstructionProblem,
ObserverBacktrackingUnsystematic {
    public long[][] deltas;
    protected int[] stackedLevels;
    protected int top = -1;
    protected SetSparseMapLong[] sparseMaps;
    protected int[] cumulatedSizes;
    private int[] idxToPosition;
    public boolean assertInCostOfIndexes = true;
    private TreeSet<PoolObject> treeSet;
    private SetSparsePool sparsePool;
    private SetSparse[] sortedDomains;
    private Kit.IntLongPair[] pairs;
    private int[] tuple;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        assert (this.stackedLevels[this.top] == depthBeforeBacktrack);
        int[] dense = this.sparseMaps[this.top].dense;
        for (int i = this.sparseMaps[this.top].limit; i >= 0; --i) {
            int index = dense[i];
            long delta = this.sparseMaps[this.top].values[index];
            int vap = this.idxToPosition[index];
            int idx = index - this.cumulatedSizes[vap];
            long gap = Calculator.add(this.deltas[vap][idx], -delta);
            Calculator.add(this.scopeC1s[vap], idx, -gap);
            this.deltas[vap][idx] = delta;
        }
        --this.top;
    }

    @Override
    public void storeTuplesAndCosts(int[][] ts, long[] costs, long defaultCost) {
        super.storeTuplesAndCosts(ts, costs, defaultCost);
        this.buildSpecificStructures(defaultCost);
    }

    protected void project(int vap, int idx, long cost) {
        assert (cost != 0L);
        Calculator.add(this.deltas[vap], idx, cost);
        Calculator.add(this.scopeC1s[vap], idx, cost);
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        int index;
        if (this.solver.depth() != this.lastModificationDepth()) {
            this.solver.observerCtrsSoft.push(this);
            ++this.top;
            this.stackedLevels[this.top] = this.solver.depth();
            if (this.sparseMaps[this.top] == null) {
                this.sparseMaps[this.top] = new SetSparseMapLong(this.sparseMaps[this.top - 1].capacity(), false);
            } else {
                this.sparseMaps[this.top].clear();
            }
        }
        if (!this.sparseMaps[this.top].isPresent(index = this.cumulatedSizes[vap] + idx)) {
            this.sparseMaps[this.top].add(index, this.deltas[vap][idx]);
        }
        this.project(vap, idx, cost);
    }

    public SoftTableDelta(Constraint ctr) {
        super(ctr);
        this.cumulatedSizes = Variable.buildCumulatedSizesArray(ctr.scp, true);
        this.deltas = new long[ctr.scp.length][];
        for (int i = 0; i < this.deltas.length; ++i) {
            this.deltas[i] = new long[ctr.scp[i].dom.initSize()];
        }
        ctr.pb.rs.observersConstructionProblem.add(this);
    }

    @Override
    public void onConstructionProblemFinished() {
        int nbLevels = this.firstRegisteredCtr().pb.variables.length + 1;
        this.stackedLevels = new int[nbLevels];
        this.sparseMaps = new SetSparseMapLong[nbLevels];
        this.sparseMaps[0] = new SetSparseMapLong(Variable.nInitValuesFor(this.firstRegisteredCtr().scp), false);
        this.idxToPosition = new int[this.sparseMaps[0].capacity()];
        int cnt = 0;
        for (int i = 0; i < this.firstRegisteredCtr().scp.length; ++i) {
            int nb = this.firstRegisteredCtr().scp[i].dom.initSize();
            for (int j = cnt; j < cnt + nb; ++j) {
                this.idxToPosition[j] = i;
            }
            cnt += nb;
        }
    }

    @Override
    public int lastModificationDepth() {
        return this.top == -1 ? -1 : this.stackedLevels[this.top];
    }

    public long getDeltaSumOfIndexes(int[] tuple) {
        long deltaSum = 0L;
        for (int i = 0; i < tuple.length; ++i) {
            deltaSum = Calculator.add(deltaSum, this.deltas[i][tuple[i]]);
        }
        return deltaSum;
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        long ub;
        long cost = super.getCostOfIdxs(tuple);
        return cost >= (ub = this.solver.solManager.bestBound) ? ub : Calculator.add(cost, -this.getDeltaSumOfIndexes(tuple));
    }

    @Override
    public long getCost(int i) {
        return this.getCostOfIdxs(this.tuples[i]);
    }

    private void buildSpecificStructures(long defaultCost) {
        Constraint ctr = this.firstRegisteredCtr();
        if (0L < defaultCost && defaultCost < ctr.pb.rs.cp.optimizing.upperBound && ctr instanceof CtrSoftExtensionSTR1) {
            this.treeSet = new TreeSet();
            this.sparsePool = new SetSparsePool(100, false, PoolObject.class);
            this.sortedDomains = SetSparse.factoryArray(i -> ctr.scp[i].dom.initSize(), ctr.scp.length);
            this.pairs = new Kit.IntLongPair[Variable.maxInitDomSize(ctr.scp)];
            for (int i2 = 0; i2 < this.pairs.length; ++i2) {
                this.pairs[i2] = new Kit.IntLongPair();
            }
            this.tuple = new int[ctr.scp.length];
        }
    }

    public void setSortedDomains(Constraint ctr) {
        for (int i = ctr.scp.length - 1; i >= 0; --i) {
            Domain dom = ctr.scp[i].dom;
            this.sortedDomains[i].clear();
            if (dom.size() == 1) {
                this.sortedDomains[i].add(ctr.scp[i].dom.unique());
                continue;
            }
            int cnt = 0;
            int idx = dom.first();
            while (idx != -1) {
                this.pairs[cnt].index = idx;
                this.pairs[cnt++].value = this.deltas[i][idx];
                idx = dom.next(idx);
            }
            Arrays.sort(this.pairs, 0, cnt);
            for (int j = cnt - 1; j >= 0; --j) {
                this.sortedDomains[i].add(this.pairs[j].index);
            }
        }
    }

    private void setSortedDomains(Constraint ctr, int vap, int idx) {
        for (int i = ctr.scp.length - 1; i >= 0; --i) {
            Domain dom = ctr.scp[i].dom;
            this.sortedDomains[i].clear();
            if (i == vap) {
                this.sortedDomains[i].add(idx);
                continue;
            }
            if (dom.size() == 1) {
                this.sortedDomains[i].add(ctr.scp[i].dom.unique());
                continue;
            }
            int cnt = 0;
            int idxo = dom.first();
            while (idxo != -1) {
                this.pairs[cnt].index = idxo;
                this.pairs[cnt++].value = this.deltas[i][idxo];
                idxo = dom.next(idxo);
            }
            Arrays.sort(this.pairs, 0, cnt);
            for (int j = cnt - 1; j >= 0; --j) {
                this.sortedDomains[i].add(this.pairs[j].index);
            }
        }
    }

    private void addSuccessorsOf(int[] parentTuple, long parentScore, int pivotPosition) {
        for (int i = 0; i < parentTuple.length; ++i) {
            int currentPosition;
            if (i == pivotPosition || (currentPosition = this.sortedDomains[i].sparse[parentTuple[i]]) >= this.sortedDomains[i].limit) continue;
            this.treeSet.add(this.obtainPoolObjectFor(parentTuple, parentScore, i, this.sortedDomains[i].dense[currentPosition + 1]));
        }
    }

    private PoolObject obtainPoolObjectFor(int[] tuple, long score) {
        PoolObject po = (PoolObject)this.sparsePool.allocate();
        if (po.t == null) {
            po.t = (int[])tuple.clone();
        } else {
            System.arraycopy(tuple, 0, po.t, 0, tuple.length);
        }
        po.score = score;
        return po;
    }

    private PoolObject obtainPoolObjectFor(int[] parentTuple, long parentScore, int vap, int idx) {
        PoolObject po = this.obtainPoolObjectFor(parentTuple, parentScore);
        po.t[vap] = idx;
        po.score = Calculator.add(Calculator.add(parentScore, this.deltas[vap][parentTuple[vap]]), -this.deltas[vap][idx]);
        return po;
    }

    public int[] computeMinCostImplicitTuple(Constraint ctr, int vap, int idx, long[][] minCosts) {
        this.sparsePool.clear();
        for (int i = 0; i < this.tuple.length; ++i) {
            this.tuple[i] = i == vap ? idx : this.sortedDomains[i].dense[0];
        }
        this.treeSet.clear();
        PoolObject firstPoolObject = this.obtainPoolObjectFor(this.tuple, Calculator.add(this.defaultCost, -this.getDeltaSumOfIndexes(this.tuple)));
        this.treeSet.add(firstPoolObject);
        while (!this.treeSet.isEmpty()) {
            PoolObject pickedPoolObject = this.treeSet.pollFirst();
            System.arraycopy(pickedPoolObject.t, 0, this.tuple, 0, this.tuple.length);
            long score = pickedPoolObject.score;
            this.sparsePool.release(pickedPoolObject.getId());
            assert (this.controlScore(score));
            if (minCosts[vap][idx] <= score) {
                return null;
            }
            if (Arrays.binarySearch(this.tuples, this.tuple, Utilities.lexComparatorInt) < 0) {
                assert (score >= 0L) : ctr + " " + vap + " " + idx + " dc=" + this.defaultCost + " " + score + " " + Kit.join((Object)this.tuple, new String[0]);
                return this.tuple;
            }
            this.addSuccessorsOf(this.tuple, score, vap);
        }
        return null;
    }

    private boolean controlScore(long score) {
        for (PoolObject poolObject : this.treeSet) {
            if (score >= poolObject.score) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "Deltas : " + Kit.join((Object)this.deltas, " ", ",");
    }

    public static class PoolObject
    extends Kit.IntArrayWithLongScore
    implements ObjectIdentifiable {
        private int id;

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void setId(int id) {
            this.id = id;
        }

        @Override
        public void set(int[] t, long score) {
            super.set(t, score);
        }
    }
}

