/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import java.util.Arrays;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import variables.domains.Domain;

public class SoftTable
extends ExtensionStructureSoft {
    public int[][] tuples;
    private long[] costs;

    public int[][] getTuples() {
        return this.tuples;
    }

    public int[] getTuple(int i) {
        return this.tuples[i];
    }

    public long getCost(int i) {
        return this.costs[i];
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        throw new UnreachableCodeException();
    }

    @Override
    public void storeTuplesAndCosts(int[][] ts, long[] costs, long defaultCost) {
        super.storeTuplesAndCosts(ts, costs, defaultCost);
        Constraint ctr = this.firstRegisteredCtr();
        if (ts.length == 0) {
            this.tuples = ts;
        } else if (ctr.indexesMatchValues) {
            this.tuples = Kit.cloneDeeply(ts);
        } else {
            this.tuples = new int[ts.length][ts[0].length];
            for (int j = 0; j < this.tuples[0].length; ++j) {
                Domain domain = ctr.scp[j].dom;
                for (int i = 0; i < this.tuples.length; ++i) {
                    this.tuples[i][j] = domain.toIdx(ts[i][j]);
                }
            }
        }
        this.costs = (long[])costs.clone();
        assert (Kit.isLexStrictlyIncreasing(this.tuples) && Arrays.stream(this.costs).noneMatch(v -> v < 0L));
    }

    public SoftTable(Constraint ctr) {
        super(ctr);
    }

    @Override
    public long getCostOfIdxs(int[] tuple) {
        int position = Arrays.binarySearch(this.tuples, tuple, Utilities.lexComparatorInt);
        return position >= 0 ? this.costs[position] : this.defaultCost;
    }

    @Override
    public String getStringListOfTuples() {
        if (this.tuples.length == 0) {
            return "#soft0" + Types.TypeAtt.defaultCost.name() + this.defaultCost;
        }
        Constraint ctr = this.firstRegisteredCtr();
        StringBuilder sb = new StringBuilder();
        long currentCost = -1L;
        for (int i = 0; i < this.tuples.length; ++i) {
            if (this.costs[i] != currentCost) {
                currentCost = this.costs[i];
                sb.append(currentCost).append(":");
            }
            Kit.join(sb, (Object)ctr.toVals(this.tuples[i]), new String[0]).append('|');
        }
        return sb.append("#").append("soft").append(this.tuples.length).append(Types.TypeAtt.defaultCost.name()).append(this.defaultCost).toString();
    }

    public String toString() {
        return "Tuples : " + Kit.join((Object)this.tuples, " ", ",") + "\nCosts : " + Kit.join((Object)this.costs, new String[0]) + "\nDefault Cost : " + this.defaultCost;
    }
}

