/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.soft.extension.structures.SoftMatrix2D;
import utility.observers.ObserverBacktrackingUnsystematic;
import utility.observers.ObserverConstructionProblem;
import utility.operations.Calculator;
import utility.sets.SetSparseMapLong;
import variables.Variable;

public class SoftMatrix2DTransfert
extends SoftMatrix2D
implements ObserverConstructionProblem,
ObserverBacktrackingUnsystematic {
    protected int[] stackedLevels;
    protected int top = -1;
    protected SetSparseMapLong[] sparseMaps;
    protected int[] cumulatedSizes;

    protected void project(int vap, int idx, long cost) {
        if (vap == 0) {
            long[] t = this.costsMatrix[idx];
            for (int i = 0; i < t.length; ++i) {
                Calculator.add(t, i, -cost);
            }
        } else {
            assert (vap == 1);
            for (int i = 0; i < this.costsMatrix.length; ++i) {
                Calculator.add(this.costsMatrix[i], idx, -cost);
            }
        }
        Calculator.add(this.scopeC1s[vap], idx, cost);
    }

    @Override
    public void projectAndStack(int vap, int idx, long cost) {
        int index;
        if (this.solver.depth() != this.lastModificationDepth()) {
            this.solver.observerCtrsSoft.push(this);
            ++this.top;
            this.stackedLevels[this.top] = this.solver.depth();
            if (this.sparseMaps[this.top] == null) {
                this.sparseMaps[this.top] = new SetSparseMapLong(this.sparseMaps[this.top - 1].capacity(), false);
            } else {
                this.sparseMaps[this.top].clear();
            }
        }
        if (this.sparseMaps[this.top].isPresent(index = this.cumulatedSizes[vap] + idx)) {
            this.sparseMaps[this.top].incrementPresentEntry(index, -cost);
        } else {
            this.sparseMaps[this.top].add(index, -cost);
        }
        this.project(vap, idx, cost);
    }

    public SoftMatrix2DTransfert(Constraint ctr) {
        super(ctr);
        this.cumulatedSizes = Variable.buildCumulatedSizesArray(ctr.scp, true);
        ctr.pb.rs.observersConstructionProblem.add(this);
    }

    @Override
    public void onConstructionProblemFinished() {
        int nbLevels = this.firstRegisteredCtr().pb.variables.length + 1;
        this.stackedLevels = new int[nbLevels];
        this.sparseMaps = new SetSparseMapLong[nbLevels];
        this.sparseMaps[0] = new SetSparseMapLong(Variable.nInitValuesFor(this.firstRegisteredCtr().scp), false);
    }

    @Override
    public int lastModificationDepth() {
        return this.top == -1 ? -1 : this.stackedLevels[this.top];
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        assert (this.stackedLevels[this.top] == depthBeforeBacktrack);
        int[] dense = this.sparseMaps[this.top].dense;
        for (int i = this.sparseMaps[this.top].limit; i >= 0; --i) {
            int idx = dense[i];
            long cost = this.sparseMaps[this.top].values[idx];
            if (idx < this.cumulatedSizes[1]) {
                this.project(0, idx, cost);
                continue;
            }
            this.project(1, idx - this.cumulatedSizes[1], cost);
        }
        --this.top;
    }
}

