/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension.structures;

import constraints.Constraint;
import constraints.TupleManager;
import constraints.hard.extension.structures.ExtensionStructure;
import search.backtrack.SolverBacktrack;
import utility.Kit;

public abstract class ExtensionStructureSoft
extends ExtensionStructure {
    protected SolverBacktrack solver;
    protected long[][] scopeC1s;
    protected long defaultCost;
    private long highestInitialCost;

    public void setScopeC1s(long[][] scopeC1s) {
        assert (this.registeredCtrs().size() == 1);
        this.solver = (SolverBacktrack)this.firstRegisteredCtr().pb.solver;
        this.scopeC1s = scopeC1s;
    }

    public long getDefaultCost() {
        return this.defaultCost;
    }

    public long getHighestInitialCost() {
        return this.highestInitialCost;
    }

    public ExtensionStructureSoft(Constraint ctr) {
        super(ctr);
    }

    public abstract void projectAndStack(int var1, int var2, long var3);

    public void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        this.defaultCost = defaultCost;
        this.highestInitialCost = Long.MIN_VALUE;
        for (long l : costs) {
            if (l <= this.highestInitialCost) continue;
            this.highestInitialCost = l;
        }
        if (defaultCost > this.highestInitialCost) {
            this.highestInitialCost = defaultCost;
        }
    }

    public abstract long getCostOfIdxs(int[] var1);

    public abstract String getStringListOfTuples();

    public final void displayTuplesWithCosts() {
        TupleManager tupleManager = this.firstRegisteredCtr().tupleManager;
        tupleManager.firstValidTuple();
        tupleManager.overValidTuples(t -> Kit.log.finer(Kit.join(t, new String[0]) + " => cost=" + this.getCostOfIdxs((int[])t)));
    }
}

