/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import utility.Kit;

public class LayeredSoftTable {
    private static final int LIMIT_INSERTION_SORT = 10;
    public int[][][] levelTuples;
    public long[] levelCosts;
    public long defaultCost;

    public LayeredSoftTable(int[][] tuples, long[] costs, long defaultCost, boolean includeDefaulCost) {
        HashMap<Long, List> levels = new HashMap<Long, List>();
        if (includeDefaulCost) {
            levels.put(defaultCost, null);
        }
        for (int i = 0; i < costs.length; ++i) {
            levels.computeIfAbsent(costs[i], k -> new ArrayList()).add(tuples[i]);
        }
        this.levelTuples = new int[levels.size()][][];
        this.levelCosts = new long[levels.size()];
        this.defaultCost = defaultCost;
        Kit.control(levels.size() < 10, () -> "Not implemented yet for large number of levels");
        int nbInsertedLevels = 0;
        for (Map.Entry entry : levels.entrySet()) {
            long cost = (Long)entry.getKey();
            Kit.control(entry.getValue() != null || cost == defaultCost);
            int[][] t = entry.getValue() == null ? new int[][]{} : (int[][])Kit.intArray2D((Collection)entry.getValue());
            int position = -Arrays.binarySearch(this.levelCosts, 0, nbInsertedLevels, cost) - 1;
            Kit.control(position >= 0 && position <= nbInsertedLevels);
            for (int i = nbInsertedLevels - 1; i >= position; --i) {
                this.levelCosts[i + 1] = this.levelCosts[i];
                this.levelTuples[i + 1] = this.levelTuples[i];
            }
            ++nbInsertedLevels;
            this.levelCosts[position] = cost;
            this.levelTuples[position] = t;
        }
    }

    public int[][] buildTuplesFromLayersLessThanOrEqualTo(long limitCost) {
        boolean defaulCostGreater = this.defaultCost > limitCost;
        int nbTuples = 0;
        for (int i = 0; i < this.levelCosts.length; ++i) {
            if (this.levelCosts[i] <= limitCost != defaulCostGreater) continue;
            nbTuples += this.levelTuples[i].length;
        }
        int[][] tuples = new int[nbTuples][];
        int cnt = 0;
        for (int i = 0; i < this.levelCosts.length; ++i) {
            if (this.levelCosts[i] <= limitCost != defaulCostGreater) continue;
            int[][] t = this.levelTuples[i];
            for (int j = 0; j < t.length; ++j) {
                tuples[cnt++] = t[j];
            }
        }
        return tuples;
    }

    public int[][] buildTuplesFromLayerEqualTo(long limitCost) {
        boolean defaulCostEqual = this.defaultCost == limitCost;
        int nbTuples = 0;
        for (int i = 0; i < this.levelCosts.length; ++i) {
            if (this.levelCosts[i] == limitCost != !defaulCostEqual) continue;
            nbTuples += this.levelTuples[i].length;
        }
        int[][] tuples = new int[nbTuples][];
        int cnt = 0;
        for (int i = 0; i < this.levelCosts.length; ++i) {
            if (this.levelCosts[i] == limitCost != !defaulCostEqual) continue;
            int[][] t = this.levelTuples[i];
            for (int j = 0; j < t.length; ++j) {
                tuples[cnt++] = t[j];
            }
        }
        return tuples;
    }

    public String toString() {
        String s = "defaultCost=" + this.defaultCost + "\n";
        for (int i = 0; i < this.levelCosts.length; ++i) {
            s = s + " layer " + i + " : cost=" + this.levelCosts[i] + ", tuples=" + Kit.join((Object)this.levelTuples[i], " ", ",") + "\n";
        }
        return s;
    }
}

