/*
 * Decompiled with CFR 0.152.
 */
package constraints.soft.extension;

import constraints.CtrSoft;
import constraints.soft.extension.CtrSoftExtensionSTR1;
import constraints.soft.extension.CtrSoftExtensionSTR2;
import constraints.soft.extension.structures.ExtensionStructureSoft;
import constraints.soft.extension.structures.SoftMatrix1D;
import constraints.soft.extension.structures.SoftMatrix2D;
import constraints.soft.extension.structures.SoftMatrix2DTransfert;
import constraints.soft.extension.structures.SoftMatrix2DTransfertDelta;
import constraints.soft.extension.structures.SoftMatrix3D;
import constraints.soft.extension.structures.SoftMatrix3DTransfert;
import constraints.soft.extension.structures.SoftMatrix3DTransfertDelta;
import constraints.soft.extension.structures.SoftTable;
import constraints.soft.extension.structures.SoftTableDelta;
import dashboard.ControlPanel;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import problem.Problem;
import propagation.soft.sac.SoftAC;
import utility.Enums;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;
import utility.observers.ObserverConstructionSolver;
import utility.operations.Calculator;
import variables.Variable;
import variables.domains.Domain;

public class CtrSoftExtension
extends CtrSoft
implements ObserverConstructionSolver {
    protected ExtensionStructureSoft softExtensionStructure;
    private int[] tmp;
    private int[] tmp2;
    protected long[][] scopeC1s;
    protected SoftAC softAC;
    private boolean matrix2DAnd3DTransfertDelta = true;

    @Override
    public void onConstructionSolverFinished() {
        this.softAC = this.pb.solver.propagation instanceof SoftAC ? (SoftAC)this.pb.solver.propagation : null;
    }

    public static CtrSoftExtension build(Problem pb, Variable[] scp, int[][] tuples, long[] costs, long defaultCost) {
        ControlPanel cfg = pb.rs.cp;
        if (cfg.extension.positive == Enums.EExtension.STR1 && scp.length >= cfg.optimizing.arityLimitForSoftSTR) {
            return new CtrSoftExtensionSTR1(pb, scp, tuples, costs, defaultCost);
        }
        if (cfg.extension.positive == Enums.EExtension.STR2 && scp.length >= cfg.optimizing.arityLimitForSoftSTR) {
            return new CtrSoftExtensionSTR2(pb, scp, tuples, costs, defaultCost);
        }
        return new CtrSoftExtension(pb, scp, tuples, costs, defaultCost);
    }

    public static CtrSoftExtension build(Problem problem, Variable[] scope, int[][] tuples, int[] costs, int defaultCost) {
        return CtrSoftExtension.build(problem, scope, tuples, Arrays.stream(costs).mapToLong(i -> i).toArray(), (long)defaultCost);
    }

    public static CtrSoftExtension build(Problem pb, Variable[] scp, int[][] tuples, boolean positive, Enums.EWCNConversion wcnConversion, int k, Random r) {
        int defaultCost;
        assert (wcnConversion != Enums.EWCNConversion.NO);
        int n = defaultCost = positive ? Integer.MAX_VALUE : 0;
        if (wcnConversion == Enums.EWCNConversion.NATURAL) {
            int[] costs = Kit.repeat(positive ? 0 : k, tuples.length);
            return CtrSoftExtension.build(pb, scp, tuples, costs, defaultCost);
        }
        int inf = positive ? 0 : 1;
        int sup = positive ? k - 1 : k;
        int[] costs = IntStream.range(0, tuples.length).map(i -> inf + r.nextInt(sup - inf + 1)).toArray();
        return CtrSoftExtension.build(pb, scp, tuples, costs, defaultCost);
    }

    public long[] getC1For(int vap) {
        return this.scopeC1s[vap];
    }

    public void buildScopeC1s(long[][] c1s) {
        this.scopeC1s = new long[this.scp.length][];
        for (int i = 0; i < this.scopeC1s.length; ++i) {
            this.scopeC1s[i] = c1s[this.scp[i].num];
        }
        this.softExtensionStructure.setScopeC1s(this.scopeC1s);
    }

    @Override
    public ExtensionStructureSoft extStructure() {
        return this.softExtensionStructure;
    }

    @Override
    public long getHighestInitialCost() {
        return this.softExtensionStructure.getHighestInitialCost();
    }

    protected ExtensionStructureSoft buildSoftExtensionStructure() {
        if (this.scp.length == 1) {
            return new SoftMatrix1D(this);
        }
        ControlPanel cfg = this.pb.rs.cp;
        if (this.scp.length == 2) {
            if (cfg.optimizing.costTranfer == Enums.ECostTranfer.INVARIABLE) {
                return new SoftMatrix2D(this);
            }
            if (cfg.optimizing.costTranfer == Enums.ECostTranfer.UPDATE) {
                return new SoftMatrix2DTransfert(this);
            }
            return this.matrix2DAnd3DTransfertDelta ? new SoftMatrix2DTransfertDelta(this) : new SoftTableDelta(this);
        }
        if (this.scp.length == 3) {
            if (cfg.optimizing.costTranfer == Enums.ECostTranfer.INVARIABLE) {
                return new SoftMatrix3D(this);
            }
            if (cfg.optimizing.costTranfer == Enums.ECostTranfer.UPDATE) {
                return new SoftMatrix3DTransfert(this);
            }
            return this.matrix2DAnd3DTransfertDelta ? new SoftMatrix3DTransfertDelta(this) : new SoftTableDelta(this);
        }
        return cfg.optimizing.costTranfer == Enums.ECostTranfer.DELTA ? new SoftTableDelta(this) : new SoftTable(this);
    }

    protected void initializeAdditionalFieldsUsedWithExtensionStructure() {
    }

    protected void storeTuplesAndCosts(int[][] tuples, long[] costs, long defaultCost) {
        if (this.pb.rs.cp.optimizing.costTranfer == Enums.ECostTranfer.INVARIABLE) {
            if (this.key == null || !this.pb.rs.mapOfExtensionStructures.containsKey(this.key)) {
                this.softExtensionStructure = this.buildSoftExtensionStructure();
                this.softExtensionStructure.storeTuplesAndCosts(tuples, costs, defaultCost);
                if (this.key != null) {
                    this.pb.rs.mapOfExtensionStructures.put(this.key, this.softExtensionStructure);
                }
            } else {
                this.softExtensionStructure = (ExtensionStructureSoft)this.pb.rs.mapOfExtensionStructures.get(this.key);
                this.softExtensionStructure.register(this);
                assert (this.indexesMatchValues == this.softExtensionStructure.firstRegisteredCtr().indexesMatchValues);
            }
        } else {
            this.softExtensionStructure = this.buildSoftExtensionStructure();
            this.softExtensionStructure.storeTuplesAndCosts(tuples, costs, defaultCost);
        }
        this.initializeAdditionalFieldsUsedWithExtensionStructure();
    }

    public CtrSoftExtension(Problem problem, Variable[] scope, int[][] tuples, long[] costs, long defaultCost) {
        super(problem, scope);
        this.storeTuplesAndCosts(tuples, costs, defaultCost);
        Kit.control(tuples.length == costs.length);
        this.tmp = new int[scope.length];
        this.tmp2 = new int[scope.length];
    }

    public long getCostOValues(int[] values) {
        throw new UnreachableCodeException();
    }

    @Override
    public long costOfIdxs(int[] idxs) {
        return this.softExtensionStructure.getCostOfIdxs(idxs);
    }

    private final long seekMaxCostFrom(int[] tuple) {
        assert (this.isValid(tuple));
        long ub = this.pb.solver.solManager.bestBound;
        long maxCost = 0L;
        do {
            long cost;
            if ((cost = this.costOfIdxs(tuple)) >= ub) {
                return ub;
            }
            if (cost <= maxCost) continue;
            maxCost = cost;
        } while (this.tupleManager.nextValidTuple() != -1);
        return maxCost;
    }

    public long getMaxCostFor(int x, int a) {
        return this.seekMaxCostFrom(this.tupleManager.firstValidTupleWith(x, a));
    }

    private final long seekMaxCostFrom(int[] tuple, long limit) {
        Kit.control(limit >= 0L && limit < this.pb.solver.solManager.bestBound, () -> "limit=" + limit + " ub=" + this.pb.solver.solManager.bestBound);
        long maxCost = 0L;
        do {
            long cost;
            if ((cost = this.costOfIdxs(tuple)) > limit) {
                return cost;
            }
            if (cost <= maxCost) continue;
            maxCost = cost;
        } while (this.tupleManager.nextValidTuple() != -1);
        return maxCost;
    }

    public long getMaxCostFor(int x, int a, long limit) {
        return this.seekMaxCostFrom(this.tupleManager.firstValidTupleWith(x, a), limit);
    }

    protected long seekMinCostFrom(int[] tuple) {
        assert (this.isValid(tuple));
        long minCost = Long.MAX_VALUE;
        do {
            long cost;
            if ((cost = this.costOfIdxs(tuple)) >= minCost) continue;
            minCost = cost;
            if (cost == 0L) break;
        } while (this.tupleManager.nextValidTuple() != -1);
        return minCost;
    }

    public final long seekMinCostFor(int x, int a) {
        return this.seekMinCostFrom(this.tupleManager.firstValidTupleWith(x, a));
    }

    @Override
    public long minCostOfTuplesWith(int x, int a) {
        return this.seekMinCostFrom(this.tupleManager.firstValidTupleWith(x, a));
    }

    private int[] getMinCostTuple(int[] tuple) {
        long minCost = Long.MAX_VALUE;
        do {
            long cost;
            if ((cost = this.costOfIdxs(tuple)) == 0L) {
                return tuple;
            }
            if (cost >= minCost) continue;
            minCost = cost;
            Kit.copy(tuple, this.tmp);
        } while (this.tupleManager.nextValidTuple() != -1);
        return this.tmp;
    }

    @Override
    public int[] getMinCostTupleFor(int x, int a) {
        return this.getMinCostTuple(this.tupleManager.firstValidTupleWith(x, a));
    }

    @Override
    public int[] getMinFullCostTupleFor(int targetPosition, int targetIndex, int sourcePosition) {
        long[] c1 = this.scopeC1s[sourcePosition];
        int[] tuple = this.tupleManager.firstValidTupleWith(targetPosition, targetIndex);
        long minCost = Long.MAX_VALUE;
        do {
            long cost;
            if ((cost = Calculator.add(this.costOfIdxs(tuple), c1[tuple[sourcePosition]])) == 0L) {
                return tuple;
            }
            if (cost >= minCost) continue;
            minCost = cost;
            Kit.copy(tuple, this.tmp);
        } while (this.tupleManager.nextValidTuple() != -1);
        return this.tmp;
    }

    public final int[] getMaxExtensionCostTuple(int targetPosition, long[] projectionCosts, int sourcePosition, int sourceIndex) {
        long max = Long.MIN_VALUE;
        Domain dom = this.scp[targetPosition].dom;
        int targetIdx = dom.first();
        while (targetIdx != -1) {
            int[] t = this.getMinCostTuple(this.tupleManager.firstValidTupleWith(sourcePosition, sourceIndex, targetPosition, targetIdx));
            long m = Calculator.add(projectionCosts[targetIdx], -this.costOfIdxs(t));
            if (m > max) {
                max = m;
                Kit.copy(t, this.tmp2);
            }
            targetIdx = dom.next(targetIdx);
        }
        return this.tmp2;
    }

    @Override
    public long getDiffCostOfIndexes(int[] tuple, int vap, int idx, long ub) {
        long cost2 = this.costOfIdxs(tuple);
        if (cost2 >= ub) {
            return ub;
        }
        int idxo = tuple[vap];
        tuple[vap] = idx;
        long cost1 = this.costOfIdxs(tuple);
        tuple[vap] = idxo;
        if (cost1 > ub) {
            cost1 = ub;
        }
        return Calculator.add(cost2, -cost1);
    }

    @Override
    public long getMinDiffCostTupleFor(int vap, int idx1, int idx2, long ub, long breakLimit) {
        assert (breakLimit <= 0L);
        int[] tuple = this.tupleManager.firstValidTupleWith(vap, idx2);
        long minDifference = ub;
        do {
            long diff;
            if ((diff = this.getDiffCostOfIndexes(tuple, vap, idx1, ub)) >= minDifference) continue;
            if (diff < breakLimit) {
                return diff;
            }
            minDifference = diff;
        } while (this.tupleManager.nextValidTuple() != -1);
        assert (minDifference < ub);
        return minDifference;
    }

    @Override
    public boolean controlArcConsistency() {
        if (this.ignored) {
            return true;
        }
        if (this.scp.length == 1 || !this.canBeCurrentlyGenericallyFiltered()) {
            return true;
        }
        for (Variable x : this.scp) {
            Domain dom = x.dom;
            int idx = dom.first();
            while (idx != -1) {
                if (this.seekMinCostFor(this.positionOf(x), idx) != 0L) {
                    Kit.log.warning(x + "=" + idx + " not supported by " + this + " pb AC, minCost=" + this.seekMinCostFor(this.positionOf(x), idx));
                    this.display(true);
                    return false;
                }
                idx = dom.next(idx);
            }
        }
        return true;
    }
}

