/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public abstract class HammingProximityConstant
extends CtrGlobal
implements TagGuaranteedGAC {
    protected int[] target;
    protected int k;

    public HammingProximityConstant(Problem pb, Variable[] list, int[] target, int k) {
        super(pb, list);
        this.target = target;
        this.k = k;
        this.defineKey(Kit.join((Object)target, new String[0]), k);
        Kit.control(0 < k && k < list.length && list.length == target.length);
    }

    @Override
    public int[] defineSymmetryMatching() {
        return IntStream.range(0, this.target.length).map(i -> Utilities.indexOf((int)this.target[i], (int[])this.target) + 1).toArray();
    }

    public void setTarget(int[] target) {
        this.target = target;
        Kit.control(this.target.length == target.length);
    }

    public void setK(int k) {
        this.k = k;
    }

    public static final class HammingProximityConstantSumLE
    extends HammingProximityConstant
    implements TagCompleteFilteringAtEachCall,
    ObserverBacktrackingSystematic {
        protected final int[] minDist;

        @Override
        public boolean checkValues(int[] t) {
            int sum = 0;
            for (int i = 0; i < t.length; ++i) {
                if ((sum += Math.abs(t[i] - this.target[i])) <= this.k) continue;
                return false;
            }
            return true;
        }

        @Override
        public void restoreAtDepthBefore(int depthBeforeBacktrack) {
            for (int i = 0; i < this.minDist.length; ++i) {
                this.minDist[i] = 0;
            }
        }

        public HammingProximityConstantSumLE(Problem pb, Variable[] list, int[] target, int k) {
            super(pb, list, target, k);
            this.minDist = new int[target.length];
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int i;
            int sumMinDist = 0;
            for (i = 0; i < this.scp.length; ++i) {
                Domain dom = this.scp[i].dom;
                if (!dom.isPresentValue(this.target[i] - this.minDist[i]) && !dom.isPresentValue(this.target[i] + this.minDist[i])) {
                    int a = dom.first();
                    while (dom.toVal(a) < this.target[i] && a != -1) {
                        a = dom.next(a);
                    }
                    this.minDist[i] = a == -1 ? this.target[i] - dom.lastValue() : (dom.size() == 1 ? dom.toVal(a) - this.target[i] : Math.min(dom.toVal(a) - this.target[i], this.target[i] - dom.toVal(dom.prev(a))));
                }
                sumMinDist += this.minDist[i];
            }
            for (i = 0; i < this.scp.length; ++i) {
                if (!this.scp[i].dom.removeValues(Types.TypeOperatorRel.LT, this.target[i] - (this.k - sumMinDist + this.minDist[i]))) {
                    return false;
                }
                if (this.scp[i].dom.removeValues(Types.TypeOperatorRel.GT, this.target[i] + (this.k - sumMinDist + this.minDist[i]))) continue;
                return false;
            }
            return true;
        }
    }

    public static final class HammingProximityConstantGE
    extends HammingProximityConstant
    implements TagPartialFilteringAtEachCall {
        private SetSparse sentinels;

        @Override
        public boolean checkValues(int[] t) {
            int cnt = 0;
            for (int i = 0; i < t.length; ++i) {
                if (t[i] != this.target[i] || ++cnt != this.k) continue;
                return true;
            }
            return false;
        }

        public HammingProximityConstantGE(Problem pb, Variable[] list, int[] target, int k) {
            super(pb, list, target, k);
            this.sentinels = new SetSparse(list.length);
            for (int i = 0; i < k + 1; ++i) {
                this.sentinels.add(i);
            }
            Kit.control(this.controlSentinels());
        }

        @Override
        public boolean runPropagator(Variable x) {
            int p;
            int i;
            int px = this.positionOf(x);
            if (!this.sentinels.isPresent(px) || x.dom.isPresentValue(this.target[px])) {
                return true;
            }
            for (i = this.sentinels.limit + 1; i < this.scp.length; ++i) {
                p = this.sentinels.dense[i];
                if (!this.scp[p].dom.isPresentValue(this.target[p])) continue;
                this.sentinels.swap(px, p);
                return true;
            }
            for (i = this.sentinels.limit; i >= 0; --i) {
                p = this.sentinels.dense[i];
                if (p == px || this.scp[p].isAssigned() || this.scp[p].dom.reduceToValue(this.target[p])) continue;
                return false;
            }
            return true;
        }

        private boolean controlSentinels() {
            return IntStream.rangeClosed(0, this.sentinels.limit).allMatch(i -> this.scp[this.sentinels.dense[i]].dom.isPresentValue(this.target[this.sentinels.dense[i]]));
        }
    }

    public static final class HammingProximityConstantLE
    extends HammingProximityConstant
    implements TagCompleteFilteringAtEachCall {
        @Override
        public boolean checkValues(int[] t) {
            int cnt = 0;
            for (int i = 0; i < t.length; ++i) {
                if (t[i] != this.target[i] || ++cnt <= this.k) continue;
                return false;
            }
            return true;
        }

        public HammingProximityConstantLE(Problem pb, Variable[] list, int[] target, int k) {
            super(pb, list, target, k);
        }

        @Override
        public boolean runPropagator(Variable x) {
            int i;
            int cnt = 0;
            for (i = 0; i < this.scp.length; ++i) {
                if (!this.scp[i].dom.onlyContainsValue(this.target[i]) || ++cnt <= this.k) continue;
                return this.scp[i].dom.fail();
            }
            if (cnt == this.k) {
                for (i = 0; i < this.scp.length; ++i) {
                    if (this.scp[i].dom.size() == 1) continue;
                    this.scp[i].dom.removeValue(this.target[i], false);
                }
            }
            return true;
        }
    }
}

