/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import variables.Variable;
import variables.domains.Domain;

public abstract class Extremum
extends CtrGlobal
implements TagCompleteFilteringAtEachCall,
TagGuaranteedGAC {
    protected final Variable[] list;
    protected final Variable ext;
    protected final Domain domExt;
    protected final Variable[] sentinels;

    @Override
    public boolean checkValues(int[] t) {
        boolean extremumPresent = false;
        for (int i = 1; i < t.length; ++i) {
            if (this instanceof Maximum ? t[i] > t[0] : t[i] < t[0]) {
                return false;
            }
            if (t[i] != t[0]) continue;
            extremumPresent = true;
        }
        return extremumPresent;
    }

    protected Variable findSentinelFor(int v, Variable except) {
        for (Variable x : this.list) {
            if (x == except || !x.dom.isPresentValue(v)) continue;
            return x;
        }
        return null;
    }

    protected Variable findSentinelFor(int v) {
        for (Variable x : this.list) {
            if (!x.dom.isPresentValue(v)) continue;
            return x;
        }
        return null;
    }

    @Override
    public int[] defineSymmetryMatching() {
        return !Variable.haveSameDomainType(this.list) ? Kit.range(this.scp.length) : IntStream.range(0, this.scp.length).map(i -> i == 0 ? 1 : 2).toArray();
    }

    public Extremum(Problem pb, Variable[] list, Variable ext) {
        super(pb, (Variable[])pb.api.vars((IVar)ext, (IVar[])list));
        this.list = list;
        this.ext = ext;
        this.domExt = ext.dom;
        this.sentinels = new Variable[ext.dom.initSize()];
        int a = this.domExt.first();
        while (a != -1) {
            this.sentinels[a] = this.findSentinelFor(this.domExt.toVal(a));
            a = this.domExt.next(a);
        }
        a = this.domExt.first();
        while (a != -1) {
            if (this.sentinels[a] == null) {
                this.domExt.removeValueAtConstructionTime(this.domExt.toVal(a));
            }
            a = this.domExt.next(a);
        }
        Kit.control(list.length > 1 && Stream.of(list).noneMatch(x -> x == ext), () -> "vector length = " + list.length);
    }

    public static final class Minimum
    extends Extremum {
        private int computeLimitForSentinel(Variable sentinel) {
            int a = this.domExt.first();
            while (a != -1) {
                int v = this.domExt.toVal(a);
                if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                    return v;
                }
                a = this.domExt.next(a);
            }
            return Integer.MAX_VALUE;
        }

        public Minimum(Problem pb, Variable[] list, Variable min) {
            super(pb, list, min);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int v;
            int minFirst = Integer.MAX_VALUE;
            int minLast = Integer.MAX_VALUE;
            for (Variable x : this.list) {
                if (x.dom.firstValue() < minFirst) {
                    minFirst = x.dom.firstValue();
                }
                if (x.dom.lastValue() >= minLast) continue;
                minLast = x.dom.lastValue();
            }
            if (!this.domExt.removeValues(Types.TypeOperatorRel.GT, minLast) || !this.domExt.removeValues(Types.TypeOperatorRel.LT, minFirst)) {
                return false;
            }
            int sizeBefore = this.domExt.size();
            int a = this.domExt.first();
            while (a != -1) {
                int v2 = this.domExt.toVal(a);
                if (!this.sentinels[a].dom.isPresentValue(v2)) {
                    Variable s = this.findSentinelFor(v2);
                    if (s != null) {
                        this.sentinels[a] = s;
                    } else {
                        this.domExt.removeElementary(a);
                    }
                }
                a = this.domExt.next(a);
            }
            if (!this.domExt.afterElementaryCalls(sizeBefore)) {
                return false;
            }
            int firstMin = this.domExt.firstValue();
            for (Variable x : this.list) {
                if (x.dom.removeValues(Types.TypeOperatorRel.LT, firstMin)) continue;
                return false;
            }
            Variable sentinel = this.sentinels[this.domExt.first()];
            int valLimit = this.computeLimitForSentinel(sentinel);
            if (valLimit == firstMin) {
                return true;
            }
            Domain domSentinel = sentinel.dom;
            sizeBefore = domSentinel.size();
            int a2 = domSentinel.next(domSentinel.first());
            while (a2 != -1 && (v = domSentinel.toVal(a2)) < valLimit) {
                if (!this.domExt.isPresentValue(v)) {
                    domSentinel.removeElementary(a2);
                }
                a2 = domSentinel.next(a2);
            }
            return domSentinel.afterElementaryCalls(sizeBefore);
        }
    }

    public static final class Maximum
    extends Extremum {
        private int computeLimitForSentinel(Variable sentinel) {
            int a = this.domExt.last();
            while (a != -1) {
                int v = this.domExt.toVal(a);
                if (this.sentinels[a] != sentinel || this.findSentinelFor(v, sentinel) != null) {
                    return v;
                }
                a = this.domExt.prev(a);
            }
            return Integer.MIN_VALUE;
        }

        public Maximum(Problem pb, Variable[] list, Variable max) {
            super(pb, list, max);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            int v;
            int maxFirst = Integer.MIN_VALUE;
            int maxLast = Integer.MIN_VALUE;
            for (Variable x : this.list) {
                if (x.dom.firstValue() > maxFirst) {
                    maxFirst = x.dom.firstValue();
                }
                if (x.dom.lastValue() <= maxLast) continue;
                maxLast = x.dom.lastValue();
            }
            if (!this.domExt.removeValues(Types.TypeOperatorRel.LT, maxFirst) || !this.domExt.removeValues(Types.TypeOperatorRel.GT, maxLast)) {
                return false;
            }
            int sizeBefore = this.domExt.size();
            if (!this.domExt.removeIndexesChecking(a -> {
                int v = this.domExt.toVal((int)a);
                if (!this.sentinels[a.intValue()].dom.isPresentValue(v)) {
                    Variable s = this.findSentinelFor(v);
                    if (s == null) {
                        return true;
                    }
                    this.sentinels[a.intValue()] = s;
                }
                return false;
            })) {
                return false;
            }
            int lastMax = this.domExt.lastValue();
            for (Variable x : this.list) {
                if (x.dom.removeValues(Types.TypeOperatorRel.GT, lastMax)) continue;
                return false;
            }
            Variable sentinel = this.sentinels[this.domExt.last()];
            int valLimit = this.computeLimitForSentinel(sentinel);
            if (valLimit == lastMax) {
                return true;
            }
            Domain domSentinel = sentinel.dom;
            sizeBefore = domSentinel.size();
            int a2 = domSentinel.prev(domSentinel.last());
            while (a2 != -1 && (v = domSentinel.toVal(a2)) > valLimit) {
                if (!this.domExt.isPresentValue(v)) {
                    domSentinel.removeElementary(a2);
                }
                a2 = domSentinel.prev(a2);
            }
            return domSentinel.afterElementaryCalls(sizeBefore);
        }
    }
}

