/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import variables.Variable;
import variables.domains.Domain;

public final class ExactlyKVariable
extends CtrGlobal
implements TagGuaranteedGAC,
TagCompleteFilteringAtEachCall {
    protected Variable[] list;
    protected int value;
    protected Variable k;
    private int indexOfKInList;

    @Override
    public boolean checkValues(int[] t) {
        return this.indexOfKInList != -1 ? Kit.countIn(this.value, t) == t[this.indexOfKInList] : Kit.countIn(this.value, t, 0, t.length - 1) == t[t.length - 1];
    }

    @Override
    public int[] defineSymmetryMatching() {
        return IntStream.range(0, this.scp.length).map(i -> i == this.indexOfKInList || this.indexOfKInList == -1 && i == this.scp.length - 1 ? 2 : 1).toArray();
    }

    public ExactlyKVariable(Problem pb, Variable[] list, int value, Variable k) {
        super(pb, (Variable[])Utilities.collect(Variable.class, (Object[])new Object[]{list, k}));
        this.list = list;
        this.value = value;
        this.k = k;
        this.indexOfKInList = Utilities.indexOf((Object)k, (Object[])list);
        this.defineKey(value, this.indexOfKInList);
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int nGuaranteedOccurrences = 0;
        int nPossibleOccurrences = 0;
        for (Variable x : this.list) {
            if (!x.dom.isPresentValue(this.value)) continue;
            ++nPossibleOccurrences;
            if (x.dom.size() != 1) continue;
            ++nGuaranteedOccurrences;
        }
        Domain domK = this.k.dom;
        if (domK.size() == 1) {
            int valK = domK.uniqueValue();
            if (valK < nGuaranteedOccurrences || nPossibleOccurrences < valK) {
                return domK.fail();
            }
        } else if (this.indexOfKInList != -1) {
            int a = domK.toPresentIdx(this.value);
            if (a != -1) {
                boolean deleted = false;
                int b = domK.first();
                while (b != -1) {
                    if (b == a) {
                        if (this.value < nGuaranteedOccurrences + 1 || nPossibleOccurrences < this.value) {
                            if (!domK.remove(a)) {
                                return false;
                            }
                            deleted = true;
                        }
                    } else {
                        int v = domK.toVal(b);
                        if (!(v >= nGuaranteedOccurrences && nPossibleOccurrences - 1 >= v || domK.remove(b))) {
                            return false;
                        }
                    }
                    b = domK.next(b);
                }
                if (deleted) {
                    --nPossibleOccurrences;
                }
            } else if (!domK.removeValues(Types.TypeOperatorRel.LT, nGuaranteedOccurrences) || !domK.removeValues(Types.TypeOperatorRel.GT, nPossibleOccurrences)) {
                return false;
            }
        } else if (!domK.removeValues(Types.TypeOperatorRel.LT, nGuaranteedOccurrences) || !domK.removeValues(Types.TypeOperatorRel.GT, nPossibleOccurrences)) {
            return false;
        }
        if (domK.size() == 1) {
            int v = domK.uniqueValue();
            if (v == nGuaranteedOccurrences) {
                Variable[] variableArray = this.list;
                int n = variableArray.length;
                for (int i = 0; i < n; ++i) {
                    Variable x = variableArray[i];
                    if (x.dom.size() <= 1 || !x.dom.isPresentValue(this.value) || x.dom.removeValue(this.value)) continue;
                    return false;
                }
            }
            if (v == nPossibleOccurrences) {
                for (Variable x : this.list) {
                    if (x.dom.size() <= 1 || !x.dom.isPresentValue(this.value)) continue;
                    x.dom.reduceToValue(this.value);
                }
            }
        }
        return true;
    }
}

