/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.stream.IntStream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagUnsymmetric;
import variables.Variable;
import variables.domains.Domain;

public abstract class Element
extends CtrGlobal
implements TagUnsymmetric,
TagGuaranteedGAC {
    protected final Variable[] list;
    protected final int startAt;
    protected final Variable index;
    protected final int indexPosition;

    public Element(Problem pb, Variable[] list, int startAt, Variable index, Object value) {
        super(pb, (Variable[])Utilities.collect(Variable.class, (Object[])new Object[]{list, index, value}));
        this.list = list;
        this.startAt = startAt;
        this.index = index;
        this.indexPosition = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == index).findFirst().getAsInt();
        Kit.control(startAt == 0, () -> "Starting at a value different from 0 not implemented yet");
        Kit.control(Variable.areAllDistinct(list) && index != value, () -> "i=" + index + " x=" + Kit.join((Object)list, new String[0]) + " v=" + value);
        Kit.control(pb.rs.cp.export || index.dom.areInitValuesExactly(pb.api.range(startAt, startAt + list.length)), () -> " pb with " + this + " " + startAt);
    }

    protected Domain domAt(int i) {
        return this.list[i - this.startAt].dom;
    }

    public static class ElementVariable
    extends Element
    implements TagCompleteFilteringAtEachCall {
        private final Variable value;
        private final int valuePosition;
        private final int[] valueSentinels;
        private final int[] listSentinels;

        @Override
        public boolean checkValues(int[] t) {
            return t[t[this.indexPosition] - this.startAt] == t[this.valuePosition];
        }

        public ElementVariable(Problem pb, Variable[] list, int startAt, Variable index, Variable value) {
            super(pb, list, startAt, index, value);
            this.value = value;
            this.valuePosition = IntStream.range(0, this.scp.length).filter(i -> this.scp[i] == value).findFirst().getAsInt();
            this.valueSentinels = Kit.repeat(-1, value.dom.initSize());
            this.listSentinels = Kit.repeat(-1, list.length);
            this.defineKey(new Object[0]);
        }

        public ElementVariable(Problem pb, Variable[] list, Variable index, Variable value) {
            this(pb, list, 0, index, value);
        }

        private boolean findSentinelForListAt(int i) {
            return this.domAt(i).iterateOnValuesStoppingWhen(v -> {
                boolean present = this.value.dom.isPresentValue((int)v);
                if (present) {
                    this.listSentinels[i] = v;
                }
                return present;
            });
        }

        private boolean findSentinelForValue(int a) {
            int v = this.value.dom.toVal(a);
            return this.index.dom.iterateStoppingWhen(i -> {
                boolean present;
                boolean bl = present = this.domAt((int)i).toPresentIdx(v) >= 0;
                if (present) {
                    this.valueSentinels[a] = i;
                }
                return present;
            });
        }

        private boolean reduceDomainOfValue() {
            return this.value.dom.removeIndexesChecking(a -> {
                int sentinel = this.valueSentinels[a];
                return (sentinel == -1 || !this.index.dom.isPresent(sentinel) || !this.domAt(sentinel).isPresentValue(this.value.dom.toVal((int)a))) && !this.findSentinelForValue((int)a);
            });
        }

        private boolean reduceDomainOfIndex() {
            return this.index.dom.removeIndexesChecking(i -> {
                int sentinel = this.listSentinels[i];
                return (sentinel == -1 || !this.domAt((int)i).isPresentValue(sentinel) || !this.value.dom.isPresentValue(sentinel)) && !this.findSentinelForListAt((int)i);
            });
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            Domain dom;
            if (this.index.dom.size() > 1) {
                int sizeBefore;
                if (!this.reduceDomainOfValue()) {
                    return false;
                }
                do {
                    sizeBefore = this.index.dom.size();
                    if (!this.reduceDomainOfIndex()) {
                        return false;
                    }
                    if (sizeBefore == this.index.dom.size()) break;
                    sizeBefore = this.value.dom.size();
                    if (this.reduceDomainOfValue()) continue;
                    return false;
                } while (sizeBefore != this.value.dom.size());
            }
            if (!(this.index.dom.size() != 1 || (dom = this.domAt(this.index.dom.unique())).removeValues(Types.TypeConditionOperatorSet.NOTIN, this.value.dom) && this.value.dom.removeValues(Types.TypeConditionOperatorSet.NOTIN, dom))) {
                return false;
            }
            assert (this.controlGAC());
            return true;
        }

        private boolean controlGAC() {
            Kit.control(this.index.dom.size() != 1 || this.domAt(this.index.dom.unique()).subsetOf(this.value.dom), () -> "index is singleton and dom(index) is not included in dom(result).");
            int a = this.index.dom.first();
            while (a != -1) {
                Kit.control(this.domAt(a).overlapWith(this.value.dom), () -> "One var has no value in dom(result).");
                a = this.index.dom.next(a);
            }
            a = this.value.dom.first();
            while (a != -1) {
                int v = this.value.dom.toVal(a);
                int b = this.index.dom.first();
                while (b != -1 && !this.domAt(b).isPresentValue(v)) {
                    b = this.index.dom.next(b);
                }
                Kit.control(b != -1, () -> "value " + v + " is in dom(value) but in no list variable whose index is still in dom(index).");
                a = this.value.dom.next(a);
            }
            return true;
        }
    }

    public static class ElementConstant
    extends Element
    implements TagCompleteFilteringAtEachCall {
        private final int value;

        @Override
        public boolean checkValues(int[] t) {
            return t[t[this.indexPosition] - this.startAt] == this.value;
        }

        public ElementConstant(Problem pb, Variable[] list, int startAt, Variable index, int value) {
            super(pb, list, startAt, index, value);
            this.value = value;
            this.defineKey(value, startAt);
            Kit.control(Variable.areAllDomainsContainingValue(list, value));
            if (this.indexPosition < list.length && this.indexPosition + startAt != value) {
                index.dom.removeValueAtConstructionTime(value);
            }
        }

        public ElementConstant(Problem pb, Variable[] list, Variable index, int value) {
            this(pb, list, 0, index, value);
        }

        @Override
        public boolean runPropagator(Variable dummy) {
            if (this.index.dom.size() > 1 && !this.index.dom.removeIndexesChecking(a -> !this.domAt((int)a).isPresentValue(this.value))) {
                return false;
            }
            return this.index.dom.size() != 1 || this.domAt(this.index.dom.unique()).reduceToValue(this.value);
        }
    }
}

