/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.Arrays;
import java.util.stream.LongStream;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagUnguaranteedGAC;
import utility.sets.SetDense;
import variables.Variable;
import variables.domains.Domain;

public final class BinPackingSimple
extends CtrGlobal
implements TagUnguaranteedGAC,
TagPartialFilteringAtEachCall {
    private final int[] sizes;
    private final int limit;
    private final long[] sums;
    private final SetDense set;

    @Override
    public final boolean checkValues(int[] t) {
        Arrays.fill(this.sums, 0L);
        for (int i = 0; i < t.length; ++i) {
            int n = this.scp[i].dom.toIdx(t[i]);
            this.sums[n] = this.sums[n] + (long)this.sizes[i];
        }
        return LongStream.of(this.sums).noneMatch(l -> l > (long)this.limit);
    }

    public BinPackingSimple(Problem pb, Variable[] scp, int[] sizes, int limit) {
        super(pb, scp);
        Kit.control(scp.length >= 2 && Variable.haveSameDomainType(scp));
        this.defineKey(Kit.join((Object)sizes, new String[0]) + " " + limit);
        this.sizes = sizes;
        this.limit = limit;
        this.sums = new long[scp[0].dom.initSize()];
        this.set = new SetDense(scp.length);
    }

    @Override
    public boolean runPropagator(Variable x) {
        int i;
        Arrays.fill(this.sums, 0L);
        this.set.clear();
        for (i = 0; i < this.scp.length; ++i) {
            int a;
            int n = a = this.scp[i].dom.size() > 1 ? -1 : this.scp[i].dom.unique();
            if (a != -1) {
                int n2 = a;
                this.sums[n2] = this.sums[n2] + (long)this.sizes[i];
                continue;
            }
            this.set.add(i);
        }
        for (i = 0; i < this.sums.length; ++i) {
            if (this.sums[i] <= (long)this.limit) continue;
            return x.dom.fail();
        }
        for (i = this.set.limit; i >= 0; --i) {
            int p = this.set.dense[i];
            Domain dom = this.scp[p].dom;
            int sizeBefore = dom.size();
            int a = dom.first();
            while (a != -1) {
                if (this.sums[a] + (long)this.sizes[p] > (long)this.limit) {
                    this.scp[p].dom.removeElementary(a);
                }
                a = dom.next(a);
            }
            if (this.scp[p].dom.afterElementaryCalls(sizeBefore)) continue;
            return false;
        }
        return true;
    }
}

