/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.AllDifferentAbstract;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagUnguaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetSparse;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class AllDifferentCounting
extends AllDifferentAbstract
implements TagUnguaranteedGAC,
TagCompleteFilteringAtEachCall,
ObserverBacktrackingSystematic {
    private SetSparse[] sets;
    private SetSparse workingDomSet;
    private SetSparse workingVarSet;
    private SetSparse encounteredSizes;
    private SetSparseReversible unfixedVars;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.unfixedVars.restoreLimitAtLevel(depthBeforeBacktrack);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.unfixedVars = new SetSparseReversible(this.scp.length, this.pb.variables.length + 1);
    }

    public AllDifferentCounting(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(Variable.haveSameDomainType(scp) && scp[0].dom.initSize() < 1000);
        this.sets = SetSparse.factoryArray(scp.length, scp[0].dom.initSize() + 1);
        this.workingDomSet = new SetSparse(scp[0].dom.initSize());
        this.workingVarSet = new SetSparse(scp.length);
        this.encounteredSizes = new SetSparse(scp[0].dom.initSize() + 1);
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int j;
        int p;
        int i;
        for (i = 0; i < this.encounteredSizes.size(); ++i) {
            this.sets[this.encounteredSizes.dense[i]].clear();
        }
        Kit.control(Stream.of(this.sets).allMatch(s -> s.isEmpty()));
        this.encounteredSizes.clear();
        for (i = this.unfixedVars.limit; i >= 0; --i) {
            p = this.unfixedVars.dense[i];
            if (this.scp[p].dom.size() > 1) continue;
            Variable x = this.scp[p];
            int v = x.dom.uniqueValue();
            for (j = this.futvars.limit; j >= 0; --j) {
                Variable y = this.scp[this.futvars.dense[j]];
                if (y == x || y.dom.removeValue(v, false)) continue;
                return false;
            }
            this.unfixedVars.remove(p, this.pb.solver.depth());
        }
        for (i = this.unfixedVars.limit; i >= 0; --i) {
            p = this.unfixedVars.dense[i];
            this.sets[this.scp[p].dom.size()].add(p);
            this.encounteredSizes.add(this.scp[p].dom.size());
        }
        Kit.control(this.sets[0].isEmpty());
        for (i = this.sets[1].limit; i >= 0; --i) {
            int vapFixed = this.sets[1].dense[i];
            Variable varFixed = this.scp[vapFixed];
            int valFixed = varFixed.dom.uniqueValue();
            for (j = this.futvars.limit; j >= 0; --j) {
                Variable var = this.scp[this.futvars.dense[j]];
                if (var == varFixed || var.dom.removeValue(valFixed, false)) continue;
                return false;
            }
            this.unfixedVars.remove(vapFixed, this.pb.solver.depth());
        }
        this.workingDomSet.clear();
        this.workingVarSet.clear();
        for (i = 2; i < this.sets.length; ++i) {
            for (int j2 = this.sets[i].limit; j2 >= 0; --j2) {
                int vap = this.sets[i].dense[j2];
                this.workingVarSet.add(vap);
                Domain dom = this.scp[vap].dom;
                int idx = dom.first();
                while (idx != -1) {
                    this.workingDomSet.add(idx);
                    idx = dom.next(idx);
                }
                if (this.workingDomSet.size() < this.workingVarSet.size()) {
                    return false;
                }
                if (this.workingDomSet.size() == this.workingVarSet.size()) {
                    for (int k = this.workingVarSet.limit + 1; k < this.workingVarSet.capacity(); ++k) {
                        if (this.scp[this.workingVarSet.dense[k]].dom.remove(this.workingDomSet, true)) continue;
                        return false;
                    }
                }
                if (this.workingDomSet.size() <= this.unfixedVars.size()) continue;
                return true;
            }
        }
        return true;
    }

    void displaySizes() {
        String s = IntStream.range(2, this.sets.length).filter(i -> this.sets[i].size() != 0).mapToObj(i -> i + ":" + this.sets[i].size()).collect(Collectors.joining(" "));
        Kit.log.info(s);
    }
}

