/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.hard.extension.structures.MDD;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import utility.Kit;
import variables.domains.Domain;

public final class MDDNode {
    public static final MDDNode nodeF = new MDDNode(null, 0);
    public static final MDDNode nodeT = new MDDNode(null, 1);
    public static int nBuiltNodes;
    private static boolean discardClassForNodeF;
    private final MDD mdd;
    public int id;
    public final int level;
    public MDDNode[] sons;
    public int[][] sonsClasses;
    private Integer nSonsDifferentFromNodeF;
    public Object state;

    public String name() {
        return this == nodeF ? "nodeF" : (this == nodeT ? "nodeT" : (this.level == 0 ? "root" : "n" + this.id));
    }

    public int nSonsDifferentFromNodeF() {
        return this.nSonsDifferentFromNodeF != null ? this.nSonsDifferentFromNodeF : (this.nSonsDifferentFromNodeF = Integer.valueOf((int)Stream.of(this.sons).filter(c -> c != nodeF).count()));
    }

    public final boolean isLeaf() {
        return this == nodeF || this == nodeT;
    }

    private MDDNode(MDD mdd, int level) {
        this.mdd = mdd;
        if (mdd == null) {
            this.id = level;
            this.level = -1;
        } else {
            this.id = mdd.nextNodeId();
            this.level = level;
        }
    }

    public MDDNode(MDD mdd, int level, int nSons, boolean defaultNodeF) {
        this(mdd, level);
        this.sons = (MDDNode[])IntStream.range(0, nSons).mapToObj(i -> defaultNodeF ? nodeF : nodeT).toArray(MDDNode[]::new);
    }

    public MDDNode(MDD mdd, int level, int nSons, boolean defaultNodeF, Object state) {
        this(mdd, level, nSons, defaultNodeF);
        this.state = state;
    }

    private void addTuple(int level, int value, int[] tuple, boolean positive, int[] domSizes) {
        MDDNode son = this.sons[value];
        if (!son.isLeaf()) {
            son.addTuple(level + 1, tuple, positive, domSizes);
        } else if (level == tuple.length - 1) {
            this.sons[value] = positive ? nodeT : nodeF;
        } else {
            this.sons[value] = new MDDNode(this.mdd, level + 1, domSizes[level + 1], positive);
            this.sons[value].addTuple(level + 1, tuple, positive, domSizes);
        }
    }

    private void addTuple(int level, int[] tuple, boolean positive, int[] domSizes) {
        if (tuple[level] == 0x7FFFFFFE) {
            for (int i = 0; i < this.sons.length; ++i) {
                this.addTuple(level, i, tuple, positive, domSizes);
            }
        } else {
            this.addTuple(level, tuple[level], tuple, positive, domSizes);
        }
    }

    public void addTuple(int[] tuple, boolean positive, int[] domSizes) {
        this.addTuple(0, tuple, positive, domSizes);
    }

    public void buildSonsClasses() {
        if (this.isLeaf() || this.sonsClasses != null) {
            return;
        }
        Map<MDDNode, List<Integer>> map = IntStream.range(0, this.sons.length).filter(i -> !discardClassForNodeF || this.sons[i] != nodeF).boxed().collect(Collectors.groupingBy(i -> this.sons[i]));
        this.sonsClasses = (int[][])map.values().stream().map(list -> Kit.intArray(list)).toArray(x$0 -> new int[x$0][]);
        Stream.of(this.sons).forEach(s -> s.buildSonsClasses());
    }

    public int nInternalNodes(Set<Integer> set) {
        if (this.isLeaf() || set.contains(this.id)) {
            return 0;
        }
        set.add(this.id);
        return 1 + Stream.of(this.sons).mapToInt(c -> c.nInternalNodes(set)).sum();
    }

    private boolean canReachNodeT(Set<Integer> reachingNodes, Set<Integer> unreachingNodes) {
        if (this == nodeT || reachingNodes.contains(this.id)) {
            return true;
        }
        if (this == nodeF || unreachingNodes.contains(this.id)) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < this.sons.length; ++i) {
            if (!this.sons[i].canReachNodeT(reachingNodes, unreachingNodes)) {
                this.sons[i] = nodeF;
                continue;
            }
            found = true;
        }
        if (found) {
            reachingNodes.add(this.id);
        } else {
            unreachingNodes.add(this.id);
        }
        return found;
    }

    public boolean canReachNodeT() {
        return this.canReachNodeT(new HashSet<Integer>(), new HashSet<Integer>());
    }

    public int renameNodes(int lastId, Map<Integer, MDDNode> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return lastId;
        }
        this.id = ++lastId;
        map.put(this.id, this);
        for (MDDNode son : this.sons) {
            lastId = son.renameNodes(lastId, map);
        }
        return lastId;
    }

    public boolean controlUniqueNodes(Map<Integer, MDDNode> map) {
        MDDNode node = map.get(this.id);
        if (node == null) {
            map.put(this.id, this);
        } else {
            Kit.control(node == this, () -> "two nodes with the same id in the MDD " + this.id);
        }
        return this.sons == null || Stream.of(this.sons).noneMatch(child -> !child.controlUniqueNodes(map));
    }

    public void display(int[] cnts, boolean displayClasses) {
        if (this.isLeaf()) {
            return;
        }
        Kit.log.fine(this.id + "@" + this.level + " => ");
        if (cnts != null) {
            int n = this.level;
            cnts[n] = cnts[n] + 1;
        }
        if (this.sons == null) {
            return;
        }
        Kit.log.fine("{" + Stream.of(this.sons).map(child -> child.id + "").collect(Collectors.joining(",")) + "}");
        if (displayClasses) {
            if (this.sonsClasses != null) {
                for (int i = 0; i < this.sonsClasses.length; ++i) {
                    Kit.log.fine("class " + i + " => {" + Kit.join((Object)this.sonsClasses[i], new String[0]) + "}");
                }
            }
            Kit.log.fine("nNotFFChilds=" + this.nSonsDifferentFromNodeF);
        }
        Stream.of(this.sons).filter(s -> s.id > this.id).forEach(s -> s.display(cnts, displayClasses));
    }

    public void display() {
        this.display(null, false);
    }

    public int displayTuples(Domain[] doms, int[] currTuple, int currLevel, int cnt) {
        if (this == nodeT) {
            Kit.log.info(Kit.join((Object)currTuple, new String[0]));
            ++cnt;
        }
        if (this.isLeaf()) {
            return cnt;
        }
        for (int i = 0; i < this.sons.length; ++i) {
            currTuple[currLevel] = doms[currLevel].toVal(i);
            cnt = this.sons[i].displayTuples(doms, currTuple, currLevel + 1, cnt);
        }
        return cnt;
    }

    private StringBuilder getTransitions(Domain[] doms, StringBuilder sb, Set<MDDNode> processedNodes) {
        if (this.sons != null) {
            for (int i = 0; i < this.sons.length; ++i) {
                if (this.sons[i] == nodeF) continue;
                sb.append("(").append(this.name()).append(",").append(doms[this.level].toVal(i)).append(",").append(this.sons[i].name()).append(")");
            }
            processedNodes.add(this);
            for (MDDNode son : this.sons) {
                if (processedNodes.contains(son)) continue;
                son.getTransitions(doms, sb, processedNodes);
            }
        }
        return sb;
    }

    public String getTransitions(Domain[] doms) {
        return this.getTransitions(doms, new StringBuilder(), new HashSet<MDDNode>()).toString();
    }

    public void collectCompressedTuples(List<int[][]> list, int[][] t, int level) {
        if (this == nodeT) {
            list.add(Kit.cloneDeeply(t));
        }
        if (this.isLeaf()) {
            return;
        }
        for (int i = 0; i < this.sonsClasses.length; ++i) {
            t[level] = this.sonsClasses[i];
            MDDNode representativeChild = this.sons[this.sonsClasses[i][0]];
            representativeChild.collectCompressedTuples(list, t, level + 1);
        }
    }

    public MDDNode filter(int[][] values, int prevVal) {
        int i;
        if (this.isLeaf()) {
            return this;
        }
        MDDNode node = new MDDNode(this.mdd, this.level, this.sons.length, true);
        for (i = 0; i < this.sons.length; ++i) {
            if (values[this.level][i] > prevVal) continue;
            node.sons[i] = this.sons[i];
        }
        for (i = 0; i < this.sons.length; ++i) {
            node.sons[i] = node.sons[i].filter(values, values[this.level][i]);
        }
        return node;
    }

    static {
        discardClassForNodeF = true;
    }
}

