/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionMDD;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.MDDNode;
import constraints.hard.extension.structures.MDDSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Range;
import org.xcsp.common.Utilities;
import org.xcsp.common.structures.Automaton;
import org.xcsp.common.structures.Transition;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class MDD
extends ExtensionStructureHard {
    public MDDNode root;
    private Integer nNodes;
    private boolean reductionWhileProcessingTuples = false;
    private int nCreatedNodes = 2;
    private boolean mustBuildSplitter = false;
    private MDDSplitter splitter;

    public Integer nNodes() {
        return this.nNodes != null ? this.nNodes : (this.nNodes = Integer.valueOf(2 + this.root.nInternalNodes(new HashSet<Integer>())));
    }

    public int nextNodeId() {
        return this.nCreatedNodes++;
    }

    public MDD(CtrExtensionMDD c) {
        super(c);
    }

    public MDD(CtrExtensionMDD c, MDDNode root) {
        this(c);
        this.root = root;
    }

    public MDD(CtrExtensionMDD c, Automaton automata) {
        this(c);
        this.storeTuplesFromAutomata(automata, c.scp.length, (Domain[])Stream.of(c.scp).map(x -> x.dom).toArray(Domain[]::new));
    }

    public MDD(CtrExtensionMDD c, Object[][] transitions) {
        this(c);
        this.storeTuplesFromTransitions(transitions, (Domain[])Stream.of(c.scp).map(x -> x.dom).toArray(Domain[]::new));
    }

    public MDD(CtrExtensionMDD c, int[] coeffs, Object limits) {
        this(c);
        this.storeTuplesFromKnapsack(coeffs, limits, Variable.initDomainValues(c.scp));
    }

    private MDDNode recursiveReduction(MDDNode node, Map<Kit.IntArrayHashKey, MDDNode> reductionMap) {
        if (node.isLeaf()) {
            return node;
        }
        for (int i = 0; i < node.sons.length; ++i) {
            node.sons[i] = this.recursiveReduction(node.sons[i], reductionMap);
        }
        Kit.IntArrayHashKey hk = new Kit.IntArrayHashKey(Stream.of(node.sons).mapToInt(c -> c.id).toArray());
        return reductionMap.computeIfAbsent(hk, k -> node);
    }

    private void reduce(int[] prevTuple, int[] currTuple, Map<Kit.IntArrayHashKey, MDDNode> reductionMap) {
        int i = 0;
        MDDNode node = this.root;
        while (prevTuple[i] == currTuple[i]) {
            node = node.sons[prevTuple[i++]];
        }
        node.sons[prevTuple[i]] = this.recursiveReduction(node.sons[prevTuple[i]], reductionMap);
    }

    private void finalizeStoreTuples() {
        this.root.buildSonsClasses();
        this.nNodes = this.root.renameNodes(1, new HashMap<Integer, MDDNode>()) + 1;
        Kit.log.info("MDD : nNodes=" + this.nNodes + " nBuiltNodes=" + this.nCreatedNodes);
        assert (this.root.controlUniqueNodes(new HashMap<Integer, MDDNode>()));
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Kit.control(positive && tuples.length > 0);
        Constraint ctr = this.firstRegisteredCtr();
        int[] domainSizes = Variable.domSizeArrayOf(ctr.scp, true);
        HashMap<Kit.IntArrayHashKey, MDDNode> reductionMap = new HashMap<Kit.IntArrayHashKey, MDDNode>(2000);
        this.root = new MDDNode(this, 0, domainSizes[0], positive);
        if (ctr.indexesMatchValues) {
            for (int i = 0; i < tuples.length; ++i) {
                this.root.addTuple(tuples[i], positive, domainSizes);
                if (!this.reductionWhileProcessingTuples || i <= 0) continue;
                this.reduce(tuples[i - 1], tuples[i], reductionMap);
            }
        } else {
            int[] previousTuple = null;
            int[] currentTuple = new int[tuples[0].length];
            for (int[] tuple : tuples) {
                for (int i = 0; i < currentTuple.length; ++i) {
                    currentTuple[i] = tuple[i] == 0x7FFFFFFE ? 0x7FFFFFFE : ctr.scp[i].dom.toIdx(tuple[i]);
                }
                this.root.addTuple(currentTuple, positive, domainSizes);
                if (!this.reductionWhileProcessingTuples) continue;
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(previousTuple, currentTuple, reductionMap);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
        }
        if (!this.reductionWhileProcessingTuples) {
            this.recursiveReduction(this.root, reductionMap);
        }
        this.finalizeStoreTuples();
    }

    public MDD storeTuplesFromTransitions(Object[][] transitions, Domain[] domains) {
        HashMap<String, MDDNode> nodes = new HashMap<String, MDDNode>();
        HashSet<String> possibleRoots = new HashSet<String>();
        HashSet<String> notRoots = new HashSet<String>();
        HashSet<String> possibleWells = new HashSet<String>();
        HashSet<String> notWells = new HashSet<String>();
        for (Object[] tr : transitions) {
            String src = (String)tr[0];
            String tgt = (String)tr[2];
            notWells.add(src);
            notRoots.add(tgt);
            if (!notRoots.contains(src)) {
                possibleRoots.add(src);
            }
            if (!notWells.contains(tgt)) {
                possibleWells.add(tgt);
            }
            if (possibleRoots.contains(tgt)) {
                possibleRoots.remove(tgt);
            }
            if (!possibleWells.contains(src)) continue;
            possibleWells.remove(src);
        }
        Kit.control(possibleRoots.size() == 1 && possibleWells.size() == 1, () -> "sizes= " + possibleRoots.size() + " " + possibleWells.stream().collect(Collectors.joining(" ")));
        String sroot = possibleRoots.toArray(new String[1])[0];
        String swell = possibleWells.toArray(new String[1])[0];
        this.root = new MDDNode(this, 0, domains[0].initSize(), true);
        nodes.put(sroot, this.root);
        nodes.put(swell, MDDNode.nodeT);
        for (Object[] tr : transitions) {
            MDDNode node2;
            MDDNode node1 = (MDDNode)nodes.get(tr[0]);
            int val = Utilities.safeLong2Int((Number)((Number)tr[1]), (boolean)true);
            int idx = domains[node1.level].toIdx(val);
            Kit.control(idx != -1);
            node1.sons[idx] = node2 = nodes.computeIfAbsent((String)tr[2], k -> new MDDNode(this, node1.level + 1, domains[node1.level + 1].initSize(), true));
        }
        this.finalizeStoreTuples();
        return this;
    }

    private Map<String, List<Transition>> buildNextTransitions(Automaton automata) {
        HashMap<String, List<Transition>> map = new HashMap<String, List<Transition>>();
        map.put(automata.startState, new ArrayList());
        Stream.of(automata.finalStates).forEach(s -> {
            List cfr_ignored_0 = map.put((String)s, new ArrayList());
        });
        Stream.of(automata.transitions).forEach(t -> {
            map.put(t.firstState, new ArrayList());
            map.put(t.secondState, new ArrayList());
        });
        Stream.of(automata.transitions).forEach(t -> ((List)map.get(t.firstState)).add(t));
        return map;
    }

    public MDD storeTuplesFromAutomata(Automaton automata, int arity, Domain[] domains) {
        Kit.control(arity > 1 && IntStream.range(1, domains.length).allMatch(i -> domains[i].typeIdentifier() == domains[0].typeIdentifier()));
        Map<String, List<Transition>> nextTrs = this.buildNextTransitions(automata);
        this.root = new MDDNode(this, 0, domains[0].initSize(), true, automata.startState);
        HashMap<String, MDDNode> prevs = new HashMap<String, MDDNode>();
        HashMap<String, MDDNode> nexts = new HashMap<String, MDDNode>();
        prevs.put((String)this.root.state, this.root);
        for (int i2 = 0; i2 < arity; ++i2) {
            for (MDDNode node : prevs.values()) {
                for (Transition tr : nextTrs.get(node.state)) {
                    int v = Utilities.safeLong2Int((Number)((Number)tr.symbol), (boolean)true);
                    int a = domains[i2].toIdx(v);
                    if (a == -1) continue;
                    String nextState = tr.secondState;
                    if (i2 == arity - 1) {
                        node.sons[a] = Utilities.indexOf((String)nextState, (String[])automata.finalStates) != -1 ? MDDNode.nodeT : MDDNode.nodeF;
                        continue;
                    }
                    MDDNode nextNode = (MDDNode)nexts.get(nextState);
                    if (nextNode == null) {
                        nextNode = new MDDNode(this, i2 + 1, domains[i2].initSize(), true, nextState);
                        nexts.put(nextState, nextNode);
                    }
                    node.sons[a] = nextNode;
                }
            }
            HashMap<String, MDDNode> tmp = prevs;
            prevs = nexts;
            nexts = tmp;
            nexts.clear();
        }
        this.root.canReachNodeT();
        this.finalizeStoreTuples();
        return this;
    }

    public MDD storeTuplesFromKnapsack(int[] coeffs, Object limits, int[][] values) {
        this.root = new MDDNode(this, 0, values[0].length, true, 0);
        HashMap<Integer, MDDNode> prevs = new HashMap<Integer, MDDNode>();
        HashMap<Integer, MDDNode> nexts = new HashMap<Integer, MDDNode>();
        prevs.put((Integer)this.root.state, this.root);
        for (int level = 0; level < coeffs.length; ++level) {
            for (MDDNode node : prevs.values()) {
                for (int j = 0; j < values[level].length; ++j) {
                    int nextState = (Integer)node.state + coeffs[level] * values[level][j];
                    if (level == coeffs.length - 1) {
                        if (limits instanceof Range) {
                            node.sons[j] = ((Range)limits).contains(nextState) ? MDDNode.nodeT : MDDNode.nodeF;
                            continue;
                        }
                        node.sons[j] = Utilities.indexOf((int)nextState, (int[])((int[])limits)) != -1 ? MDDNode.nodeT : MDDNode.nodeF;
                        continue;
                    }
                    MDDNode nextNode = (MDDNode)nexts.get(nextState);
                    if (nextNode == null) {
                        nextNode = new MDDNode(this, level + 1, values[level + 1].length, true, nextState);
                        nexts.put(nextState, nextNode);
                    }
                    node.sons[j] = nextNode;
                }
            }
            HashMap<Integer, MDDNode> tmp = prevs;
            prevs = nexts;
            nexts = tmp;
            nexts.clear();
        }
        this.root.canReachNodeT();
        boolean increasing = false;
        if (!increasing) {
            this.finalizeStoreTuples();
        } else {
            this.root = this.root.filter(values, Integer.MAX_VALUE);
            this.recursiveReduction(this.root, new HashMap<Kit.IntArrayHashKey, MDDNode>(2000));
            this.finalizeStoreTuples();
            this.root.display();
            this.displayTuples();
        }
        return this;
    }

    @Override
    public boolean checkIdxs(int[] t) {
        MDDNode node = this.root;
        int i = 0;
        while (!node.isLeaf()) {
            node = node.sons[t[i]];
            ++i;
        }
        return node == MDDNode.nodeT;
    }

    public void displayTuples() {
        int cnt = this.root.displayTuples(Variable.buildDomainsArrayFor(this.firstRegisteredCtr().scp), new int[this.firstRegisteredCtr().scp.length], 0, 0);
        Kit.log.info(" => " + cnt + " tuples");
    }

    public MDDSplitter getSplitter() {
        return this.splitter;
    }

    void buildSplitter() {
        if (this.mustBuildSplitter) {
            int arity = this.firstRegisteredCtr().scp.length;
            this.splitter = new MDDSplitter(this, new int[]{(int)Math.ceil((double)arity / 2.0), (int)Math.floor((double)arity / 2.0)});
        }
    }

    public int[][][] buildCompressedTable() {
        Constraint ctr = this.firstRegisteredCtr();
        LinkedList<int[][]> list = new LinkedList<int[][]>();
        this.root.collectCompressedTuples(list, new int[ctr.scp.length][], 0);
        int[][][] compressedTuples = Kit.intArray3D(list);
        return compressedTuples;
    }

    public static void main(String[] args) {
        int length = Integer.parseInt(args[0]);
    }
}

