/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.Table;
import java.util.Arrays;
import problem.Problem;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagNegative;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class CtrExtensionSTR2NEG
extends CtrExtension
implements FilteringGlobal,
TagGuaranteedGAC,
TagNegative,
ObserverBacktrackingSystematic {
    protected int[][] tuples;
    protected SetDenseReversible set;
    protected int[][] nConflicts;
    protected int[] nMaxConflicts;
    protected long[] nValidTuples;
    protected int sSupSize;
    protected int[] sSup;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.set.restoreLimitAtLevel(depthBeforeBacktrack);
        Arrays.fill(this.nMaxConflicts, 0);
    }

    public CtrExtensionSTR2NEG(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.tuples = ((Table)this.extStructure).tuples;
        this.set = new SetDenseReversible(this.tuples.length, this.pb.variables.length + 1);
        this.nConflicts = Variable.litterals(this.scp).intArray();
        this.nMaxConflicts = new int[this.scp.length];
        this.nValidTuples = new long[this.scp.length];
        this.sSup = new int[this.scp.length];
    }

    @Override
    protected ExtensionStructureHard buildExtensionStructure() {
        return new Table(this);
    }

    protected void initializeStructuresBeforeFiltering() {
        this.sSupSize = 0;
        long nValid = Variable.nValidTuplesBoundedAtMaxValueFor(this.scp);
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            long limit = nValid / (long)this.doms[x].size();
            if ((long)this.set.size() < limit || this.set.size() < this.nMaxConflicts[x]) continue;
            this.sSup[this.sSupSize++] = x;
            Arrays.fill(this.nConflicts[x], 0);
            this.nMaxConflicts[x] = 0;
            this.nValidTuples[x] = limit;
        }
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.initializeStructuresBeforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple)) {
                for (int j = this.sSupSize - 1; j >= 0; --j) {
                    int x = this.sSup[j];
                    int a = tuple[x];
                    int[] nArray = this.nConflicts[x];
                    int n = a;
                    int n2 = nArray[n] + 1;
                    nArray[n] = n2;
                    this.nMaxConflicts[x] = Math.max(this.nMaxConflicts[x], n2);
                    if ((long)this.nConflicts[x][a] == this.nValidTuples[x]) {
                        if (this.scp[x].dom.remove(a)) continue;
                        return false;
                    }
                    if ((long)(this.nMaxConflicts[x] + i) >= this.nValidTuples[x]) continue;
                    this.sSup[j] = this.sSup[--this.sSupSize];
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return true;
    }
}

