/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.extension.CtrExtensionSTROptimized;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import variables.Variable;

public class CtrExtensionSTR2
extends CtrExtensionSTROptimized {
    public CtrExtensionSTR2(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    @Override
    protected void initSpecificStructures() {
        this.buildBasicCollectingStructures();
        this.buildBasicOptimizationSets();
    }

    protected boolean isValidTuple(int[] tuple) {
        for (int i = this.sValSize - 1; i >= 0; --i) {
            int x = this.sVal[i];
            if (tuple[x] == 0x7FFFFFFE || this.doms[x].isPresent(tuple[x])) continue;
            return false;
        }
        return true;
    }

    private void removeInitialSequenceOfInvalidTuples() {
        int cnt = 0;
        for (int i = this.set.limit; i >= 0 && !this.isValidTuple(this.tuples[this.set.dense[i]]); --i) {
            ++cnt;
        }
        if (cnt > 0) {
            this.set.moveLimitAtLevel(cnt, this.pb.solver.depth());
        }
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValidTuple(tuple)) {
                for (int j = this.sSupSize - 1; j >= 0; --j) {
                    int x = this.sSup[j];
                    int a = tuple[x];
                    if (a == 0x7FFFFFFE) {
                        this.cnts[x] = 0;
                        this.sSup[j] = this.sSup[--this.sSupSize];
                        continue;
                    }
                    if (this.ac[x][a]) continue;
                    this.ac[x][a] = true;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    if (this.cnts[n] != 0) continue;
                    this.sSup[j] = this.sSup[--this.sSupSize];
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        assert (this.controlValidTuples());
        return this.updateDomains();
    }

    private boolean controlValidTuples() {
        int[] dense = this.set.dense;
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[dense[i]];
            for (int j = tuple.length - 1; j >= 0; --j) {
                if (tuple[j] == 0x7FFFFFFE || this.doms[j].isPresent(tuple[j])) continue;
                System.out.println(this + " at " + this.pb.solver.depth() + "\n" + Kit.join((Object)tuple, new String[0]));
                Stream.of(this.scp).forEach(x -> x.display(true));
                return false;
            }
        }
        return true;
    }
}

