/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.CtrHard;
import constraints.TupleManager;
import constraints.hard.ConflictsStructure;
import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructure;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import propagation.structures.supporters.Supporter;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import utility.exceptions.UnreachableCodeException;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.FilteringSpecific;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagSymmetric;
import utility.interfaces.TagUnguaranteedGAC;
import utility.interfaces.TagUnsymmetric;
import utility.observers.ObserverConstructionProblem;
import utility.observers.ObserverConstructionSolver;
import utility.operations.Calculator;
import utility.sets.SetDense;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public abstract class Constraint
implements ICtr,
ObserverConstructionProblem,
Comparable<Constraint> {
    public static final int MAX_FILTERING_COMPLEXITY = 2;
    private static Map<String, int[]> symmetryMatchings = Collections.synchronizedMap(new HashMap());
    public static final Constraint TAG = new CtrHard(){

        @Override
        public boolean checkValues(int[] t) {
            throw new UnreachableCodeException();
        }
    };
    public final Problem pb;
    public int num = -1;
    private String id;
    public final Variable[] scp;
    private int[] vaps;
    public SetDense futvars;
    public boolean ignored;
    public String key;
    public final TupleManager tupleManager;
    protected Supporter<? extends Constraint> supporter;
    private double wdeg;
    private double[] wdegs;
    public final boolean indexesMatchValues;
    protected final int[] vals;
    public final Domain[] doms;
    public int cost = 1;
    public long timestamp;
    public int filteringComplexity;
    public final int genericFilteringThreshold;
    public int nEffectiveFilterings;
    public Object data;
    private boolean test = false;

    @Override
    public void onConstructionProblemFinished() {
        if (this.pb.rs.cp.constraints.arityLimitForVapArray < this.scp.length && (this.pb.variables.length < this.pb.rs.cp.constraints.arityLimitForVapArrayUB || this.scp.length > this.pb.variables.length / 3)) {
            this.vaps = Kit.repeat(-1, this.pb.variables.length);
            for (int i = 0; i < this.scp.length; ++i) {
                this.vaps[this.scp[i].num] = i;
            }
        } else {
            this.vaps = null;
        }
    }

    @Override
    public int compareTo(Constraint c) {
        boolean b2;
        boolean b1 = this.id == null;
        boolean bl = b2 = c.id == null;
        return b1 && !b2 ? -1 : (!b1 && b2 ? 1 : (!b1 && !b2 ? this.id.compareTo(c.id) : Integer.compare(this.num, c.num)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getSymmetryMatching(String key) {
        Map<String, int[]> map = symmetryMatchings;
        synchronized (map) {
            return symmetryMatchings.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSymmetryMatching(String key, int[] value) {
        Map<String, int[]> map = symmetryMatchings;
        synchronized (map) {
            symmetryMatchings.put(key, value);
        }
    }

    public static int nPairsOfCtrsWithSimilarScopeIn(Constraint ... ctrs) {
        return IntStream.range(0, ctrs.length).map(i -> (int)IntStream.range(i + 1, ctrs.length).filter(j -> Variable.areSimilarArrays(ctrs[i].scp, ctrs[j].scp)).count()).sum();
    }

    public static final boolean areNumsNormalized(Constraint[] ctrs) {
        return IntStream.range(0, ctrs.length).noneMatch(i -> i != ctrs[i].num);
    }

    public static final boolean isInvolvingAbsentVar(Constraint c, boolean[] presentVars) {
        return Stream.of(c.scp).anyMatch(x -> !presentVars[x.num]);
    }

    public static final boolean isGuaranteedGACOn(Constraint[] ctrs) {
        return Stream.of(ctrs).allMatch(c -> c.isGuaranteedGAC());
    }

    public static final long costOfCoveredConstraintsIn(Constraint[] ctrs) {
        long cost = 0L;
        for (Constraint c : ctrs) {
            if (c.futvars.size() != 0) continue;
            cost = Calculator.add(cost, c.costOfCurrInstantiation());
        }
        return cost;
    }

    public final String defaultId() {
        return "c" + this.num;
    }

    public final String explicitId() {
        return this.id;
    }

    public final String getId() {
        return this.id != null ? this.id : this.defaultId();
    }

    public final Constraint setId(String id) {
        this.id = id;
        return this;
    }

    public int[] defineSymmetryMatching() {
        if (this instanceof TagSymmetric) {
            return Kit.repeat(1, this.scp.length);
        }
        if (this instanceof TagUnsymmetric) {
            return Kit.range(1, this.scp.length);
        }
        throw new MissingImplementationException();
    }

    public final int[] getSymmetryMatching() {
        return Constraint.getSymmetryMatching(this.key);
    }

    public void handleEffectiveFilterings() {
        if (this.pb.solver instanceof SolverBacktrack) {
            ((SolverBacktrack)this.pb.solver).proofer.updateProof(this);
        }
        ++this.nEffectiveFilterings;
        ++this.pb.stuff.nEffectiveFilterings;
    }

    public final int computeGenericFilteringThreshold() {
        if (this instanceof FilteringSpecific || this instanceof CtrExtension) {
            return Integer.MAX_VALUE;
        }
        int arityLimit = this.pb.rs.cp.propagating.arityLimitForGACGuaranteed;
        if (this.scp.length <= arityLimit) {
            return Integer.MAX_VALUE;
        }
        int futureLimitation = this.pb.rs.cp.propagating.futureLimitation;
        if (futureLimitation != -1) {
            return futureLimitation < this.scp.length ? Math.max(arityLimit, futureLimitation) : Integer.MAX_VALUE;
        }
        int spaceLimitation = this.pb.rs.cp.propagating.spaceLimitation;
        if (spaceLimitation != -1) {
            double limit = Math.pow(2.0, spaceLimitation);
            Variable[] vars = Kit.sort((Object[])this.scp.clone(), Variable.decreasingDomSizeComparator);
            int i = 0;
            double prod = 1.0;
            for (i = 0; i < vars.length && prod <= limit; prod *= (double)vars[i].dom.size(), ++i) {
            }
            return prod > limit ? Math.max(arityLimit, i - 1) : Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    public boolean completeFilteringAtEachCall() {
        if (this instanceof TagCompleteFilteringAtEachCall) {
            return true;
        }
        if (this instanceof TagPartialFilteringAtEachCall) {
            return false;
        }
        throw new MissingImplementationException(this.getClass().getName());
    }

    public boolean isGuaranteedGAC() {
        if (this instanceof TagGuaranteedGAC) {
            return true;
        }
        if (this instanceof TagUnguaranteedGAC) {
            return false;
        }
        if (this instanceof FilteringSpecific) {
            throw new MissingImplementationException(this.getClass().getName());
        }
        return this.genericFilteringThreshold == Integer.MAX_VALUE;
    }

    public final boolean canBeCurrentlyGenericallyFiltered() {
        return this.futvars.size() > 0 && this.futvars.size() <= this.genericFilteringThreshold;
    }

    public final int positionOf(Variable x) {
        if (this.vaps != null) {
            return this.vaps[x.num];
        }
        for (int i = this.scp.length - 1; i >= 0; --i) {
            if (this.scp[i] != x) continue;
            return i;
        }
        return -1;
    }

    public final boolean involves(Variable x) {
        return this.positionOf(x) != -1;
    }

    public final boolean involves(Variable x, Variable y) {
        return this.positionOf(x) != -1 && this.positionOf(y) != -1;
    }

    public final boolean isScopeCoveredBy(Variable[] vars) {
        int cnt = 0;
        for (int i = 0; i < vars.length; ++i) {
            if (!this.involves(vars[i]) || ++cnt != this.scp.length) continue;
            return true;
        }
        return false;
    }

    public Supporter<? extends Constraint> supporter() {
        return this.supporter;
    }

    public abstract void buildSupporter();

    public final double wdeg() {
        return this.wdeg;
    }

    public final void resetWdeg() {
        this.wdeg = this.pb.rs.cp.varh.initialWdeg;
        if (!this.pb.rs.cp.experimental.testB) {
            if (this.wdegs == null) {
                this.wdegs = new double[this.scp.length];
            }
            Arrays.fill(this.wdegs, this.pb.rs.cp.varh.weighting == Enums.EWeighting.CA_CD ? 0.0 : (double)this.pb.rs.cp.varh.initialWdeg);
        }
    }

    public final void updateNegativelyWdegOf(int x) {
        this.scp[x].wdeg = this.scp[x].wdeg + (this.pb.rs.cp.experimental.testB ? -this.wdeg : -this.wdegs[x]);
    }

    public final void updatePositivelyWdegOf(int x) {
        this.scp[x].wdeg = this.scp[x].wdeg + (this.pb.rs.cp.experimental.testB ? this.wdeg : this.wdegs[x]);
    }

    public final void incrementWdegBy(double increment) {
        this.wdeg += increment;
        this.pb.rs.observerRemote.onWdegModified(this);
        if (this.pb.rs.cp.experimental.testB) {
            for (Variable x : this.scp) {
                x.wdeg += increment;
            }
        } else {
            int depth = this.pb.solver.depth();
            for (int i = this.futvars.limit; i >= 0; --i) {
                int x = this.futvars.dense[i];
                if (this.pb.rs.cp.varh.weighting == Enums.EWeighting.CA_CD) {
                    if (this.test) {
                        Domain dom = this.scp[x].dom;
                        int nRemoved = 0;
                        int a = dom.lastRemoved();
                        while (a != -1 && dom.getRemovedLevelOf(a) == depth) {
                            ++nRemoved;
                            a = dom.prevRemoved(a);
                        }
                        increment = 1.0 / (double)(this.futvars.size() * (this.scp[x].dom.size() + nRemoved));
                    } else {
                        int size = this.scp[x].dom.size();
                        increment = 1.0 / ((double)this.futvars.size() * (size == 0 ? 0.5 : (double)size));
                    }
                }
                this.scp[x].wdeg += increment;
                int n = x;
                this.wdegs[n] = this.wdegs[n] + increment;
            }
        }
    }

    public ExtensionStructure extStructure() {
        return null;
    }

    public ConflictsStructure conflictsStructure() {
        return null;
    }

    public void cloneStructures(boolean onlyConflictsStructure) {
    }

    public final void reset(boolean preserveWeightedDegrees) {
        Kit.control(this.futvars.free() == 0);
        if (!preserveWeightedDegrees) {
            this.resetWdeg();
        }
        this.nEffectiveFilterings = 0;
        this.timestamp = 0L;
    }

    public final void reset() {
        this.reset(false);
    }

    protected Constraint() {
        this.pb = null;
        this.scp = new Variable[0];
        this.tupleManager = null;
        this.vals = null;
        this.doms = null;
        this.genericFilteringThreshold = Integer.MAX_VALUE;
        this.indexesMatchValues = false;
    }

    public Constraint(Problem pb, Variable[] scp) {
        this.pb = pb;
        scp = (Variable[])Stream.of(scp).distinct().toArray(Variable[]::new);
        this.scp = scp;
        assert (scp.length >= 1 && Stream.of(scp).allMatch(x -> x != null) && Variable.areAllDistinct(scp)) : this + " with a scope badly formed ";
        Stream.of(scp).forEach(x -> x.collectedCtrs.add(this));
        this.doms = Variable.buildDomainsArrayFor(scp);
        this.tupleManager = new TupleManager((Domain[])this.doms.clone());
        this.vals = new int[scp.length];
        this.genericFilteringThreshold = this.computeGenericFilteringThreshold();
        this.indexesMatchValues = Stream.of(scp).allMatch(x -> x.dom.indexesMatchValues());
        if (this instanceof FilteringSpecific) {
            ++pb.stuff.nSpecificCtrs;
        }
        if (this instanceof FilteringGlobal) {
            ++pb.stuff.nGlobalCtrs;
        }
        if (this instanceof ObserverConstructionProblem) {
            pb.rs.observersConstructionProblem.add(this);
        }
        if (this instanceof ObserverConstructionSolver) {
            pb.rs.observersConstructionSolver.add((ObserverConstructionSolver)((Object)this));
        }
        this.futvars = scp.length <= pb.rs.cp.constraints.arityLimitForVapArray ? new SetDense(scp.length, true) : new SetSparse(scp.length, true);
        this.resetWdeg();
    }

    public final void doPastVariable(Variable x) {
        if (this.vaps != null && this.futvars instanceof SetSparse) {
            ((SetSparse)this.futvars).remove(this.vaps[x.num]);
        } else {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (this.scp[this.futvars.dense[i]] != x) continue;
                this.futvars.removeAtPosition(i);
                break;
            }
        }
        if (this.futvars.size() == 1 && this.pb.rs.cp.varh.weighting != Enums.EWeighting.VAR) {
            this.updateNegativelyWdegOf(this.futvars.dense[0]);
        }
    }

    public final void undoPastVariable(Variable x) {
        assert (x.isAssigned() && this.scp[this.futvars.dense[this.futvars.size()]] == x);
        if (this.futvars.size() == 1 && this.pb.rs.cp.varh.weighting != Enums.EWeighting.VAR) {
            this.updatePositivelyWdegOf(this.futvars.dense[0]);
        }
        ++this.futvars.limit;
    }

    public int[] buildCurrentInstantiationTuple() {
        int[] tuple = this.tupleManager.localTuple;
        for (int i = tuple.length - 1; i >= 0; --i) {
            tuple[i] = this.doms[i].unique();
        }
        return tuple;
    }

    public int[] toVals(int[] idxs) {
        for (int i = this.vals.length - 1; i >= 0; --i) {
            this.vals[i] = this.doms[i].toVal(idxs[i]);
        }
        return this.vals;
    }

    public int[] toIdxs(int[] vals, int[] idxs) {
        for (int i = vals.length - 1; i >= 0; --i) {
            idxs[i] = this.doms[i].toIdx(vals[i]);
        }
        return idxs;
    }

    public final boolean isValid(int[] tuple) {
        for (int i = tuple.length - 1; i >= 0; --i) {
            if (this.doms[i].isPresent(tuple[i])) continue;
            return false;
        }
        return true;
    }

    public long costOfCurrInstantiation() {
        return this.costOfIdxs(this.buildCurrentInstantiationTuple());
    }

    public abstract long costOfIdxs(int[] var1);

    public abstract long minCostOfTuplesWith(int var1, int var2);

    public abstract boolean filterFrom(Variable var1);

    public boolean removeTuple(int ... idxs) {
        throw new UnreachableCodeException();
    }

    public abstract boolean isSubstitutableBy(Variable var1, int var2, int var3);

    public abstract boolean controlArcConsistency();

    public StringBuilder signature() {
        return Variable.signatureFor(this.scp);
    }

    public String toString() {
        return this.getId() + "(" + Variable.joinNames(this.scp, ",") + ")";
    }

    public void display(boolean exhaustively) {
        Kit.log.finer("Constraint " + this.toString());
        Kit.log.finer("\tClass = " + this.getClass().getName() + (this instanceof CtrExtension ? ":" + ((CtrExtension)this).extStructure().getClass().getSimpleName() : ""));
        Kit.log.finer("\tKey = " + this.key);
        int[] t = Constraint.getSymmetryMatching(this.key);
        Kit.log.finer("\tSymmetryMatching = " + (t == null ? " undefined " : Kit.join((Object)t, new String[0])));
        Kit.log.finer("\tCost = " + this.cost);
    }

    protected String compact(Variable[] vars) {
        return this.pb.varEntities.compact((IVar[])vars);
    }

    protected String compactOrdered(Variable[] vars) {
        return this.pb.varEntities.compactOrdered((IVar[])vars);
    }
}

