from enum import StrEnum


class UserLang(StrEnum):
    AR = "ar"
    """ar"""
    DE = "de"
    """de"""
    EN = "en"
    """en"""
    ES = "es"
    """es"""
    FA = "fa"
    """fa"""
    FR = "fr"
    """fr"""
    HI = "hi"
    """hi"""
    IT = "it"
    """it"""
    JA = "ja"
    """ja"""
    PT = "pt"
    """pt"""
    RU = "ru"
    """ru"""
    TL = "tl"
    """tl"""
    TR = "tr"
    """tr"""
    VI = "vi"
    """vi"""
    ZH = "zh"
    """zh"""


class ImageGenModel(StrEnum):
    FAL_SD3 = "fal_sd3"
    """fal_sd3"""
    FAL_FLUX_DEV = "fal_flux_dev"
    """fal_flux_dev"""
    FAL_FLUX_PRO = "fal_flux_pro"
    """fal_flux_pro"""
    FAL_BRIA = "fal_bria"
    """fal_bria"""


class ImageGenSize(StrEnum):
    SQUARE = "square"
    """square"""
    PORTRAIT_4_3 = "portrait_4_3"
    """portrait_4_3"""
    PORTRAIT_16_9 = "portrait_16_9"
    """portrait_16_9"""
    LANDSCAPE_4_3 = "landscape_4_3"
    """landscape_4_3"""
    LANDSCAPE_16_9 = "landscape_16_9"
    """landscape_16_9"""


class MessageVisibility(StrEnum):
    NORMAL = "normal"
    """normal"""
    SILENT = "silent"
    """silent"""
    HIDDEN = "hidden"
    """hidden"""


class MessageColor(StrEnum):
    ACCENT = "accent"
    """accent"""
    ERROR = "error"
    """error"""
    NOTICE = "notice"
    """notice"""


class Mood(StrEnum):
    NEUTRAL = "neutral"
    """neutral"""
    HAPPY = "happy"
    """happy"""
    ANGRY = "angry"
    """angry"""
    SAD = "sad"
    """sad"""
    FEAR = "fear"
    """fear"""
    DISGUST = "disgust"
    """disgust"""
    LOVE = "love"
    """love"""
    SLEEP = "sleep"
    """sleep"""


class Icon(StrEnum):
    WEB = "web"
    """web"""
    INSTAGRAM = "instagram"
    """instagram"""
    TIKTOK = "tiktok"
    """tiktok"""
    YOUTUBE = "youtube"
    """youtube"""
    X = "x"
    """x"""
    THREADS = "threads"
    """threads"""
    FACEBOOK = "facebook"
    """facebook"""
    PINTEREST = "pinterest"
    """pinterest"""
    WHATSAPP = "whatsapp"
    """whatsapp"""
    SNAPCHAT = "snapchat"
    """snapchat"""
    IMAGE = "image"
    """image"""
    SETTINGS = "settings"
    """settings"""
    CHAT = "chat"
    """chat"""


class FileType(StrEnum):
    MARKDOWN = "markdown"
    """markdown"""
    LINK = "link"
    """link"""
    IMAGE = "image"
    """image"""
    PDF = "pdf"
    """pdf"""
    AUDIO = "audio"
    """audio"""
    VIDEO = "video"
    """video"""
    PAGE = "page"
    """page"""


class BotTag(StrEnum):
    VIDEO = "video"
    """video"""
    CRON = "cron"
    """cron"""
    WEB = "web"
    """web"""
    NEWS = "news"
    """news"""


class Timezone(StrEnum):
    PACIFIC_MIDWAY = "Pacific/Midway"
    """Pacific/Midway"""
    PACIFIC_HONOLULU = "Pacific/Honolulu"
    """Pacific/Honolulu"""
    AMERICA_JUNEAU = "America/Juneau"
    """America/Juneau"""
    AMERICA_BOISE = "America/Boise"
    """America/Boise"""
    AMERICA_DAWSON = "America/Dawson"
    """America/Dawson"""
    AMERICA_CHIHUAHUA = "America/Chihuahua"
    """America/Chihuahua"""
    AMERICA_PHOENIX = "America/Phoenix"
    """America/Phoenix"""
    AMERICA_CHICAGO = "America/Chicago"
    """America/Chicago"""
    AMERICA_REGINA = "America/Regina"
    """America/Regina"""
    AMERICA_MEXICO_CITY = "America/Mexico_City"
    """America/Mexico_City"""
    AMERICA_BELIZE = "America/Belize"
    """America/Belize"""
    AMERICA_DETROIT = "America/Detroit"
    """America/Detroit"""
    AMERICA_BOGOTA = "America/Bogota"
    """America/Bogota"""
    AMERICA_CARACAS = "America/Caracas"
    """America/Caracas"""
    AMERICA_SANTIAGO = "America/Santiago"
    """America/Santiago"""
    AMERICA_ST_JOHNS = "America/St_Johns"
    """America/St_Johns"""
    AMERICA_SAO_PAULO = "America/Sao_Paulo"
    """America/Sao_Paulo"""
    AMERICA_TIJUANA = "America/Tijuana"
    """America/Tijuana"""
    AMERICA_MONTEVIDEO = "America/Montevideo"
    """America/Montevideo"""
    AMERICA_ARGENTINA_BUENOS_AIRES = "America/Argentina/Buenos_Aires"
    """America/Argentina/Buenos_Aires"""
    AMERICA_GODTHAB = "America/Godthab"
    """America/Godthab"""
    AMERICA_LOS_ANGELES = "America/Los_Angeles"
    """America/Los_Angeles"""
    ATLANTIC_AZORES = "Atlantic/Azores"
    """Atlantic/Azores"""
    ATLANTIC_CAPE_VERDE = "Atlantic/Cape_Verde"
    """Atlantic/Cape_Verde"""
    UTC = "UTC"
    """UTC"""
    EUROPE_LONDON = "Europe/London"
    """Europe/London"""
    EUROPE_DUBLIN = "Europe/Dublin"
    """Europe/Dublin"""
    EUROPE_LISBON = "Europe/Lisbon"
    """Europe/Lisbon"""
    AFRICA_CASABLANCA = "Africa/Casablanca"
    """Africa/Casablanca"""
    ATLANTIC_CANARY = "Atlantic/Canary"
    """Atlantic/Canary"""
    EUROPE_BELGRADE = "Europe/Belgrade"
    """Europe/Belgrade"""
    EUROPE_SARAJEVO = "Europe/Sarajevo"
    """Europe/Sarajevo"""
    EUROPE_BRUSSELS = "Europe/Brussels"
    """Europe/Brussels"""
    EUROPE_AMSTERDAM = "Europe/Amsterdam"
    """Europe/Amsterdam"""
    AFRICA_ALGIERS = "Africa/Algiers"
    """Africa/Algiers"""
    EUROPE_BUCHAREST = "Europe/Bucharest"
    """Europe/Bucharest"""
    AFRICA_CAIRO = "Africa/Cairo"
    """Africa/Cairo"""
    EUROPE_HELSINKI = "Europe/Helsinki"
    """Europe/Helsinki"""
    EUROPE_ATHENS = "Europe/Athens"
    """Europe/Athens"""
    ASIA_JERUSALEM = "Asia/Jerusalem"
    """Asia/Jerusalem"""
    AFRICA_HARARE = "Africa/Harare"
    """Africa/Harare"""
    EUROPE_MOSCOW = "Europe/Moscow"
    """Europe/Moscow"""
    ASIA_KUWAIT = "Asia/Kuwait"
    """Asia/Kuwait"""
    AFRICA_NAIROBI = "Africa/Nairobi"
    """Africa/Nairobi"""
    ASIA_BAGHDAD = "Asia/Baghdad"
    """Asia/Baghdad"""
    ASIA_TEHRAN = "Asia/Tehran"
    """Asia/Tehran"""
    ASIA_DUBAI = "Asia/Dubai"
    """Asia/Dubai"""
    ASIA_BAKU = "Asia/Baku"
    """Asia/Baku"""
    ASIA_KABUL = "Asia/Kabul"
    """Asia/Kabul"""
    ASIA_YEKATERINBURG = "Asia/Yekaterinburg"
    """Asia/Yekaterinburg"""
    ASIA_KARACHI = "Asia/Karachi"
    """Asia/Karachi"""
    ASIA_KOLKATA = "Asia/Kolkata"
    """Asia/Kolkata"""
    ASIA_KATHMANDU = "Asia/Kathmandu"
    """Asia/Kathmandu"""
    ASIA_DHAKA = "Asia/Dhaka"
    """Asia/Dhaka"""
    ASIA_COLOMBO = "Asia/Colombo"
    """Asia/Colombo"""
    ASIA_ALMATY = "Asia/Almaty"
    """Asia/Almaty"""
    ASIA_RANGOON = "Asia/Rangoon"
    """Asia/Rangoon"""
    ASIA_BANGKOK = "Asia/Bangkok"
    """Asia/Bangkok"""
    ASIA_KRASNOYARSK = "Asia/Krasnoyarsk"
    """Asia/Krasnoyarsk"""
    ASIA_SHANGHAI = "Asia/Shanghai"
    """Asia/Shanghai"""
    ASIA_KUALA_LUMPUR = "Asia/Kuala_Lumpur"
    """Asia/Kuala_Lumpur"""
    ASIA_TAIPEI = "Asia/Taipei"
    """Asia/Taipei"""
    AUSTRALIA_PERTH = "Australia/Perth"
    """Australia/Perth"""
    ASIA_IRKUTSK = "Asia/Irkutsk"
    """Asia/Irkutsk"""
    ASIA_SEOUL = "Asia/Seoul"
    """Asia/Seoul"""
    ASIA_TOKYO = "Asia/Tokyo"
    """Asia/Tokyo"""
    ASIA_YAKUTSK = "Asia/Yakutsk"
    """Asia/Yakutsk"""
    AUSTRALIA_DARWIN = "Australia/Darwin"
    """Australia/Darwin"""
    AUSTRALIA_ADELAIDE = "Australia/Adelaide"
    """Australia/Adelaide"""
    AUSTRALIA_SYDNEY = "Australia/Sydney"
    """Australia/Sydney"""
    AUSTRALIA_BRISBANE = "Australia/Brisbane"
    """Australia/Brisbane"""
    AUSTRALIA_HOBART = "Australia/Hobart"
    """Australia/Hobart"""
    ASIA_VLADIVOSTOK = "Asia/Vladivostok"
    """Asia/Vladivostok"""
    PACIFIC_GUAM = "Pacific/Guam"
    """Pacific/Guam"""
    ASIA_MAGADAN = "Asia/Magadan"
    """Asia/Magadan"""
    ASIA_KAMCHATKA = "Asia/Kamchatka"
    """Asia/Kamchatka"""
    PACIFIC_FIJI = "Pacific/Fiji"
    """Pacific/Fiji"""
    PACIFIC_AUCKLAND = "Pacific/Auckland"
    """Pacific/Auckland"""
    PACIFIC_TONGATAPU = "Pacific/Tongatapu"
    """Pacific/Tongatapu"""


class ConversationType(StrEnum):
    HUMAN = "human"
    """human"""
    GROUP = "group"
    """group"""
    BOT = "bot"
    """bot"""
    FILE = "file"
    """file"""


class TextGenRole(StrEnum):
    USER = "user"
    """user"""
    ASSISTANT = "assistant"
    """assistant"""


class TextGenModel(StrEnum):
    TOGETHER_MISTRAL_7B = "together_mistral_7b"
    """together_mistral_7b"""
    TOGETHER_MIXTRAL_8X7B = "together_mixtral_8x7b"
    """together_mixtral_8x7b"""
    TOGETHER_MIXTRAL_8X22B = "together_mixtral_8x22b"
    """together_mixtral_8x22b"""
    TOGETHER_MISTRAL_24B = "together_mistral_24b"
    """together_mistral_24b"""
    TOGETHER_META_LLAMA_3_8B = "together_meta_llama_3_8b"
    """together_meta_llama_3_8b"""
    TOGETHER_META_LLAMA_3_70B = "together_meta_llama_3_70b"
    """together_meta_llama_3_70b"""
    TOGETHER_META_LLAMA_3_405B = "together_meta_llama_3_405b"
    """together_meta_llama_3_405b"""
    TOGETHER_META_LLAMA_VISION_3_11B = "together_meta_llama_vision_3_11b"
    """together_meta_llama_vision_3_11b"""
    TOGETHER_META_LLAMA_VISION_3_90B = "together_meta_llama_vision_3_90b"
    """together_meta_llama_vision_3_90b"""
    TOGETHER_META_LLAMA4_400B = "together_meta_llama4_400b"
    """together_meta_llama4_400b"""
    TOGETHER_QWEN2_VISION_72B = "together_qwen2_vision_72b"
    """together_qwen2_vision_72b"""
    TOGETHER_QWEN2_72B = "together_qwen2_72b"
    """together_qwen2_72b"""
    TOGETHER_QWEN3_235B = "together_qwen3_235b"
    """together_qwen3_235b"""
    TOGETHER_DEEPSEEK_R1 = "together_deepseek_r1"
    """together_deepseek_r1"""
    TOGETHER_DEEPSEEK_V3 = "together_deepseek_v3"
    """together_deepseek_v3"""
    TOGETHER_KIMI_K2 = "together_kimi_k2"
    """together_kimi_k2"""
    ANTHROPHIC_CLAUDE_3_OPUS = "anthrophic_claude_3_opus"
    """anthrophic_claude_3_opus"""
    ANTHROPHIC_CLAUDE_3_SONNET = "anthrophic_claude_3_sonnet"
    """anthrophic_claude_3_sonnet"""
    ANTHROPHIC_CLAUDE_3_HAIKU = "anthrophic_claude_3_haiku"
    """anthrophic_claude_3_haiku"""
    PERPLEXITY_LLAMA_3_SONAR_SMALL_128K_ONLINE = (
        "perplexity_llama_3_sonar_small_128k_online"
    )
    """perplexity_llama_3_sonar_small_128k_online"""
    PERPLEXITY_LLAMA_3_SONAR_LARGE_128K_ONLINE = (
        "perplexity_llama_3_sonar_large_128k_online"
    )
    """perplexity_llama_3_sonar_large_128k_online"""
    PERPLEXITY_LLAMA_3_SONAR_HUGE_128K_ONLINE = (
        "perplexity_llama_3_sonar_huge_128k_online"
    )
    """perplexity_llama_3_sonar_huge_128k_online"""
    OPENAI_GPT_4 = "openai_gpt_4"
    """openai_gpt_4"""
    OPENAI_GPT_4_32K = "openai_gpt_4_32k"
    """openai_gpt_4_32k"""
    OPENAI_GPT_4_TURBO = "openai_gpt_4_turbo"
    """openai_gpt_4_turbo"""
    OPENAI_GPT_4O = "openai_gpt_4o"
    """openai_gpt_4o"""
    OPENAI_GPT_3_TURBO = "openai_gpt_3_turbo"
    """openai_gpt_3_turbo"""
    OPENAI_GPT_3_TURBO_16K = "openai_gpt_3_turbo_16k"
    """openai_gpt_3_turbo_16k"""
    OPENAI_O1 = "openai_o1"
    """openai_o1"""
    OPENAI_O1_MINI = "openai_o1_mini"
    """openai_o1_mini"""
