# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add instanced job scheduling index

Revision ID: 8fd7118e215e
Revises: 0596ea8f5c61
Create Date: 2025-07-29 15:31:04.808943

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "8fd7118e215e"
down_revision = "0596ea8f5c61"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(
            "ix_jobs_instance_priority_timestamp_scheduling",
            ["priority", "queued_timestamp", "instance_name", "schedule_after"],
            unique=False,
            postgresql_where=sa.text("stage = 2 AND assigned != true"),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(
            "ix_jobs_instance_priority_timestamp_scheduling",
            postgresql_where=sa.text("stage = 2 AND assigned != true"),
        )

    # ### end Alembic commands ###
