# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add immutable jobs.max_capacity column

Revision ID: 8f7f43e4a833
Revises: 85096c931383
Create Date: 2025-12-09 14:03:01.907296

"""

import sqlalchemy as sa
from alembic import op


# revision identifiers, used by Alembic.
revision = "8f7f43e4a833"
down_revision = "85096c931383"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("bots", schema=None) as batch_op:
        batch_op.add_column(sa.Column("max_capacity", sa.Integer(), server_default=sa.text("1"), nullable=False))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("bots", schema=None) as batch_op:
        batch_op.drop_column("max_capacity")

    # ### end Alembic commands ###
