# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Drop ix_jobs_stage_property_label and ix_jobs_priority_timestamp_scheduling

Revision ID: 85096c931383
Revises: 55acd9b4ec38
Create Date: 2025-11-06 13:36:29.681641

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "85096c931383"
down_revision = "55acd9b4ec38"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_jobs_priority_timestamp_scheduling"),
            postgresql_where="((stage = 2) AND (assigned <> true))",
        )
        batch_op.drop_index(batch_op.f("ix_jobs_stage_property_label"))

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_jobs_stage_property_label"), ["stage", "property_label"], unique=False)
        batch_op.create_index(
            batch_op.f("ix_jobs_priority_timestamp_scheduling"),
            ["priority", "queued_timestamp", "schedule_after"],
            unique=False,
            postgresql_where="((stage = 2) AND (assigned <> true))",
        )

    # ### end Alembic commands ###
