# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Drop ix_jobs_worker_name_stage

Revision ID: 5b90ed0e9d0b
Revises: 12992085e81a
Create Date: 2025-10-30 12:29:12.120770

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "5b90ed0e9d0b"
down_revision = "12992085e81a"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_jobs_worker_name_stage"), postgresql_where="(worker_name IS NOT NULL)")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_jobs_worker_name_stage"),
            ["worker_name", "stage"],
            unique=False,
            postgresql_where="(worker_name IS NOT NULL)",
        )

    # ### end Alembic commands ###
