# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Drop unused indexes and create scheduling index

Revision ID: 5745d1f0e537
Revises: 9e7a59ee4370
Create Date: 2025-07-03 16:46:38.317738

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "5745d1f0e537"
down_revision = "9e7a59ee4370"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("bots", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_bots_name"))

    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_jobs_priority"))
        batch_op.drop_index(
            batch_op.f("ix_worker_start_timestamp"), postgresql_where="(worker_start_timestamp IS NOT NULL)"
        )
        batch_op.create_index(
            "ix_jobs_priority_timestamp_scheduling",
            ["priority", "queued_timestamp", "schedule_after"],
            unique=False,
            postgresql_where=sa.text("stage = 2 AND assigned != true"),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(
            "ix_jobs_priority_timestamp_scheduling", postgresql_where=sa.text("stage = 2 AND assigned != true")
        )
        batch_op.create_index(
            batch_op.f("ix_worker_start_timestamp"),
            ["worker_start_timestamp"],
            unique=False,
            postgresql_where="(worker_start_timestamp IS NOT NULL)",
        )
        batch_op.create_index(batch_op.f("ix_jobs_priority"), ["priority"], unique=False)

    with op.batch_alter_table("bots", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_bots_name"), ["name"], unique=False)

    # ### end Alembic commands ###
