# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add ix_jobs_property_label_stage

Revision ID: 55acd9b4ec38
Revises: 5b90ed0e9d0b
Create Date: 2025-11-06 13:34:04.748172

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "55acd9b4ec38"
down_revision = "5b90ed0e9d0b"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(
            "ix_jobs_property_label_stage",
            ["property_label", "stage"],
            unique=False,
            postgresql_where=sa.text("stage < 4"),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index("ix_jobs_property_label_stage", postgresql_where=sa.text("stage < 4"))

    # ### end Alembic commands ###
