# Copyright (C) 2025 Bloomberg LP
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#  <http://www.apache.org/licenses/LICENSE-2.0>
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Add a job index on worker_name and incomplete stages

Revision ID: 12992085e81a
Revises: 90bd87d052a0
Create Date: 2025-10-30 12:25:46.585239

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "12992085e81a"
down_revision = "90bd87d052a0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.create_index(
            "ix_jobs_worker_name_incomplete",
            ["worker_name", "stage"],
            unique=False,
            postgresql_where=sa.text("worker_name IS NOT NULL AND stage < 4"),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("jobs", schema=None) as batch_op:
        batch_op.drop_index(
            "ix_jobs_worker_name_incomplete", postgresql_where=sa.text("worker_name IS NOT NULL AND stage < 4")
        )

    # ### end Alembic commands ###
