"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import buildgrid._protos.google.devtools.build.v1.build_events_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class PublishLifecycleEventRequest(google.protobuf.message.Message):
    """Publishes 'lifecycle events' that update the high-level state of a build:
    - BuildEnqueued: When a build is scheduled.
    - InvocationAttemptStarted: When work for a build starts; there can be
        multiple invocations for a build (e.g. retries).
    - InvocationAttemptCompleted: When work for a build finishes.
    - BuildFinished: When a build is finished.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ServiceLevel:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceLevelEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PublishLifecycleEventRequest._ServiceLevel.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NONINTERACTIVE: PublishLifecycleEventRequest._ServiceLevel.ValueType  # 0
        """Non-interactive builds can tolerate longer event latencies. This is the
        default ServiceLevel if callers do not specify one.
        """
        INTERACTIVE: PublishLifecycleEventRequest._ServiceLevel.ValueType  # 1
        """The events of an interactive build should be delivered with low latency."""

    class ServiceLevel(_ServiceLevel, metaclass=_ServiceLevelEnumTypeWrapper):
        """The service level of the build request. Backends only uses this value when
        the BuildEnqueued event is published to determine what level of service
        this build should receive.
        """

    NONINTERACTIVE: PublishLifecycleEventRequest.ServiceLevel.ValueType  # 0
    """Non-interactive builds can tolerate longer event latencies. This is the
    default ServiceLevel if callers do not specify one.
    """
    INTERACTIVE: PublishLifecycleEventRequest.ServiceLevel.ValueType  # 1
    """The events of an interactive build should be delivered with low latency."""

    SERVICE_LEVEL_FIELD_NUMBER: builtins.int
    BUILD_EVENT_FIELD_NUMBER: builtins.int
    STREAM_TIMEOUT_FIELD_NUMBER: builtins.int
    NOTIFICATION_KEYWORDS_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    service_level: global___PublishLifecycleEventRequest.ServiceLevel.ValueType
    """The interactivity of this build."""
    @property
    def build_event(self) -> global___OrderedBuildEvent:
        """Required. The lifecycle build event. If this is a build tool event, the RPC
        will fail with INVALID_REQUEST.
        """
    @property
    def stream_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """If the next event for this build or invocation (depending on the event
        type) hasn't been published after this duration from when {build_event}
        is written to BES, consider this stream expired. If this field is not set,
        BES backend will use its own default value.
        """
    @property
    def notification_keywords(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Additional information about a build request. These are define by the event
        publishers, and the Build Event Service does not validate or interpret
        them. They are used while notifying internal systems of new builds and
        invocations if the OrderedBuildEvent.event type is
        BuildEnqueued/InvocationAttemptStarted.
        """
    project_id: builtins.str
    """Required. The project this build is associated with.
    This should match the project used for the initial call to
    PublishLifecycleEvent (containing a BuildEnqueued message).
    """
    def __init__(
        self,
        *,
        service_level: global___PublishLifecycleEventRequest.ServiceLevel.ValueType = ...,
        build_event: global___OrderedBuildEvent | None = ...,
        stream_timeout: google.protobuf.duration_pb2.Duration | None = ...,
        notification_keywords: collections.abc.Iterable[builtins.str] | None = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_event", b"build_event", "stream_timeout", b"stream_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_event", b"build_event", "notification_keywords", b"notification_keywords", "project_id", b"project_id", "service_level", b"service_level", "stream_timeout", b"stream_timeout"]) -> None: ...

global___PublishLifecycleEventRequest = PublishLifecycleEventRequest

@typing_extensions.final
class PublishBuildToolEventStreamResponse(google.protobuf.message.Message):
    """States which event has been committed. Any failure to commit will cause
    RPC errors, hence not recorded by this proto.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    SEQUENCE_NUMBER_FIELD_NUMBER: builtins.int
    @property
    def stream_id(self) -> buildgrid._protos.google.devtools.build.v1.build_events_pb2.StreamId:
        """The stream that contains this event."""
    sequence_number: builtins.int
    """The sequence number of this event that has been committed."""
    def __init__(
        self,
        *,
        stream_id: buildgrid._protos.google.devtools.build.v1.build_events_pb2.StreamId | None = ...,
        sequence_number: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["stream_id", b"stream_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["sequence_number", b"sequence_number", "stream_id", b"stream_id"]) -> None: ...

global___PublishBuildToolEventStreamResponse = PublishBuildToolEventStreamResponse

@typing_extensions.final
class OrderedBuildEvent(google.protobuf.message.Message):
    """Build event with contextual information about the stream it belongs to and
    its position in that stream.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STREAM_ID_FIELD_NUMBER: builtins.int
    SEQUENCE_NUMBER_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    @property
    def stream_id(self) -> buildgrid._protos.google.devtools.build.v1.build_events_pb2.StreamId:
        """Which build event stream this event belongs to."""
    sequence_number: builtins.int
    """The position of this event in the stream. The sequence numbers for a build
    event stream should be a sequence of consecutive natural numbers starting
    from one. (1, 2, 3, ...)
    """
    @property
    def event(self) -> buildgrid._protos.google.devtools.build.v1.build_events_pb2.BuildEvent:
        """The actual event."""
    def __init__(
        self,
        *,
        stream_id: buildgrid._protos.google.devtools.build.v1.build_events_pb2.StreamId | None = ...,
        sequence_number: builtins.int = ...,
        event: buildgrid._protos.google.devtools.build.v1.build_events_pb2.BuildEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["event", b"event", "stream_id", b"stream_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event", b"event", "sequence_number", b"sequence_number", "stream_id", b"stream_id"]) -> None: ...

global___OrderedBuildEvent = OrderedBuildEvent

@typing_extensions.final
class PublishBuildToolEventStreamRequest(google.protobuf.message.Message):
    """Streaming request message for PublishBuildToolEventStream."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORDERED_BUILD_EVENT_FIELD_NUMBER: builtins.int
    NOTIFICATION_KEYWORDS_FIELD_NUMBER: builtins.int
    PROJECT_ID_FIELD_NUMBER: builtins.int
    @property
    def ordered_build_event(self) -> global___OrderedBuildEvent:
        """Required. The build event with position info.
        New publishing clients should use this field rather than the 3 above.
        """
    @property
    def notification_keywords(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The keywords to be attached to the notification which notifies the start
        of a new build event stream. BES only reads this field when sequence_number
        or ordered_build_event.sequence_number is 1 in this message. If this field
        is empty, BES will not publish notification messages for this stream.
        """
    project_id: builtins.str
    """Required. The project this build is associated with.
    This should match the project used for the initial call to
    PublishLifecycleEvent (containing a BuildEnqueued message).
    """
    def __init__(
        self,
        *,
        ordered_build_event: global___OrderedBuildEvent | None = ...,
        notification_keywords: collections.abc.Iterable[builtins.str] | None = ...,
        project_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["ordered_build_event", b"ordered_build_event"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["notification_keywords", b"notification_keywords", "ordered_build_event", b"ordered_build_event", "project_id", b"project_id"]) -> None: ...

global___PublishBuildToolEventStreamRequest = PublishBuildToolEventStreamRequest
