"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class BuildStatus(google.protobuf.message.Message):
    """Status used for both invocation attempt and overall build completion."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Result:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ResultEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BuildStatus._Result.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_STATUS: BuildStatus._Result.ValueType  # 0
        """Unspecified or unknown."""
        COMMAND_SUCCEEDED: BuildStatus._Result.ValueType  # 1
        """Build was successful and tests (if requested) all pass."""
        COMMAND_FAILED: BuildStatus._Result.ValueType  # 2
        """Build error and/or test failure."""
        USER_ERROR: BuildStatus._Result.ValueType  # 3
        """Unable to obtain a result due to input provided by the user."""
        SYSTEM_ERROR: BuildStatus._Result.ValueType  # 4
        """Unable to obtain a result due to a failure within the build system."""
        RESOURCE_EXHAUSTED: BuildStatus._Result.ValueType  # 5
        """Build required too many resources, such as build tool RAM."""
        INVOCATION_DEADLINE_EXCEEDED: BuildStatus._Result.ValueType  # 6
        """An invocation attempt time exceeded its deadline."""
        REQUEST_DEADLINE_EXCEEDED: BuildStatus._Result.ValueType  # 8
        """Build request time exceeded the request_deadline"""
        CANCELLED: BuildStatus._Result.ValueType  # 7
        """The build was cancelled by a call to CancelBuild."""

    class Result(_Result, metaclass=_ResultEnumTypeWrapper):
        """The end result of the Build."""

    UNKNOWN_STATUS: BuildStatus.Result.ValueType  # 0
    """Unspecified or unknown."""
    COMMAND_SUCCEEDED: BuildStatus.Result.ValueType  # 1
    """Build was successful and tests (if requested) all pass."""
    COMMAND_FAILED: BuildStatus.Result.ValueType  # 2
    """Build error and/or test failure."""
    USER_ERROR: BuildStatus.Result.ValueType  # 3
    """Unable to obtain a result due to input provided by the user."""
    SYSTEM_ERROR: BuildStatus.Result.ValueType  # 4
    """Unable to obtain a result due to a failure within the build system."""
    RESOURCE_EXHAUSTED: BuildStatus.Result.ValueType  # 5
    """Build required too many resources, such as build tool RAM."""
    INVOCATION_DEADLINE_EXCEEDED: BuildStatus.Result.ValueType  # 6
    """An invocation attempt time exceeded its deadline."""
    REQUEST_DEADLINE_EXCEEDED: BuildStatus.Result.ValueType  # 8
    """Build request time exceeded the request_deadline"""
    CANCELLED: BuildStatus.Result.ValueType  # 7
    """The build was cancelled by a call to CancelBuild."""

    RESULT_FIELD_NUMBER: builtins.int
    FINAL_INVOCATION_ID_FIELD_NUMBER: builtins.int
    BUILD_TOOL_EXIT_CODE_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    result: global___BuildStatus.Result.ValueType
    """The end result."""
    final_invocation_id: builtins.str
    """Final invocation ID of the build, if there was one.
    This field is only set on a status in BuildFinished event.
    """
    @property
    def build_tool_exit_code(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Build tool exit code. Integer value returned by the executed build tool.
        Might not be available in some cases, e.g., a build timeout.
        """
    @property
    def details(self) -> google.protobuf.any_pb2.Any:
        """Fine-grained diagnostic information to complement the status."""
    def __init__(
        self,
        *,
        result: global___BuildStatus.Result.ValueType = ...,
        final_invocation_id: builtins.str = ...,
        build_tool_exit_code: google.protobuf.wrappers_pb2.Int32Value | None = ...,
        details: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["build_tool_exit_code", b"build_tool_exit_code", "details", b"details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["build_tool_exit_code", b"build_tool_exit_code", "details", b"details", "final_invocation_id", b"final_invocation_id", "result", b"result"]) -> None: ...

global___BuildStatus = BuildStatus
