"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright (C) 2025 Bloomberg LP

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 <http://www.apache.org/licenses/LICENSE-2.0>

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import abc
import buildgrid._protos.build.buildgrid.quota_pb2
import grpc

class QuotaStub:
    """BuildGrid's Quota service is used to manage quota limits for
    different REAPI instances and bot cohorts.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    GetInstanceQuota: grpc.UnaryUnaryMultiCallable[
        buildgrid._protos.build.buildgrid.quota_pb2.GetInstanceQuotaRequest,
        buildgrid._protos.build.buildgrid.quota_pb2.GetInstanceQuotaResponse,
    ]
    """Get the quota configuration for a specific instance and bot cohort

    Errors:
     * `NOT_FOUND`: When the quota index by (instance_name, bot_cohort) doesn't exist
    """
    PutInstanceQuota: grpc.UnaryUnaryMultiCallable[
        buildgrid._protos.build.buildgrid.quota_pb2.PutInstanceQuotaRequest,
        buildgrid._protos.build.buildgrid.quota_pb2.PutInstanceQuotaResponse,
    ]
    """Set or update the quota configuration for a specific instance and bot cohort"""
    DeleteInstanceQuota: grpc.UnaryUnaryMultiCallable[
        buildgrid._protos.build.buildgrid.quota_pb2.DeleteInstanceQuotaRequest,
        buildgrid._protos.build.buildgrid.quota_pb2.DeleteInstanceQuotaResponse,
    ]
    """Delete the quota configuration for a specific instance and bot cohort
    Errors:
     * `NOT_FOUND`: When the quota index by (instance_name, bot_cohort) doesn't exist
    """

class QuotaServicer(metaclass=abc.ABCMeta):
    """BuildGrid's Quota service is used to manage quota limits for
    different REAPI instances and bot cohorts.
    """

    @abc.abstractmethod
    def GetInstanceQuota(
        self,
        request: buildgrid._protos.build.buildgrid.quota_pb2.GetInstanceQuotaRequest,
        context: grpc.ServicerContext,
    ) -> buildgrid._protos.build.buildgrid.quota_pb2.GetInstanceQuotaResponse:
        """Get the quota configuration for a specific instance and bot cohort

        Errors:
         * `NOT_FOUND`: When the quota index by (instance_name, bot_cohort) doesn't exist
        """
    @abc.abstractmethod
    def PutInstanceQuota(
        self,
        request: buildgrid._protos.build.buildgrid.quota_pb2.PutInstanceQuotaRequest,
        context: grpc.ServicerContext,
    ) -> buildgrid._protos.build.buildgrid.quota_pb2.PutInstanceQuotaResponse:
        """Set or update the quota configuration for a specific instance and bot cohort"""
    @abc.abstractmethod
    def DeleteInstanceQuota(
        self,
        request: buildgrid._protos.build.buildgrid.quota_pb2.DeleteInstanceQuotaRequest,
        context: grpc.ServicerContext,
    ) -> buildgrid._protos.build.buildgrid.quota_pb2.DeleteInstanceQuotaResponse:
        """Delete the quota configuration for a specific instance and bot cohort
        Errors:
         * `NOT_FOUND`: When the quota index by (instance_name, bot_cohort) doesn't exist
        """

def add_QuotaServicer_to_server(servicer: QuotaServicer, server: grpc.Server) -> None: ...
