"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright (C) 2025 Bloomberg LP

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 <http://www.apache.org/licenses/LICENSE-2.0>

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class InstanceQuota(google.protobuf.message.Message):
    """Quota configuration of a bot cohort for a specific instance."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    BOT_COHORT_FIELD_NUMBER: builtins.int
    MIN_QUOTA_FIELD_NUMBER: builtins.int
    MAX_QUOTA_FIELD_NUMBER: builtins.int
    CURRENT_USAGE_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the REAPI instance."""
    bot_cohort: builtins.str
    """The name of the bot cohort.
    A cohort is a group of bots with similar characteristics, so usage of
    them are tracked together.
    """
    min_quota: builtins.int
    """Minimum quota limit for the instance.
    Executions in-flight below this limit are guaranteed to be scheduled.
    """
    max_quota: builtins.int
    """Maximum quota limit for the instance.
    Executions in-flight above this limit will not be scheduled.
    """
    current_usage: builtins.int
    """Current usage of the quota."""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        bot_cohort: builtins.str = ...,
        min_quota: builtins.int = ...,
        max_quota: builtins.int = ...,
        current_usage: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_cohort", b"bot_cohort", "current_usage", b"current_usage", "instance_name", b"instance_name", "max_quota", b"max_quota", "min_quota", b"min_quota"]) -> None: ...

global___InstanceQuota = InstanceQuota

@typing_extensions.final
class GetInstanceQuotaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    BOT_COHORT_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the REAPI instance"""
    bot_cohort: builtins.str
    """The name of the bot cohort"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        bot_cohort: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_cohort", b"bot_cohort", "instance_name", b"instance_name"]) -> None: ...

global___GetInstanceQuotaRequest = GetInstanceQuotaRequest

@typing_extensions.final
class GetInstanceQuotaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_QUOTA_FIELD_NUMBER: builtins.int
    @property
    def instance_quota(self) -> global___InstanceQuota:
        """The quota configuration for the specified instance and bot cohort"""
    def __init__(
        self,
        *,
        instance_quota: global___InstanceQuota | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["instance_quota", b"instance_quota"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_quota", b"instance_quota"]) -> None: ...

global___GetInstanceQuotaResponse = GetInstanceQuotaResponse

@typing_extensions.final
class PutInstanceQuotaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    BOT_COHORT_FIELD_NUMBER: builtins.int
    MIN_QUOTA_FIELD_NUMBER: builtins.int
    MAX_QUOTA_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the REAPI instance"""
    bot_cohort: builtins.str
    """The name of the bot cohort"""
    min_quota: builtins.int
    """Minimum quota limit for the instance.
    Executions in-flight below this limit are guaranteed to be scheduled.
    """
    max_quota: builtins.int
    """Maximum quota limit for the instance.
    Executions in-flight above this limit will not be scheduled.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        bot_cohort: builtins.str = ...,
        min_quota: builtins.int = ...,
        max_quota: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_cohort", b"bot_cohort", "instance_name", b"instance_name", "max_quota", b"max_quota", "min_quota", b"min_quota"]) -> None: ...

global___PutInstanceQuotaRequest = PutInstanceQuotaRequest

@typing_extensions.final
class PutInstanceQuotaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PutInstanceQuotaResponse = PutInstanceQuotaResponse

@typing_extensions.final
class DeleteInstanceQuotaRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    BOT_COHORT_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the REAPI instance"""
    bot_cohort: builtins.str
    """The name of the bot cohort"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        bot_cohort: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bot_cohort", b"bot_cohort", "instance_name", b"instance_name"]) -> None: ...

global___DeleteInstanceQuotaRequest = DeleteInstanceQuotaRequest

@typing_extensions.final
class DeleteInstanceQuotaResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteInstanceQuotaResponse = DeleteInstanceQuotaResponse
