"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright (C) 2021 Bloomberg LP

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 <http://www.apache.org/licenses/LICENSE-2.0>

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2
import builtins
import collections.abc
import buildgrid._protos.google.longrunning.operations_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Job(google.protobuf.message.Message):
    """Describes an individual execution of a specific Action. Serialized
    and published on the Execution exchange.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """The unique ID of this specific execution of the Action. This MUST be
    unique within the grid at any given time, since it identifies a
    deliberately separate execution of an Action.
    """
    @property
    def action(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Action:
        """The Action to execute for this Job. The same Action can be used in
        multiple Jobs, for example an uncacheable Action being run multiple
        times simultaneously.
        """
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        action: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Action | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "job_id", b"job_id"]) -> None: ...

global___Job = Job

@typing_extensions.final
class CreateOperation(google.protobuf.message.Message):
    """Message to indicate that a new Operation is being created for a Job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    OPERATION_NAME_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    CACHEABLE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    REQUEST_METADATA_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """Job ID that the Operation refers to. If this is an ID which has been
    used before then Operations services MUST treat this message as a
    request to bind the Operation name to the existing Job.
    """
    operation_name: builtins.str
    """The name of the Operation being created. This MUST be unique within
    the grid at any given time, since it identifies a specific client with
    an interest in the execution of a Job.
    """
    @property
    def action_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The Digest of the Action used in the Job. Services MUST use this
        digest when constructing Operation messages with the given name for
        response to clients.
        """
    cacheable: builtins.bool
    """Whether or not the result of the Action specified by the action_digest
    can be stored in the ActionCache. Execution services SHOULD use this
    to efficiently maintain a cache of Jobs which can have future requests
    deduplicated into them.
    """
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this message was generated. Operations services
        SHOULD use this information to ensure in-order updating of persistent
        Operation state.
        """
    @property
    def request_metadata(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.RequestMetadata:
        """Optional metadata that a client could have attached to the
        execution request. It serves to describe an external context of
        that request.
        """
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        operation_name: builtins.str = ...,
        action_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
        cacheable: builtins.bool = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        request_metadata: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.RequestMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "request_metadata", b"request_metadata", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "cacheable", b"cacheable", "job_id", b"job_id", "operation_name", b"operation_name", "request_metadata", b"request_metadata", "timestamp", b"timestamp"]) -> None: ...

global___CreateOperation = CreateOperation

@typing_extensions.final
class UpdateOperations(google.protobuf.message.Message):
    """Message containing an update to Operations related to a specific Job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    OPERATION_STATE_FIELD_NUMBER: builtins.int
    CACHEABLE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """The ID of the Job whose Operations should be updated to match the new
    state.
    """
    @property
    def operation_state(self) -> buildgrid._protos.google.longrunning.operations_pb2.Operation:
        """The new state of Operations for the Job. The `operation_state.name` is
        expected to be empty and will be ignored if set.
        """
    cacheable: builtins.bool
    """Whether or not the result of the Action specified by the action_digest
    in the operation_state can be stored in the ActionCache. Execution
    services SHOULD use this to efficiently maintain a cache of Jobs which
    can have future requests deduplicated into them, and ActionCache
    services SHOULD use this to determine whether or not the result stored
    in operation_state can be added to the cache in situations where the
    Job has been completed.
    """
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this message was generated. Operation services
        SHOULD use this information to ensure in-order updating of persistent
        Operation state.
        """
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        operation_state: buildgrid._protos.google.longrunning.operations_pb2.Operation | None = ...,
        cacheable: builtins.bool = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["operation_state", b"operation_state", "timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cacheable", b"cacheable", "job_id", b"job_id", "operation_state", b"operation_state", "timestamp", b"timestamp"]) -> None: ...

global___UpdateOperations = UpdateOperations

@typing_extensions.final
class RetryableJob(google.protobuf.message.Message):
    """A message containing the information required to retry a Job which is
    currently being executed by a worker.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_ID_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    ROUTING_KEY_FIELD_NUMBER: builtins.int
    job_id: builtins.str
    """The unique ID of the Job that the worker is executing."""
    @property
    def action(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Action:
        """The Action to execute for this Job."""
    routing_key: builtins.str
    """The routing key used when this Job was originally published on the
    Execution exchange. This can be used to requeue the Job in the
    correct platform queue.
    """
    def __init__(
        self,
        *,
        job_id: builtins.str = ...,
        action: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Action | None = ...,
        routing_key: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action", b"action"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action", b"action", "job_id", b"job_id", "routing_key", b"routing_key"]) -> None: ...

global___RetryableJob = RetryableJob

@typing_extensions.final
class BotStatus(google.protobuf.message.Message):
    """A message describing the last-known state of a bot."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BOT_NAME_FIELD_NUMBER: builtins.int
    ASSIGNMENTS_FIELD_NUMBER: builtins.int
    CONNECTION_TIMESTAMP_FIELD_NUMBER: builtins.int
    bot_name: builtins.str
    """The server-assigned name for this bot."""
    @property
    def assignments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RetryableJob]:
        """A list of RetryableJobs that this bot is currently working on, and would
        need to be retried or cancelled in the case of this bot failing to report
        back to the grid.
        """
    @property
    def connection_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp of the last time the bot was seen connecting to the grid.
        The BotMonitor service SHOULD use this timestamp to determine that a
        bot has failed to meet its next connection deadline to trigger retrying
        the related Jobs.
        """
    def __init__(
        self,
        *,
        bot_name: builtins.str = ...,
        assignments: collections.abc.Iterable[global___RetryableJob] | None = ...,
        connection_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["connection_timestamp", b"connection_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["assignments", b"assignments", "bot_name", b"bot_name", "connection_timestamp", b"connection_timestamp"]) -> None: ...

global___BotStatus = BotStatus
