"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright (C) 2024 Bloomberg LP

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

 <http://www.apache.org/licenses/LICENSE-2.0>

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2
import builtins
import collections.abc
import buildgrid._protos.google.devtools.remoteworkers.v1test2.bots_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _JobEventType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _JobEventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_JobEventType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNSPECIFIED: _JobEventType.ValueType  # 0
    """Unspecified, should never be used."""
    CREATION: _JobEventType.ValueType  # 1
    """Creation of a new job"""
    NEW_OPERATION: _JobEventType.ValueType  # 2
    """Creation of a new operation for a job"""
    ASSIGNMENT: _JobEventType.ValueType  # 3
    """Assignment of a job to a bot"""
    COMPLETION: _JobEventType.ValueType  # 4
    """Completion of execution of a job"""
    OPERATION_CANCELLATION: _JobEventType.ValueType  # 5
    """Cancellation of an operation related to a job"""
    CANCELLATION: _JobEventType.ValueType  # 6
    """Cancellation of the overall job (when all operations are cancelled)"""
    RETRY: _JobEventType.ValueType  # 8
    """Requeuing of a job after an execution failure"""
    PROGRESS_UPDATE: _JobEventType.ValueType  # 9
    """Progress timestamp for a job, from metadata sent by the bot"""
    EVICTED: _JobEventType.ValueType  # 10
    """Being evicted to make room for another job"""

class JobEventType(_JobEventType, metaclass=_JobEventTypeEnumTypeWrapper): ...

UNSPECIFIED: JobEventType.ValueType  # 0
"""Unspecified, should never be used."""
CREATION: JobEventType.ValueType  # 1
"""Creation of a new job"""
NEW_OPERATION: JobEventType.ValueType  # 2
"""Creation of a new operation for a job"""
ASSIGNMENT: JobEventType.ValueType  # 3
"""Assignment of a job to a bot"""
COMPLETION: JobEventType.ValueType  # 4
"""Completion of execution of a job"""
OPERATION_CANCELLATION: JobEventType.ValueType  # 5
"""Cancellation of an operation related to a job"""
CANCELLATION: JobEventType.ValueType  # 6
"""Cancellation of the overall job (when all operations are cancelled)"""
RETRY: JobEventType.ValueType  # 8
"""Requeuing of a job after an execution failure"""
PROGRESS_UPDATE: JobEventType.ValueType  # 9
"""Progress timestamp for a job, from metadata sent by the bot"""
EVICTED: JobEventType.ValueType  # 10
"""Being evicted to make room for another job"""
global___JobEventType = JobEventType

@typing_extensions.final
class ListWorkersRequest(google.protobuf.message.Message):
    """Request specifying which worker(s) to list"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    WORKER_NAME_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the BuildGrid instance to query workers in"""
    page_size: builtins.int
    """The maximum number of workers to return in a single response"""
    page: builtins.int
    """The page number to return when paginating"""
    worker_name: builtins.str
    """A string which is matched against worker names and IDs"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        page_size: builtins.int = ...,
        page: builtins.int = ...,
        worker_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name", "page", b"page", "page_size", b"page_size", "worker_name", b"worker_name"]) -> None: ...

global___ListWorkersRequest = ListWorkersRequest

@typing_extensions.final
class WorkerOperation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATION_NAME_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    operation_name: builtins.str
    """The name of an operation being addressed by a worker"""
    @property
    def action_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The Action Digest for this operation"""
    def __init__(
        self,
        *,
        operation_name: builtins.str = ...,
        action_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "operation_name", b"operation_name"]) -> None: ...

global___WorkerOperation = WorkerOperation

@typing_extensions.final
class RegisteredWorker(google.protobuf.message.Message):
    """A Worker message defines the internal tracked state for a bot connected
    via the Remote Workers API.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SESSION_NAME_FIELD_NUMBER: builtins.int
    WORKER_NAME_FIELD_NUMBER: builtins.int
    LAST_UPDATED_FIELD_NUMBER: builtins.int
    BOT_STATUS_FIELD_NUMBER: builtins.int
    EXPIRY_TIME_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    session_name: builtins.str
    """The name of the worker's BotSession, generated by BuildGrid when the
    worker's session starts
    """
    worker_name: builtins.str
    """The ID of the worker's BotSession, specified by the worker client. This
    should be the is the same worker name that ends up in the
    ExecuteOperationMetadata
    """
    @property
    def last_updated(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which the worker last connected to BuildGrid"""
    bot_status: buildgrid._protos.google.devtools.remoteworkers.v1test2.bots_pb2.BotStatus.ValueType
    """The status of the worker when it last communicated"""
    @property
    def expiry_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this worker will expire and any assigned work be retried"""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___WorkerOperation]:
        """The list of operations assigned to this worker"""
    @property
    def action_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The Action Digest for the assigned job, if any"""
    def __init__(
        self,
        *,
        session_name: builtins.str = ...,
        worker_name: builtins.str = ...,
        last_updated: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        bot_status: buildgrid._protos.google.devtools.remoteworkers.v1test2.bots_pb2.BotStatus.ValueType = ...,
        expiry_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        operations: collections.abc.Iterable[global___WorkerOperation] | None = ...,
        action_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "expiry_time", b"expiry_time", "last_updated", b"last_updated"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "bot_status", b"bot_status", "expiry_time", b"expiry_time", "last_updated", b"last_updated", "operations", b"operations", "session_name", b"session_name", "worker_name", b"worker_name"]) -> None: ...

global___RegisteredWorker = RegisteredWorker

@typing_extensions.final
class ListWorkersResponse(google.protobuf.message.Message):
    """Response to a ListWorkers request, containing the matching list of Workers"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    TOTAL_FIELD_NUMBER: builtins.int
    WORKERS_FIELD_NUMBER: builtins.int
    page: builtins.int
    """The page number this response contains when using the specified page_size"""
    page_size: builtins.int
    """The requested page size"""
    total: builtins.int
    """The total number of workers which matched the requested `worker_name`"""
    @property
    def workers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RegisteredWorker]:
        """A list of Workers which match the requested `worker_name`"""
    def __init__(
        self,
        *,
        page: builtins.int = ...,
        page_size: builtins.int = ...,
        total: builtins.int = ...,
        workers: collections.abc.Iterable[global___RegisteredWorker] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["page", b"page", "page_size", b"page_size", "total", b"total", "workers", b"workers"]) -> None: ...

global___ListWorkersResponse = ListWorkersResponse

@typing_extensions.final
class GetOperationFiltersRequest(google.protobuf.message.Message):
    """Request specifying an instance to get OperationFilters for"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the BuildGrid instance to get OperationFilters for"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name"]) -> None: ...

global___GetOperationFiltersRequest = GetOperationFiltersRequest

@typing_extensions.final
class OperationFilter(google.protobuf.message.Message):
    """Specification for a key to filter Operations by in ListOperations requests

    The filters are in the form `KEY COMPARATOR VALUE`, where the value may or
    may not come from the `values` field of this message. The other fields are
    metadata to help describe the format of the filter.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    COMPARATORS_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The filter key, used in the ListOperations filter string"""
    name: builtins.str
    """The filter name, used just for readability"""
    type: builtins.str
    """The type of values this filter accepts; either `text` or `datetime`"""
    description: builtins.str
    """Description of this filter key"""
    @property
    def comparators(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of valid comparators/operators to use with this filter key"""
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional list of values that are valid for this filter. If empty, the
        filter is assumed to accept any values of the specified type.
        """
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        name: builtins.str = ...,
        type: builtins.str = ...,
        description: builtins.str = ...,
        comparators: collections.abc.Iterable[builtins.str] | None = ...,
        values: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["comparators", b"comparators", "description", b"description", "key", b"key", "name", b"name", "type", b"type", "values", b"values"]) -> None: ...

global___OperationFilter = OperationFilter

@typing_extensions.final
class OperationFilters(google.protobuf.message.Message):
    """Response containing a list of OperationFilter specs"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILTERS_FIELD_NUMBER: builtins.int
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OperationFilter]:
        """A list of OperationFilter messages describing all available filter keys for
        ListOperations on the requested instance
        """
    def __init__(
        self,
        *,
        filters: collections.abc.Iterable[global___OperationFilter] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["filters", b"filters"]) -> None: ...

global___OperationFilters = OperationFilters

@typing_extensions.final
class OperationStatsRequest(google.protobuf.message.Message):
    """Request specifying an operation to get stats for"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    OPERATION_NAME_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the BuildGrid instance to query operations in"""
    operation_name: builtins.str
    """The name of the operation to get stats for"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        operation_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name", "operation_name", b"operation_name"]) -> None: ...

global___OperationStatsRequest = OperationStatsRequest

@typing_extensions.final
class OperationStats(google.protobuf.message.Message):
    """Response containing stats information about an operation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUEUE_POSITION_FIELD_NUMBER: builtins.int
    queue_position: builtins.str
    """Number of jobs ahead of this one in the queue"""
    def __init__(
        self,
        *,
        queue_position: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["queue_position", b"queue_position"]) -> None: ...

global___OperationStats = OperationStats

@typing_extensions.final
class GetJobHistoryRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    OPERATION_NAME_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The name of the BuildGrid instance to look for the operation in"""
    operation_name: builtins.str
    """The name of the operation to get job history for"""
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        operation_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name", "operation_name", b"operation_name"]) -> None: ...

global___GetJobHistoryRequest = GetJobHistoryRequest

@typing_extensions.final
class JobEvent(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_TYPE_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    event_type: global___JobEventType.ValueType
    """The type of event recorded here"""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which this event happened"""
    payload: builtins.str
    """Serialized JSON containing metadata for this event"""
    def __init__(
        self,
        *,
        event_type: global___JobEventType.ValueType = ...,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        payload: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event_type", b"event_type", "payload", b"payload", "timestamp", b"timestamp"]) -> None: ...

global___JobEvent = JobEvent

@typing_extensions.final
class JobHistory(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    HISTORY_FIELD_NUMBER: builtins.int
    @property
    def action_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """Action Digest of this job"""
    @property
    def history(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___JobEvent]:
        """A list of events relating to the job"""
    def __init__(
        self,
        *,
        action_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
        history: collections.abc.Iterable[global___JobEvent] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "history", b"history"]) -> None: ...

global___JobHistory = JobHistory
