"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Log Stream API"""
import abc
import buildgrid._protos.build.bazel.remote.logstream.v1.remote_logstream_pb2
import grpc

class LogStreamServiceStub:
    """#### Introduction

    The Log Stream API manages LogStream resources which are used to stream
    writes and reads of an ordered sequence of bytes of unknown eventual length.

    Note that this is an API Interface and not an API Service, per the definitons
    at: https://cloud.google.com/apis/design/glossary

    Log Stream API supports the reading of unfinalized LogStreams either by
    seeking or in "tail" mode, for example by end-users browsing to a build
    result UI interested in seeing logs from a build action as soon as they are
    (or as they become) available.

    Reads and Writes of LogStreams are done via the Byte Stream API:
    https://cloud.google.com/dataproc/docs/reference/rpc/google.bytestream
    https://github.com/googleapis/googleapis/blob/master/google/bytestream/bytestream.proto

    #### Writing LogStreams

    LogStreams are written to via the Byte Stream API's `Write` RPC. Bytes
    written to LogStreams are expected to be committed and available for reading
    within a reasonable period of time (implementation-defined). Committed bytes
    to a LogStream cannot be overwritten, and finalized LogStreams - indicated by
    setting `finish_write` field in the final WriteRequest - also cannot be
    appended to.

    When calling the Byte Stream API's `Write` RPC to write LogStreams, writers
    must pass the `write_resource_name` of a LogStream as
    `ByteStream.WriteRequest.resource_name` rather than the LogStream's `name`.
    Separate resource names for reading and writing allows for broadcasting the
    read resource name widely while simultaneously ensuring that only writer(s)
    with knowledge of the write resource name may have written bytes to the
    LogStream.

    #### Reading LogStreams

    Use the Byte Stream API's `Read` RPC to read LogStreams. When reading
    finalized LogStreams the server will stream all contents of the LogStream
    starting at `ByteStream.ReadRequest.read_offset`.

    When reading unfinalized LogStreams the server must keep the streaming
    `ByteStream.Read` RPC open and send `ByteStream.ReadResponse` messages as
    more bytes become available or the LogStream is finalized.

    #### Example Multi-Party Read/Write Flow

    1. LogStream Writer calls `CreateLogStream`
    2. LogStream Writer publishes `LogStream.name`
    3. LogStream Writer calls `ByteStream.Write` with
       `LogStream.write_resource_name` as
       `ByteStream.WriteRequest.resource_name`,
       `ByteStream.WriteRequest.finish_write`=false.
    4. LogStream Reader(s) call `ByteStream.Read` with the published
       `LogStream.name` as `ByteStream.ReadRequest.resource_name`.
    5. LogStream Service streams all committed bytes to LogStream Reader(s),
       leave the stream open.
    6. LogStream Writer calls `ByteStream.Write` with
       `LogStream.write_resource_name` as
       `ByteStream.WriteRequest.resource_name`,
       `ByteStream.WriteRequest.finish_write`=true.
    7. LogStream Service streams all remaining bytes to LogStream Reader(s),
       terminates the stream.
    """

    def __init__(self, channel: grpc.Channel) -> None: ...
    CreateLogStream: grpc.UnaryUnaryMultiCallable[
        buildgrid._protos.build.bazel.remote.logstream.v1.remote_logstream_pb2.CreateLogStreamRequest,
        buildgrid._protos.build.bazel.remote.logstream.v1.remote_logstream_pb2.LogStream,
    ]
    """Create a LogStream which may be written to.

    The returned LogStream resource name will include a `write_resource_name`
    which is the resource to use when writing to the LogStream.
    Callers of CreateLogStream are expected to NOT publish the
    `write_resource_name`.
    """

class LogStreamServiceServicer(metaclass=abc.ABCMeta):
    """#### Introduction

    The Log Stream API manages LogStream resources which are used to stream
    writes and reads of an ordered sequence of bytes of unknown eventual length.

    Note that this is an API Interface and not an API Service, per the definitons
    at: https://cloud.google.com/apis/design/glossary

    Log Stream API supports the reading of unfinalized LogStreams either by
    seeking or in "tail" mode, for example by end-users browsing to a build
    result UI interested in seeing logs from a build action as soon as they are
    (or as they become) available.

    Reads and Writes of LogStreams are done via the Byte Stream API:
    https://cloud.google.com/dataproc/docs/reference/rpc/google.bytestream
    https://github.com/googleapis/googleapis/blob/master/google/bytestream/bytestream.proto

    #### Writing LogStreams

    LogStreams are written to via the Byte Stream API's `Write` RPC. Bytes
    written to LogStreams are expected to be committed and available for reading
    within a reasonable period of time (implementation-defined). Committed bytes
    to a LogStream cannot be overwritten, and finalized LogStreams - indicated by
    setting `finish_write` field in the final WriteRequest - also cannot be
    appended to.

    When calling the Byte Stream API's `Write` RPC to write LogStreams, writers
    must pass the `write_resource_name` of a LogStream as
    `ByteStream.WriteRequest.resource_name` rather than the LogStream's `name`.
    Separate resource names for reading and writing allows for broadcasting the
    read resource name widely while simultaneously ensuring that only writer(s)
    with knowledge of the write resource name may have written bytes to the
    LogStream.

    #### Reading LogStreams

    Use the Byte Stream API's `Read` RPC to read LogStreams. When reading
    finalized LogStreams the server will stream all contents of the LogStream
    starting at `ByteStream.ReadRequest.read_offset`.

    When reading unfinalized LogStreams the server must keep the streaming
    `ByteStream.Read` RPC open and send `ByteStream.ReadResponse` messages as
    more bytes become available or the LogStream is finalized.

    #### Example Multi-Party Read/Write Flow

    1. LogStream Writer calls `CreateLogStream`
    2. LogStream Writer publishes `LogStream.name`
    3. LogStream Writer calls `ByteStream.Write` with
       `LogStream.write_resource_name` as
       `ByteStream.WriteRequest.resource_name`,
       `ByteStream.WriteRequest.finish_write`=false.
    4. LogStream Reader(s) call `ByteStream.Read` with the published
       `LogStream.name` as `ByteStream.ReadRequest.resource_name`.
    5. LogStream Service streams all committed bytes to LogStream Reader(s),
       leave the stream open.
    6. LogStream Writer calls `ByteStream.Write` with
       `LogStream.write_resource_name` as
       `ByteStream.WriteRequest.resource_name`,
       `ByteStream.WriteRequest.finish_write`=true.
    7. LogStream Service streams all remaining bytes to LogStream Reader(s),
       terminates the stream.
    """

    @abc.abstractmethod
    def CreateLogStream(
        self,
        request: buildgrid._protos.build.bazel.remote.logstream.v1.remote_logstream_pb2.CreateLogStreamRequest,
        context: grpc.ServicerContext,
    ) -> buildgrid._protos.build.bazel.remote.logstream.v1.remote_logstream_pb2.LogStream:
        """Create a LogStream which may be written to.

        The returned LogStream resource name will include a `write_resource_name`
        which is the resource to use when writing to the LogStream.
        Callers of CreateLogStream are expected to NOT publish the
        `write_resource_name`.
        """

def add_LogStreamServiceServicer_to_server(servicer: LogStreamServiceServicer, server: grpc.Server) -> None: ...
