"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Log Stream API"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class CreateLogStreamRequest(google.protobuf.message.Message):
    """Contains all information necessary to create a new LogStream resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PARENT_FIELD_NUMBER: builtins.int
    parent: builtins.str
    """Required. The parent resource of the created LogStream.
    The list of valid types of parent resources of LogStreams is up to the
    implementing server.
    Example: projects/123
    """
    def __init__(
        self,
        *,
        parent: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent"]) -> None: ...

global___CreateLogStreamRequest = CreateLogStreamRequest

@typing_extensions.final
class LogStream(google.protobuf.message.Message):
    """A handle to a log (an ordered sequence of bytes)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    WRITE_RESOURCE_NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Structured name of the resource in the format:
      {parent=**}/logstreams/{logstream_id}
      Example: projects/123/logStreams/456-def
    Attempting to call the Byte Stream API's `Write` RPC with a LogStream's
      `name` as the value for `ByteStream.Write.resource_name` is an error.
    """
    write_resource_name: builtins.str
    """Resource name to pass to `ByteStream.Write` in the format:
      {parent=**}/logStreams/{logstream_id}/{write_token}
      Example: projects/123/logStreams/456-def/789-ghi
    Attempting to call the Byte Stream API's `Read` RPC with a LogStream's
      `write_resource_name` as the value for `ByteStream.Write.resource_name`
      is an error.

    `write_resource_name` is separate from `name` to ensure that only the
    intended writers can write to a given LogStream. Writers must address write
    operations to the `write_resource_name`, not the `name`, and must have
    permission to write LogStreams. `write_resource_name` embeds a secret token
    and should be protected accordingly; a mishandled `write_resource_name` can
    result in unintended writers corrupting the LogStream. Therefore, the field
    should be excluded from calls to any calls which retrieve LogStream
    metadata (i.e.: `GetLogStream`).

    Bytes written to this resource must to be readable when `ByteStream.Read`
    is called with the `name` resource.
    Reading a write_resource_name must return an INVALID_ARGUMENT error.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        write_resource_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "write_resource_name", b"write_resource_name"]) -> None: ...

global___LogStream = LogStream
