"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 The Bazel Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import buildgrid._protos.build.bazel.semver.semver_pb2
import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import buildgrid._protos.google.rpc.status_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Action(google.protobuf.message.Message):
    """An `Action` captures all the information about an execution which is required
    to reproduce it.

    `Action`s are the core component of the [Execution] service. A single
    `Action` represents a repeatable action that can be performed by the
    execution service. `Action`s can be succinctly identified by the digest of
    their wire format encoding and, once an `Action` has been executed, will be
    cached in the action cache. Future requests can then use the cached result
    rather than needing to run afresh.

    When a server completes execution of an
    [Action][build.bazel.remote.execution.v2.Action], it MAY choose to
    cache the [result][build.bazel.remote.execution.v2.ActionResult] in
    the [ActionCache][build.bazel.remote.execution.v2.ActionCache] unless
    `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
    default, future calls to
    [Execute][build.bazel.remote.execution.v2.Execution.Execute] the same
    `Action` will also serve their results from the cache. Clients must take care
    to understand the caching behaviour. Ideally, all `Action`s will be
    reproducible so that serving a result from cache is always desirable and
    correct.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMMAND_DIGEST_FIELD_NUMBER: builtins.int
    INPUT_ROOT_DIGEST_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    DO_NOT_CACHE_FIELD_NUMBER: builtins.int
    SALT_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    @property
    def command_digest(self) -> global___Digest:
        """The digest of the [Command][build.bazel.remote.execution.v2.Command]
        to run, which MUST be present in the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        """
    @property
    def input_root_digest(self) -> global___Digest:
        """The digest of the root
        [Directory][build.bazel.remote.execution.v2.Directory] for the input
        files. The files in the directory tree are available in the correct
        location on the build machine before the command is executed. The root
        directory, as well as every subdirectory and content blob referred to, MUST
        be in the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        """
    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """A timeout after which the execution should be killed. If the timeout is
        absent, then the client is specifying that the execution should continue
        as long as the server will let it. The server SHOULD impose a timeout if
        the client does not specify one, however, if the client does specify a
        timeout that is longer than the server's maximum timeout, the server MUST
        reject the request.

        The timeout is only intended to cover the "execution" of the specified
        action and not time in queue nor any overheads before or after execution
        such as marshalling inputs/outputs. The server SHOULD avoid including time
        spent the client doesn't have control over, and MAY extend or reduce the
        timeout to account for delays or speedups that occur during execution
        itself (e.g., lazily loading data from the Content Addressable Storage,
        live migration of virtual machines, emulation overhead).

        The timeout is a part of the
        [Action][build.bazel.remote.execution.v2.Action] message, and
        therefore two `Actions` with different timeouts are different, even if they
        are otherwise identical. This is because, if they were not, running an
        `Action` with a lower timeout than is required might result in a cache hit
        from an execution run with a longer timeout, hiding the fact that the
        timeout is too short. By encoding it directly in the `Action`, a lower
        timeout will result in a cache miss and the execution timeout will fail
        immediately, rather than whenever the cache entry gets evicted.
        """
    do_not_cache: builtins.bool
    """If true, then the `Action`'s result cannot be cached, and in-flight
    requests for the same `Action` may not be merged.
    """
    salt: builtins.bytes
    """An optional additional salt value used to place this `Action` into a
    separate cache namespace from other instances having the same field
    contents. This salt typically comes from operational configuration
    specific to sources such as repo and service configuration,
    and allows disowning an entire set of ActionResults that might have been
    poisoned by buggy software or tool failures.
    """
    @property
    def platform(self) -> global___Platform:
        """The optional platform requirements for the execution environment. The
        server MAY choose to execute the action on any worker satisfying the
        requirements, so the client SHOULD ensure that running the action on any
        such worker will have the same result.  A detailed lexicon for this can be
        found in the accompanying platform.md.
        New in version 2.2: clients SHOULD set these platform properties as well
        as those in the [Command][build.bazel.remote.execution.v2.Command]. Servers
        SHOULD prefer those set here.
        """
    def __init__(
        self,
        *,
        command_digest: global___Digest | None = ...,
        input_root_digest: global___Digest | None = ...,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
        do_not_cache: builtins.bool = ...,
        salt: builtins.bytes = ...,
        platform: global___Platform | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["command_digest", b"command_digest", "input_root_digest", b"input_root_digest", "platform", b"platform", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["command_digest", b"command_digest", "do_not_cache", b"do_not_cache", "input_root_digest", b"input_root_digest", "platform", b"platform", "salt", b"salt", "timeout", b"timeout"]) -> None: ...

global___Action = Action

@typing_extensions.final
class Command(google.protobuf.message.Message):
    """A `Command` is the actual command executed by a worker running an
    [Action][build.bazel.remote.execution.v2.Action] and specifications of its
    environment.

    Except as otherwise required, the environment (such as which system
    libraries or binaries are available, and what filesystems are mounted where)
    is defined by and specific to the implementation of the remote execution API.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _OutputDirectoryFormat:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OutputDirectoryFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Command._OutputDirectoryFormat.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TREE_ONLY: Command._OutputDirectoryFormat.ValueType  # 0
        """The client is only interested in receiving output directories in
        the form of a single Tree object, using the `tree_digest` field.
        """
        DIRECTORY_ONLY: Command._OutputDirectoryFormat.ValueType  # 1
        """The client is only interested in receiving output directories in
        the form of a hierarchy of separately stored Directory objects,
        using the `root_directory_digest` field.
        """
        TREE_AND_DIRECTORY: Command._OutputDirectoryFormat.ValueType  # 2
        """The client is interested in receiving output directories both in
        the form of a single Tree object and a hierarchy of separately
        stored Directory objects, using both the `tree_digest` and
        `root_directory_digest` fields.
        """

    class OutputDirectoryFormat(_OutputDirectoryFormat, metaclass=_OutputDirectoryFormatEnumTypeWrapper): ...
    TREE_ONLY: Command.OutputDirectoryFormat.ValueType  # 0
    """The client is only interested in receiving output directories in
    the form of a single Tree object, using the `tree_digest` field.
    """
    DIRECTORY_ONLY: Command.OutputDirectoryFormat.ValueType  # 1
    """The client is only interested in receiving output directories in
    the form of a hierarchy of separately stored Directory objects,
    using the `root_directory_digest` field.
    """
    TREE_AND_DIRECTORY: Command.OutputDirectoryFormat.ValueType  # 2
    """The client is interested in receiving output directories both in
    the form of a single Tree object and a hierarchy of separately
    stored Directory objects, using both the `tree_digest` and
    `root_directory_digest` fields.
    """

    @typing_extensions.final
    class EnvironmentVariable(google.protobuf.message.Message):
        """An `EnvironmentVariable` is one variable to set in the running program's
        environment.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """The variable name."""
        value: builtins.str
        """The variable value."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]) -> None: ...

    ARGUMENTS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_VARIABLES_FIELD_NUMBER: builtins.int
    OUTPUT_FILES_FIELD_NUMBER: builtins.int
    OUTPUT_DIRECTORIES_FIELD_NUMBER: builtins.int
    OUTPUT_PATHS_FIELD_NUMBER: builtins.int
    PLATFORM_FIELD_NUMBER: builtins.int
    WORKING_DIRECTORY_FIELD_NUMBER: builtins.int
    OUTPUT_NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    OUTPUT_DIRECTORY_FORMAT_FIELD_NUMBER: builtins.int
    @property
    def arguments(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The arguments to the command.

        The first argument specifies the command to run, which may be either an
        absolute path, a path relative to the working directory, or an unqualified
        path (without path separators) which will be resolved using the operating
        system's equivalent of the PATH environment variable. Path separators
        native to the operating system running on the worker SHOULD be used. If the
        `environment_variables` list contains an entry for the PATH environment
        variable, it SHOULD be respected. If not, the resolution process is
        implementation-defined.

        Changed in v2.3. v2.2 and older require that no PATH lookups are performed,
        and that relative paths are resolved relative to the input root. This
        behavior can, however, not be relied upon, as most implementations already
        followed the rules described above.
        """
    @property
    def environment_variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Command.EnvironmentVariable]:
        """The environment variables to set when running the program. The worker may
        provide its own default environment variables; these defaults can be
        overridden using this field. Additional variables can also be specified.

        In order to ensure that equivalent
        [Command][build.bazel.remote.execution.v2.Command]s always hash to the same
        value, the environment variables MUST be lexicographically sorted by name.
        Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.
        """
    @property
    def output_files(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of the output files that the client expects to retrieve from the
        action. Only the listed files, as well as directories listed in
        `output_directories`, will be returned to the client as output.
        Other files or directories that may be created during command execution
        are discarded.

        The paths are relative to the working directory of the action execution.
        The paths are specified using a single forward slash (`/`) as a path
        separator, even if the execution platform natively uses a different
        separator. The path MUST NOT include a trailing slash, nor a leading slash,
        being a relative path.

        In order to ensure consistent hashing of the same Action, the output paths
        MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
        bytes).

        An output file cannot be duplicated, be a parent of another output file, or
        have the same path as any of the listed output directories.

        Directories leading up to the output files are created by the worker prior
        to execution, even if they are not explicitly part of the input root.

        DEPRECATED since v2.1: Use `output_paths` instead.
        """
    @property
    def output_directories(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of the output directories that the client expects to retrieve from
        the action. Only the listed directories will be returned (an entire
        directory structure will be returned as a
        [Tree][build.bazel.remote.execution.v2.Tree] message digest, see
        [OutputDirectory][build.bazel.remote.execution.v2.OutputDirectory]), as
        well as files listed in `output_files`. Other files or directories that
        may be created during command execution are discarded.

        The paths are relative to the working directory of the action execution.
        The paths are specified using a single forward slash (`/`) as a path
        separator, even if the execution platform natively uses a different
        separator. The path MUST NOT include a trailing slash, nor a leading slash,
        being a relative path. The special value of empty string is allowed,
        although not recommended, and can be used to capture the entire working
        directory tree, including inputs.

        In order to ensure consistent hashing of the same Action, the output paths
        MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
        bytes).

        An output directory cannot be duplicated or have the same path as any of
        the listed output files. An output directory is allowed to be a parent of
        another output directory.

        Directories leading up to the output directories (but not the output
        directories themselves) are created by the worker prior to execution, even
        if they are not explicitly part of the input root.

        DEPRECATED since 2.1: Use `output_paths` instead.
        """
    @property
    def output_paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of the output paths that the client expects to retrieve from the
        action. Only the listed paths will be returned to the client as output.
        The type of the output (file or directory) is not specified, and will be
        determined by the server after action execution. If the resulting path is
        a file, it will be returned in an
        [OutputFile][build.bazel.remote.execution.v2.OutputFile] typed field.
        If the path is a directory, the entire directory structure will be returned
        as a [Tree][build.bazel.remote.execution.v2.Tree] message digest, see
        [OutputDirectory][build.bazel.remote.execution.v2.OutputDirectory]
        Other files or directories that may be created during command execution
        are discarded.

        The paths are relative to the working directory of the action execution.
        The paths are specified using a single forward slash (`/`) as a path
        separator, even if the execution platform natively uses a different
        separator. The path MUST NOT include a trailing slash, nor a leading slash,
        being a relative path.

        In order to ensure consistent hashing of the same Action, the output paths
        MUST be deduplicated and sorted lexicographically by code point (or,
        equivalently, by UTF-8 bytes).

        Directories leading up to the output paths are created by the worker prior
        to execution, even if they are not explicitly part of the input root.

        New in v2.1: this field supersedes the DEPRECATED `output_files` and
        `output_directories` fields. If `output_paths` is used, `output_files` and
        `output_directories` will be ignored!
        """
    @property
    def platform(self) -> global___Platform:
        """The platform requirements for the execution environment. The server MAY
        choose to execute the action on any worker satisfying the requirements, so
        the client SHOULD ensure that running the action on any such worker will
        have the same result.  A detailed lexicon for this can be found in the
        accompanying platform.md.
        DEPRECATED as of v2.2: platform properties are now specified directly in
        the action. See documentation note in the
        [Action][build.bazel.remote.execution.v2.Action] for migration.
        """
    working_directory: builtins.str
    """The working directory, relative to the input root, for the command to run
    in. It must be a directory which exists in the input tree. If it is left
    empty, then the action is run in the input root.
    """
    @property
    def output_node_properties(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of keys for node properties the client expects to retrieve for
        output files and directories. Keys are either names of string-based
        [NodeProperty][build.bazel.remote.execution.v2.NodeProperty] or
        names of fields in [NodeProperties][build.bazel.remote.execution.v2.NodeProperties].
        In order to ensure that equivalent `Action`s always hash to the same
        value, the node properties MUST be lexicographically sorted by name.
        Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.

        The interpretation of string-based properties is server-dependent. If a
        property is not recognized by the server, the server will return an
        `INVALID_ARGUMENT`.
        """
    output_directory_format: global___Command.OutputDirectoryFormat.ValueType
    """The format that the worker should use to store the contents of
    output directories.

    In case this field is set to a value that is not supported by the
    worker, the worker SHOULD interpret this field as TREE_ONLY. The
    worker MAY store output directories in formats that are a superset
    of what was requested (e.g., interpreting DIRECTORY_ONLY as
    TREE_AND_DIRECTORY).
    """
    def __init__(
        self,
        *,
        arguments: collections.abc.Iterable[builtins.str] | None = ...,
        environment_variables: collections.abc.Iterable[global___Command.EnvironmentVariable] | None = ...,
        output_files: collections.abc.Iterable[builtins.str] | None = ...,
        output_directories: collections.abc.Iterable[builtins.str] | None = ...,
        output_paths: collections.abc.Iterable[builtins.str] | None = ...,
        platform: global___Platform | None = ...,
        working_directory: builtins.str = ...,
        output_node_properties: collections.abc.Iterable[builtins.str] | None = ...,
        output_directory_format: global___Command.OutputDirectoryFormat.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["platform", b"platform"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["arguments", b"arguments", "environment_variables", b"environment_variables", "output_directories", b"output_directories", "output_directory_format", b"output_directory_format", "output_files", b"output_files", "output_node_properties", b"output_node_properties", "output_paths", b"output_paths", "platform", b"platform", "working_directory", b"working_directory"]) -> None: ...

global___Command = Command

@typing_extensions.final
class Platform(google.protobuf.message.Message):
    """A `Platform` is a set of requirements, such as hardware, operating system, or
    compiler toolchain, for an
    [Action][build.bazel.remote.execution.v2.Action]'s execution
    environment. A `Platform` is represented as a series of key-value pairs
    representing the properties that are required of the platform.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Property(google.protobuf.message.Message):
        """A single property for the environment. The server is responsible for
        specifying the property `name`s that it accepts. If an unknown `name` is
        provided in the requirements for an
        [Action][build.bazel.remote.execution.v2.Action], the server SHOULD
        reject the execution request. If permitted by the server, the same `name`
        may occur multiple times.

        The server is also responsible for specifying the interpretation of
        property `value`s. For instance, a property describing how much RAM must be
        available may be interpreted as allowing a worker with 16GB to fulfill a
        request for 8GB, while a property describing the OS environment on which
        the action must be performed may require an exact match with the worker's
        OS.

        The server MAY use the `value` of one or more properties to determine how
        it sets up the execution environment, such as by making specific system
        files available to the worker.

        Both names and values are typically case-sensitive. Note that the platform
        is implicitly part of the action digest, so even tiny changes in the names
        or values (like changing case) may result in different action cache
        entries.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """The property name."""
        value: builtins.str
        """The property value."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]) -> None: ...

    PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def properties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Platform.Property]:
        """The properties that make up this platform. In order to ensure that
        equivalent `Platform`s always hash to the same value, the properties MUST
        be lexicographically sorted by name, and then by value. Sorting of strings
        is done by code point, equivalently, by the UTF-8 bytes.
        """
    def __init__(
        self,
        *,
        properties: collections.abc.Iterable[global___Platform.Property] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["properties", b"properties"]) -> None: ...

global___Platform = Platform

@typing_extensions.final
class Directory(google.protobuf.message.Message):
    """A `Directory` represents a directory node in a file tree, containing zero or
    more children [FileNodes][build.bazel.remote.execution.v2.FileNode],
    [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode] and
    [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode].
    Each `Node` contains its name in the directory, either the digest of its
    content (either a file blob or a `Directory` proto) or a symlink target, as
    well as possibly some metadata about the file or directory.

    In order to ensure that two equivalent directory trees hash to the same
    value, the following restrictions MUST be obeyed when constructing a
    a `Directory`:

    * Every child in the directory must have a path of exactly one segment.
      Multiple levels of directory hierarchy may not be collapsed.
    * Each child in the directory must have a unique path segment (file name).
      Note that while the API itself is case-sensitive, the environment where
      the Action is executed may or may not be case-sensitive. That is, it is
      legal to call the API with a Directory that has both "Foo" and "foo" as
      children, but the Action may be rejected by the remote system upon
      execution.
    * The files, directories and symlinks in the directory must each be sorted
      in lexicographical order by path. The path strings must be sorted by code
      point, equivalently, by UTF-8 bytes.
    * The [NodeProperties][build.bazel.remote.execution.v2.NodeProperty] of files,
      directories, and symlinks must be sorted in lexicographical order by
      property name.

    A `Directory` that obeys the restrictions is said to be in canonical form.

    As an example, the following could be used for a file named `bar` and a
    directory named `foo` with an executable file named `baz` (hashes shortened
    for readability):

    ```json
    // (Directory proto)
    {
      files: [
        {
          name: "bar",
          digest: {
            hash: "4a73bc9d03...",
            size: 65534
          },
          node_properties: [
            {
              "name": "MTime",
              "value": "2017-01-15T01:30:15.01Z"
            }
          ]
        }
      ],
      directories: [
        {
          name: "foo",
          digest: {
            hash: "4cf2eda940...",
            size: 43
          }
        }
      ]
    }

    // (Directory proto with hash "4cf2eda940..." and size 43)
    {
      files: [
        {
          name: "baz",
          digest: {
            hash: "b2c941073e...",
            size: 1294,
          },
          is_executable: true
        }
      ]
    }
    ```
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILES_FIELD_NUMBER: builtins.int
    DIRECTORIES_FIELD_NUMBER: builtins.int
    SYMLINKS_FIELD_NUMBER: builtins.int
    NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FileNode]:
        """The files in the directory."""
    @property
    def directories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DirectoryNode]:
        """The subdirectories in the directory."""
    @property
    def symlinks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SymlinkNode]:
        """The symlinks in the directory."""
    @property
    def node_properties(self) -> global___NodeProperties: ...
    def __init__(
        self,
        *,
        files: collections.abc.Iterable[global___FileNode] | None = ...,
        directories: collections.abc.Iterable[global___DirectoryNode] | None = ...,
        symlinks: collections.abc.Iterable[global___SymlinkNode] | None = ...,
        node_properties: global___NodeProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["node_properties", b"node_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["directories", b"directories", "files", b"files", "node_properties", b"node_properties", "symlinks", b"symlinks"]) -> None: ...

global___Directory = Directory

@typing_extensions.final
class NodeProperty(google.protobuf.message.Message):
    """A single property for [FileNodes][build.bazel.remote.execution.v2.FileNode],
    [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode], and
    [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode]. The server is
    responsible for specifying the property `name`s that it accepts. If
    permitted by the server, the same `name` may occur multiple times.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The property name."""
    value: builtins.str
    """The property value."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]) -> None: ...

global___NodeProperty = NodeProperty

@typing_extensions.final
class NodeProperties(google.protobuf.message.Message):
    """Node properties for [FileNodes][build.bazel.remote.execution.v2.FileNode],
    [DirectoryNodes][build.bazel.remote.execution.v2.DirectoryNode], and
    [SymlinkNodes][build.bazel.remote.execution.v2.SymlinkNode]. The server is
    responsible for specifying the properties that it accepts.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROPERTIES_FIELD_NUMBER: builtins.int
    MTIME_FIELD_NUMBER: builtins.int
    UNIX_MODE_FIELD_NUMBER: builtins.int
    @property
    def properties(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NodeProperty]:
        """A list of string-based
        [NodeProperties][build.bazel.remote.execution.v2.NodeProperty].
        """
    @property
    def mtime(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The file's last modification timestamp."""
    @property
    def unix_mode(self) -> google.protobuf.wrappers_pb2.UInt32Value:
        """The UNIX file mode, e.g., 0755."""
    def __init__(
        self,
        *,
        properties: collections.abc.Iterable[global___NodeProperty] | None = ...,
        mtime: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        unix_mode: google.protobuf.wrappers_pb2.UInt32Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["mtime", b"mtime", "unix_mode", b"unix_mode"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["mtime", b"mtime", "properties", b"properties", "unix_mode", b"unix_mode"]) -> None: ...

global___NodeProperties = NodeProperties

@typing_extensions.final
class FileNode(google.protobuf.message.Message):
    """A `FileNode` represents a single file and associated metadata."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    IS_EXECUTABLE_FIELD_NUMBER: builtins.int
    NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the file."""
    @property
    def digest(self) -> global___Digest:
        """The digest of the file's content."""
    is_executable: builtins.bool
    """True if file is executable, false otherwise."""
    @property
    def node_properties(self) -> global___NodeProperties: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        digest: global___Digest | None = ...,
        is_executable: builtins.bool = ...,
        node_properties: global___NodeProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["digest", b"digest", "node_properties", b"node_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "is_executable", b"is_executable", "name", b"name", "node_properties", b"node_properties"]) -> None: ...

global___FileNode = FileNode

@typing_extensions.final
class DirectoryNode(google.protobuf.message.Message):
    """A `DirectoryNode` represents a child of a
    [Directory][build.bazel.remote.execution.v2.Directory] which is itself
    a `Directory` and its associated metadata.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the directory."""
    @property
    def digest(self) -> global___Digest:
        """The digest of the
        [Directory][build.bazel.remote.execution.v2.Directory] object
        represented. See [Digest][build.bazel.remote.execution.v2.Digest]
        for information about how to take the digest of a proto message.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        digest: global___Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["digest", b"digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "name", b"name"]) -> None: ...

global___DirectoryNode = DirectoryNode

@typing_extensions.final
class SymlinkNode(google.protobuf.message.Message):
    """A `SymlinkNode` represents a symbolic link."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the symlink."""
    target: builtins.str
    """The target path of the symlink. The path separator is a forward slash `/`.
    The target path can be relative to the parent directory of the symlink or
    it can be an absolute path starting with `/`. Support for absolute paths
    can be checked using the [Capabilities][build.bazel.remote.execution.v2.Capabilities]
    API. `..` components are allowed anywhere in the target path as logical
    canonicalization may lead to different behavior in the presence of
    directory symlinks (e.g. `foo/../bar` may not be the same as `bar`).
    To reduce potential cache misses, canonicalization is still recommended
    where this is possible without impacting correctness.
    """
    @property
    def node_properties(self) -> global___NodeProperties: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        target: builtins.str = ...,
        node_properties: global___NodeProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["node_properties", b"node_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "node_properties", b"node_properties", "target", b"target"]) -> None: ...

global___SymlinkNode = SymlinkNode

@typing_extensions.final
class Digest(google.protobuf.message.Message):
    """A content digest. A digest for a given blob consists of the size of the blob
    and its hash. The hash algorithm to use is defined by the server.

    The size is considered to be an integral part of the digest and cannot be
    separated. That is, even if the `hash` field is correctly specified but
    `size_bytes` is not, the server MUST reject the request.

    The reason for including the size in the digest is as follows: in a great
    many cases, the server needs to know the size of the blob it is about to work
    with prior to starting an operation with it, such as flattening Merkle tree
    structures or streaming it to a worker. Technically, the server could
    implement a separate metadata store, but this results in a significantly more
    complicated implementation as opposed to having the client specify the size
    up-front (or storing the size along with the digest in every message where
    digests are embedded). This does mean that the API leaks some implementation
    details of (what we consider to be) a reasonable server implementation, but
    we consider this to be a worthwhile tradeoff.

    When a `Digest` is used to refer to a proto message, it always refers to the
    message in binary encoded form. To ensure consistent hashing, clients and
    servers MUST ensure that they serialize messages according to the following
    rules, even if there are alternate valid encodings for the same message:

    * Fields are serialized in tag order.
    * There are no unknown fields.
    * There are no duplicate fields.
    * Fields are serialized according to the default semantics for their type.

    Most protocol buffer implementations will always follow these rules when
    serializing, but care should be taken to avoid shortcuts. For instance,
    concatenating two messages to merge them may produce duplicate fields.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASH_FIELD_NUMBER: builtins.int
    SIZE_BYTES_FIELD_NUMBER: builtins.int
    hash: builtins.str
    """The hash. In the case of SHA-256, it will always be a lowercase hex string
    exactly 64 characters long.
    """
    size_bytes: builtins.int
    """The size of the blob, in bytes."""
    def __init__(
        self,
        *,
        hash: builtins.str = ...,
        size_bytes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["hash", b"hash", "size_bytes", b"size_bytes"]) -> None: ...

global___Digest = Digest

@typing_extensions.final
class ExecutedActionMetadata(google.protobuf.message.Message):
    """ExecutedActionMetadata contains details about a completed execution."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKER_FIELD_NUMBER: builtins.int
    QUEUED_TIMESTAMP_FIELD_NUMBER: builtins.int
    WORKER_START_TIMESTAMP_FIELD_NUMBER: builtins.int
    WORKER_COMPLETED_TIMESTAMP_FIELD_NUMBER: builtins.int
    INPUT_FETCH_START_TIMESTAMP_FIELD_NUMBER: builtins.int
    INPUT_FETCH_COMPLETED_TIMESTAMP_FIELD_NUMBER: builtins.int
    EXECUTION_START_TIMESTAMP_FIELD_NUMBER: builtins.int
    EXECUTION_COMPLETED_TIMESTAMP_FIELD_NUMBER: builtins.int
    VIRTUAL_EXECUTION_DURATION_FIELD_NUMBER: builtins.int
    OUTPUT_UPLOAD_START_TIMESTAMP_FIELD_NUMBER: builtins.int
    OUTPUT_UPLOAD_COMPLETED_TIMESTAMP_FIELD_NUMBER: builtins.int
    AUXILIARY_METADATA_FIELD_NUMBER: builtins.int
    worker: builtins.str
    """The name of the worker which ran the execution."""
    @property
    def queued_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When was the action added to the queue."""
    @property
    def worker_start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker received the action."""
    @property
    def worker_completed_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker completed the action, including all stages."""
    @property
    def input_fetch_start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker started fetching action inputs."""
    @property
    def input_fetch_completed_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker finished fetching action inputs."""
    @property
    def execution_start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker started executing the action command."""
    @property
    def execution_completed_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker completed executing the action command."""
    @property
    def virtual_execution_duration(self) -> google.protobuf.duration_pb2.Duration:
        """New in v2.3: the amount of time the worker spent executing the action
        command, potentially computed using a worker-specific virtual clock.

        The virtual execution duration is only intended to cover the "execution" of
        the specified action and not time in queue nor any overheads before or
        after execution such as marshalling inputs/outputs. The server SHOULD avoid
        including time spent the client doesn't have control over, and MAY extend
        or reduce the execution duration to account for delays or speedups that
        occur during execution itself (e.g., lazily loading data from the Content
        Addressable Storage, live migration of virtual machines, emulation
        overhead).

        The method of timekeeping used to compute the virtual execution duration
        MUST be consistent with what is used to enforce the
        [Action][[build.bazel.remote.execution.v2.Action]'s `timeout`. There is no
        relationship between the virtual execution duration and the values of
        `execution_start_timestamp` and `execution_completed_timestamp`.
        """
    @property
    def output_upload_start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker started uploading action outputs."""
    @property
    def output_upload_completed_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """When the worker finished uploading action outputs."""
    @property
    def auxiliary_metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.any_pb2.Any]:
        """Details that are specific to the kind of worker used. For example,
        on POSIX-like systems this could contain a message with
        getrusage(2) statistics.
        """
    def __init__(
        self,
        *,
        worker: builtins.str = ...,
        queued_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        worker_start_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        worker_completed_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input_fetch_start_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        input_fetch_completed_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        execution_start_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        execution_completed_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        virtual_execution_duration: google.protobuf.duration_pb2.Duration | None = ...,
        output_upload_start_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        output_upload_completed_timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        auxiliary_metadata: collections.abc.Iterable[google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["execution_completed_timestamp", b"execution_completed_timestamp", "execution_start_timestamp", b"execution_start_timestamp", "input_fetch_completed_timestamp", b"input_fetch_completed_timestamp", "input_fetch_start_timestamp", b"input_fetch_start_timestamp", "output_upload_completed_timestamp", b"output_upload_completed_timestamp", "output_upload_start_timestamp", b"output_upload_start_timestamp", "queued_timestamp", b"queued_timestamp", "virtual_execution_duration", b"virtual_execution_duration", "worker_completed_timestamp", b"worker_completed_timestamp", "worker_start_timestamp", b"worker_start_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["auxiliary_metadata", b"auxiliary_metadata", "execution_completed_timestamp", b"execution_completed_timestamp", "execution_start_timestamp", b"execution_start_timestamp", "input_fetch_completed_timestamp", b"input_fetch_completed_timestamp", "input_fetch_start_timestamp", b"input_fetch_start_timestamp", "output_upload_completed_timestamp", b"output_upload_completed_timestamp", "output_upload_start_timestamp", b"output_upload_start_timestamp", "queued_timestamp", b"queued_timestamp", "virtual_execution_duration", b"virtual_execution_duration", "worker", b"worker", "worker_completed_timestamp", b"worker_completed_timestamp", "worker_start_timestamp", b"worker_start_timestamp"]) -> None: ...

global___ExecutedActionMetadata = ExecutedActionMetadata

@typing_extensions.final
class ActionResult(google.protobuf.message.Message):
    """An ActionResult represents the result of an
    [Action][build.bazel.remote.execution.v2.Action] being run.

    It is advised that at least one field (for example
    `ActionResult.execution_metadata.Worker`) have a non-default value, to
    ensure that the serialized value is non-empty, which can then be used
    as a basic data sanity check.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUT_FILES_FIELD_NUMBER: builtins.int
    OUTPUT_FILE_SYMLINKS_FIELD_NUMBER: builtins.int
    OUTPUT_SYMLINKS_FIELD_NUMBER: builtins.int
    OUTPUT_DIRECTORIES_FIELD_NUMBER: builtins.int
    OUTPUT_DIRECTORY_SYMLINKS_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    STDOUT_RAW_FIELD_NUMBER: builtins.int
    STDOUT_DIGEST_FIELD_NUMBER: builtins.int
    STDERR_RAW_FIELD_NUMBER: builtins.int
    STDERR_DIGEST_FIELD_NUMBER: builtins.int
    EXECUTION_METADATA_FIELD_NUMBER: builtins.int
    @property
    def output_files(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputFile]:
        """The output files of the action. For each output file requested in the
        `output_files` or `output_paths` field of the Action, if the corresponding
        file existed after the action completed, a single entry will be present
        either in this field, or the `output_file_symlinks` field if the file was
        a symbolic link to another file (`output_symlinks` field after v2.1).

        If an output listed in `output_files` was found, but was a directory rather
        than a regular file, the server will return a FAILED_PRECONDITION.
        If the action does not produce the requested output, then that output
        will be omitted from the list. The server is free to arrange the output
        list as desired; clients MUST NOT assume that the output list is sorted.
        """
    @property
    def output_file_symlinks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputSymlink]:
        """The output files of the action that are symbolic links to other files. Those
        may be links to other output files, or input files, or even absolute paths
        outside of the working directory, if the server supports
        [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
        For each output file requested in the `output_files` or `output_paths`
        field of the Action, if the corresponding file existed after
        the action completed, a single entry will be present either in this field,
        or in the `output_files` field, if the file was not a symbolic link.

        If an output symbolic link of the same name as listed in `output_files` of
        the Command was found, but its target type was not a regular file, the
        server will return a FAILED_PRECONDITION.
        If the action does not produce the requested output, then that output
        will be omitted from the list. The server is free to arrange the output
        list as desired; clients MUST NOT assume that the output list is sorted.

        DEPRECATED as of v2.1. Servers that wish to be compatible with v2.0 API
        should still populate this field in addition to `output_symlinks`.
        """
    @property
    def output_symlinks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputSymlink]:
        """New in v2.1: this field will only be populated if the command
        `output_paths` field was used, and not the pre v2.1 `output_files` or
        `output_directories` fields.
        The output paths of the action that are symbolic links to other paths. Those
        may be links to other outputs, or inputs, or even absolute paths
        outside of the working directory, if the server supports
        [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
        A single entry for each output requested in `output_paths`
        field of the Action, if the corresponding path existed after
        the action completed and was a symbolic link.

        If the action does not produce a requested output, then that output
        will be omitted from the list. The server is free to arrange the output
        list as desired; clients MUST NOT assume that the output list is sorted.
        """
    @property
    def output_directories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputDirectory]:
        """The output directories of the action. For each output directory requested
        in the `output_directories` or `output_paths` field of the Action, if the
        corresponding directory existed after the action completed, a single entry
        will be present in the output list, which will contain the digest of a
        [Tree][build.bazel.remote.execution.v2.Tree] message containing the
        directory tree, and the path equal exactly to the corresponding Action
        output_directories member.

        As an example, suppose the Action had an output directory `a/b/dir` and the
        execution produced the following contents in `a/b/dir`: a file named `bar`
        and a directory named `foo` with an executable file named `baz`. Then,
        output_directory will contain (hashes shortened for readability):

        ```json
        // OutputDirectory proto:
        {
          path: "a/b/dir"
          tree_digest: {
            hash: "4a73bc9d03...",
            size: 55
          }
        }
        // Tree proto with hash "4a73bc9d03..." and size 55:
        {
          root: {
            files: [
              {
                name: "bar",
                digest: {
                  hash: "4a73bc9d03...",
                  size: 65534
                }
              }
            ],
            directories: [
              {
                name: "foo",
                digest: {
                  hash: "4cf2eda940...",
                  size: 43
                }
              }
            ]
          }
          children : {
            // (Directory proto with hash "4cf2eda940..." and size 43)
            files: [
              {
                name: "baz",
                digest: {
                  hash: "b2c941073e...",
                  size: 1294,
                },
                is_executable: true
              }
            ]
          }
        }
        ```
        If an output of the same name as listed in `output_files` of
        the Command was found in `output_directories`, but was not a directory, the
        server will return a FAILED_PRECONDITION.
        """
    @property
    def output_directory_symlinks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___OutputSymlink]:
        """The output directories of the action that are symbolic links to other
        directories. Those may be links to other output directories, or input
        directories, or even absolute paths outside of the working directory,
        if the server supports
        [SymlinkAbsolutePathStrategy.ALLOWED][build.bazel.remote.execution.v2.CacheCapabilities.SymlinkAbsolutePathStrategy].
        For each output directory requested in the `output_directories` field of
        the Action, if the directory existed after the action completed, a
        single entry will be present either in this field, or in the
        `output_directories` field, if the directory was not a symbolic link.

        If an output of the same name was found, but was a symbolic link to a file
        instead of a directory, the server will return a FAILED_PRECONDITION.
        If the action does not produce the requested output, then that output
        will be omitted from the list. The server is free to arrange the output
        list as desired; clients MUST NOT assume that the output list is sorted.

        DEPRECATED as of v2.1. Servers that wish to be compatible with v2.0 API
        should still populate this field in addition to `output_symlinks`.
        """
    exit_code: builtins.int
    """The exit code of the command."""
    stdout_raw: builtins.bytes
    """The standard output buffer of the action. The server SHOULD NOT inline
    stdout unless requested by the client in the
    [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
    message. The server MAY omit inlining, even if requested, and MUST do so if inlining
    would cause the response to exceed message size limits.
    Clients SHOULD NOT populate this field when uploading to the cache.
    """
    @property
    def stdout_digest(self) -> global___Digest:
        """The digest for a blob containing the standard output of the action, which
        can be retrieved from the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        """
    stderr_raw: builtins.bytes
    """The standard error buffer of the action. The server SHOULD NOT inline
    stderr unless requested by the client in the
    [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
    message. The server MAY omit inlining, even if requested, and MUST do so if inlining
    would cause the response to exceed message size limits.
    Clients SHOULD NOT populate this field when uploading to the cache.
    """
    @property
    def stderr_digest(self) -> global___Digest:
        """The digest for a blob containing the standard error of the action, which
        can be retrieved from the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        """
    @property
    def execution_metadata(self) -> global___ExecutedActionMetadata:
        """The details of the execution that originally produced this result."""
    def __init__(
        self,
        *,
        output_files: collections.abc.Iterable[global___OutputFile] | None = ...,
        output_file_symlinks: collections.abc.Iterable[global___OutputSymlink] | None = ...,
        output_symlinks: collections.abc.Iterable[global___OutputSymlink] | None = ...,
        output_directories: collections.abc.Iterable[global___OutputDirectory] | None = ...,
        output_directory_symlinks: collections.abc.Iterable[global___OutputSymlink] | None = ...,
        exit_code: builtins.int = ...,
        stdout_raw: builtins.bytes = ...,
        stdout_digest: global___Digest | None = ...,
        stderr_raw: builtins.bytes = ...,
        stderr_digest: global___Digest | None = ...,
        execution_metadata: global___ExecutedActionMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["execution_metadata", b"execution_metadata", "stderr_digest", b"stderr_digest", "stdout_digest", b"stdout_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["execution_metadata", b"execution_metadata", "exit_code", b"exit_code", "output_directories", b"output_directories", "output_directory_symlinks", b"output_directory_symlinks", "output_file_symlinks", b"output_file_symlinks", "output_files", b"output_files", "output_symlinks", b"output_symlinks", "stderr_digest", b"stderr_digest", "stderr_raw", b"stderr_raw", "stdout_digest", b"stdout_digest", "stdout_raw", b"stdout_raw"]) -> None: ...

global___ActionResult = ActionResult

@typing_extensions.final
class OutputFile(google.protobuf.message.Message):
    """An `OutputFile` is similar to a
    [FileNode][build.bazel.remote.execution.v2.FileNode], but it is used as an
    output in an `ActionResult`. It allows a full file path rather than
    only a name.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    IS_EXECUTABLE_FIELD_NUMBER: builtins.int
    CONTENTS_FIELD_NUMBER: builtins.int
    NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    path: builtins.str
    """The full path of the file relative to the working directory, including the
    filename. The path separator is a forward slash `/`. Since this is a
    relative path, it MUST NOT begin with a leading forward slash.
    """
    @property
    def digest(self) -> global___Digest:
        """The digest of the file's content."""
    is_executable: builtins.bool
    """True if file is executable, false otherwise."""
    contents: builtins.bytes
    """The contents of the file if inlining was requested. The server SHOULD NOT inline
    file contents unless requested by the client in the
    [GetActionResultRequest][build.bazel.remote.execution.v2.GetActionResultRequest]
    message. The server MAY omit inlining, even if requested, and MUST do so if inlining
    would cause the response to exceed message size limits.
    Clients SHOULD NOT populate this field when uploading to the cache.
    """
    @property
    def node_properties(self) -> global___NodeProperties: ...
    def __init__(
        self,
        *,
        path: builtins.str = ...,
        digest: global___Digest | None = ...,
        is_executable: builtins.bool = ...,
        contents: builtins.bytes = ...,
        node_properties: global___NodeProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["digest", b"digest", "node_properties", b"node_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["contents", b"contents", "digest", b"digest", "is_executable", b"is_executable", "node_properties", b"node_properties", "path", b"path"]) -> None: ...

global___OutputFile = OutputFile

@typing_extensions.final
class Tree(google.protobuf.message.Message):
    """A `Tree` contains all the
    [Directory][build.bazel.remote.execution.v2.Directory] protos in a
    single directory Merkle tree, compressed into one message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROOT_FIELD_NUMBER: builtins.int
    CHILDREN_FIELD_NUMBER: builtins.int
    @property
    def root(self) -> global___Directory:
        """The root directory in the tree."""
    @property
    def children(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Directory]:
        """All the child directories: the directories referred to by the root and,
        recursively, all its children. In order to reconstruct the directory tree,
        the client must take the digests of each of the child directories and then
        build up a tree starting from the `root`.
        Servers SHOULD ensure that these are ordered consistently such that two
        actions producing equivalent output directories on the same server
        implementation also produce Tree messages with matching digests.
        """
    def __init__(
        self,
        *,
        root: global___Directory | None = ...,
        children: collections.abc.Iterable[global___Directory] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["root", b"root"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["children", b"children", "root", b"root"]) -> None: ...

global___Tree = Tree

@typing_extensions.final
class OutputDirectory(google.protobuf.message.Message):
    """An `OutputDirectory` is the output in an `ActionResult` corresponding to a
    directory's full contents rather than a single file.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    TREE_DIGEST_FIELD_NUMBER: builtins.int
    IS_TOPOLOGICALLY_SORTED_FIELD_NUMBER: builtins.int
    ROOT_DIRECTORY_DIGEST_FIELD_NUMBER: builtins.int
    path: builtins.str
    """The full path of the directory relative to the working directory. The path
    separator is a forward slash `/`. Since this is a relative path, it MUST
    NOT begin with a leading forward slash. The empty string value is allowed,
    and it denotes the entire working directory.
    """
    @property
    def tree_digest(self) -> global___Digest:
        """The digest of the encoded
        [Tree][build.bazel.remote.execution.v2.Tree] proto containing the
        directory's contents.
        """
    is_topologically_sorted: builtins.bool
    """If set, consumers MAY make the following assumptions about the
    directories contained in the the Tree, so that it may be
    instantiated on a local file system by scanning through it
    sequentially:

    - All directories with the same binary representation are stored
      exactly once.
    - All directories, apart from the root directory, are referenced by
      at least one parent directory.
    - Directories are stored in topological order, with parents being
      stored before the child. The root directory is thus the first to
      be stored.

    Additionally, the Tree MUST be encoded as a stream of records,
    where each record has the following format:

    - A tag byte, having one of the following two values:
      - (1 << 3) | 2 == 0x0a: First record (the root directory).
      - (2 << 3) | 2 == 0x12: Any subsequent records (child directories).
    - The size of the directory, encoded as a base 128 varint.
    - The contents of the directory, encoded as a binary serialized
      Protobuf message.

    This encoding is a subset of the Protobuf wire format of the Tree
    message. As it is only permitted to store data associated with
    field numbers 1 and 2, the tag MUST be encoded as a single byte.
    More details on the Protobuf wire format can be found here:
    https://developers.google.com/protocol-buffers/docs/encoding

    It is recommended that implementations using this feature construct
    Tree objects manually using the specification given above, as
    opposed to using a Protobuf library to marshal a full Tree message.
    As individual Directory messages already need to be marshaled to
    compute their digests, constructing the Tree object manually avoids
    redundant marshaling.
    """
    @property
    def root_directory_digest(self) -> global___Digest:
        """The digest of the encoded
        [Directory][build.bazel.remote.execution.v2.Directory] proto
        containing the contents the directory's root.

        If both `tree_digest` and `root_directory_digest` are set, this
        field MUST match the digest of the root directory contained in the
        Tree message.
        """
    def __init__(
        self,
        *,
        path: builtins.str = ...,
        tree_digest: global___Digest | None = ...,
        is_topologically_sorted: builtins.bool = ...,
        root_directory_digest: global___Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["root_directory_digest", b"root_directory_digest", "tree_digest", b"tree_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_topologically_sorted", b"is_topologically_sorted", "path", b"path", "root_directory_digest", b"root_directory_digest", "tree_digest", b"tree_digest"]) -> None: ...

global___OutputDirectory = OutputDirectory

@typing_extensions.final
class OutputSymlink(google.protobuf.message.Message):
    """An `OutputSymlink` is similar to a
    [Symlink][build.bazel.remote.execution.v2.SymlinkNode], but it is used as an
    output in an `ActionResult`.

    `OutputSymlink` is binary-compatible with `SymlinkNode`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_FIELD_NUMBER: builtins.int
    TARGET_FIELD_NUMBER: builtins.int
    NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    path: builtins.str
    """The full path of the symlink relative to the working directory, including the
    filename. The path separator is a forward slash `/`. Since this is a
    relative path, it MUST NOT begin with a leading forward slash.
    """
    target: builtins.str
    """The target path of the symlink. The path separator is a forward slash `/`.
    The target path can be relative to the parent directory of the symlink or
    it can be an absolute path starting with `/`. Support for absolute paths
    can be checked using the [Capabilities][build.bazel.remote.execution.v2.Capabilities]
    API. `..` components are allowed anywhere in the target path.
    """
    @property
    def node_properties(self) -> global___NodeProperties: ...
    def __init__(
        self,
        *,
        path: builtins.str = ...,
        target: builtins.str = ...,
        node_properties: global___NodeProperties | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["node_properties", b"node_properties"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["node_properties", b"node_properties", "path", b"path", "target", b"target"]) -> None: ...

global___OutputSymlink = OutputSymlink

@typing_extensions.final
class ExecutionPolicy(google.protobuf.message.Message):
    """An `ExecutionPolicy` can be used to control the scheduling of the action."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIORITY_FIELD_NUMBER: builtins.int
    priority: builtins.int
    """The priority (relative importance) of this action. Generally, a lower value
    means that the action should be run sooner than actions having a greater
    priority value, but the interpretation of a given value is server-
    dependent. A priority of 0 means the *default* priority. Priorities may be
    positive or negative, and such actions should run later or sooner than
    actions having the default priority, respectively. The particular semantics
    of this field is up to the server. In particular, every server will have
    their own supported range of priorities, and will decide how these map into
    scheduling policy.
    """
    def __init__(
        self,
        *,
        priority: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["priority", b"priority"]) -> None: ...

global___ExecutionPolicy = ExecutionPolicy

@typing_extensions.final
class ResultsCachePolicy(google.protobuf.message.Message):
    """A `ResultsCachePolicy` is used for fine-grained control over how action
    outputs are stored in the CAS and Action Cache.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRIORITY_FIELD_NUMBER: builtins.int
    priority: builtins.int
    """The priority (relative importance) of this content in the overall cache.
    Generally, a lower value means a longer retention time or other advantage,
    but the interpretation of a given value is server-dependent. A priority of
    0 means a *default* value, decided by the server.

    The particular semantics of this field is up to the server. In particular,
    every server will have their own supported range of priorities, and will
    decide how these map into retention/eviction policy.
    """
    def __init__(
        self,
        *,
        priority: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["priority", b"priority"]) -> None: ...

global___ResultsCachePolicy = ResultsCachePolicy

@typing_extensions.final
class ExecuteRequest(google.protobuf.message.Message):
    """A request message for
    [Execution.Execute][build.bazel.remote.execution.v2.Execution.Execute].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    SKIP_CACHE_LOOKUP_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    EXECUTION_POLICY_FIELD_NUMBER: builtins.int
    RESULTS_CACHE_POLICY_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    skip_cache_lookup: builtins.bool
    """If true, the action will be executed even if its result is already
    present in the [ActionCache][build.bazel.remote.execution.v2.ActionCache].
    The execution is still allowed to be merged with other in-flight executions
    of the same action, however - semantically, the service MUST only guarantee
    that the results of an execution with this field set were not visible
    before the corresponding execution request was sent.
    Note that actions from execution requests setting this field set are still
    eligible to be entered into the action cache upon completion, and services
    SHOULD overwrite any existing entries that may exist. This allows
    skip_cache_lookup requests to be used as a mechanism for replacing action
    cache entries that reference outputs no longer available or that are
    poisoned in any way.
    If false, the result may be served from the action cache.
    """
    @property
    def action_digest(self) -> global___Digest:
        """The digest of the [Action][build.bazel.remote.execution.v2.Action] to
        execute.
        """
    @property
    def execution_policy(self) -> global___ExecutionPolicy:
        """An optional policy for execution of the action.
        The server will have a default policy if this is not provided.
        """
    @property
    def results_cache_policy(self) -> global___ResultsCachePolicy:
        """An optional policy for the results of this execution in the remote cache.
        The server will have a default policy if this is not provided.
        This may be applied to both the ActionResult and the associated blobs.
        """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function that was used to compute the action digest.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the action digest hash and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        skip_cache_lookup: builtins.bool = ...,
        action_digest: global___Digest | None = ...,
        execution_policy: global___ExecutionPolicy | None = ...,
        results_cache_policy: global___ResultsCachePolicy | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "execution_policy", b"execution_policy", "results_cache_policy", b"results_cache_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "digest_function", b"digest_function", "execution_policy", b"execution_policy", "instance_name", b"instance_name", "results_cache_policy", b"results_cache_policy", "skip_cache_lookup", b"skip_cache_lookup"]) -> None: ...

global___ExecuteRequest = ExecuteRequest

@typing_extensions.final
class LogFile(google.protobuf.message.Message):
    """A `LogFile` is a log stored in the CAS."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_FIELD_NUMBER: builtins.int
    HUMAN_READABLE_FIELD_NUMBER: builtins.int
    @property
    def digest(self) -> global___Digest:
        """The digest of the log contents."""
    human_readable: builtins.bool
    """This is a hint as to the purpose of the log, and is set to true if the log
    is human-readable text that can be usefully displayed to a user, and false
    otherwise. For instance, if a command-line client wishes to print the
    server logs to the terminal for a failed action, this allows it to avoid
    displaying a binary file.
    """
    def __init__(
        self,
        *,
        digest: global___Digest | None = ...,
        human_readable: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["digest", b"digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "human_readable", b"human_readable"]) -> None: ...

global___LogFile = LogFile

@typing_extensions.final
class ExecuteResponse(google.protobuf.message.Message):
    """The response message for
    [Execution.Execute][build.bazel.remote.execution.v2.Execution.Execute],
    which will be contained in the [response
    field][google.longrunning.Operation.response] of the
    [Operation][google.longrunning.Operation].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ServerLogsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___LogFile: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___LogFile | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    RESULT_FIELD_NUMBER: builtins.int
    CACHED_RESULT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SERVER_LOGS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def result(self) -> global___ActionResult:
        """The result of the action."""
    cached_result: builtins.bool
    """True if the result was served from cache, false if it was executed."""
    @property
    def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
        """If the status has a code other than `OK`, it indicates that the action did
        not finish execution. For example, if the operation times out during
        execution, the status will have a `DEADLINE_EXCEEDED` code. Servers MUST
        use this field for errors in execution, rather than the error field on the
        `Operation` object.

        If the status code is other than `OK`, then the result MUST NOT be cached.
        For an error status, the `result` field is optional; the server may
        populate the output-, stdout-, and stderr-related fields if it has any
        information available, such as the stdout and stderr of a timed-out action.
        """
    @property
    def server_logs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___LogFile]:
        """An optional list of additional log outputs the server wishes to provide. A
        server can use this to return execution-specific logs however it wishes.
        This is intended primarily to make it easier for users to debug issues that
        may be outside of the actual job execution, such as by identifying the
        worker executing the action or by providing logs from the worker's setup
        phase. The keys SHOULD be human readable so that a client can display them
        to a user.
        """
    message: builtins.str
    """Freeform informational message with details on the execution of the action
    that may be displayed to the user upon failure or when requested explicitly.
    """
    def __init__(
        self,
        *,
        result: global___ActionResult | None = ...,
        cached_result: builtins.bool = ...,
        status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        server_logs: collections.abc.Mapping[builtins.str, global___LogFile] | None = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["result", b"result", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cached_result", b"cached_result", "message", b"message", "result", b"result", "server_logs", b"server_logs", "status", b"status"]) -> None: ...

global___ExecuteResponse = ExecuteResponse

@typing_extensions.final
class ExecutionStage(google.protobuf.message.Message):
    """The current stage of action execution.

    Even though these stages are numbered according to the order in which
    they generally occur, there is no requirement that the remote
    execution system reports events along this order. For example, an
    operation MAY transition from the EXECUTING stage back to QUEUED
    in case the hardware on which the operation executes fails.

    If and only if the remote execution system reports that an operation
    has reached the COMPLETED stage, it MUST set the [done
    field][google.longrunning.Operation.done] of the
    [Operation][google.longrunning.Operation] and terminate the stream.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Value:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ValueEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ExecutionStage._Value.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: ExecutionStage._Value.ValueType  # 0
        """Invalid value."""
        CACHE_CHECK: ExecutionStage._Value.ValueType  # 1
        """Checking the result against the cache."""
        QUEUED: ExecutionStage._Value.ValueType  # 2
        """Currently idle, awaiting a free machine to execute."""
        EXECUTING: ExecutionStage._Value.ValueType  # 3
        """Currently being executed by a worker."""
        COMPLETED: ExecutionStage._Value.ValueType  # 4
        """Finished execution."""

    class Value(_Value, metaclass=_ValueEnumTypeWrapper): ...
    UNKNOWN: ExecutionStage.Value.ValueType  # 0
    """Invalid value."""
    CACHE_CHECK: ExecutionStage.Value.ValueType  # 1
    """Checking the result against the cache."""
    QUEUED: ExecutionStage.Value.ValueType  # 2
    """Currently idle, awaiting a free machine to execute."""
    EXECUTING: ExecutionStage.Value.ValueType  # 3
    """Currently being executed by a worker."""
    COMPLETED: ExecutionStage.Value.ValueType  # 4
    """Finished execution."""

    def __init__(
        self,
    ) -> None: ...

global___ExecutionStage = ExecutionStage

@typing_extensions.final
class ExecuteOperationMetadata(google.protobuf.message.Message):
    """Metadata about an ongoing
    [execution][build.bazel.remote.execution.v2.Execution.Execute], which
    will be contained in the [metadata
    field][google.longrunning.Operation.response] of the
    [Operation][google.longrunning.Operation].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STAGE_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    STDOUT_STREAM_NAME_FIELD_NUMBER: builtins.int
    STDERR_STREAM_NAME_FIELD_NUMBER: builtins.int
    PARTIAL_EXECUTION_METADATA_FIELD_NUMBER: builtins.int
    stage: global___ExecutionStage.Value.ValueType
    """The current stage of execution."""
    @property
    def action_digest(self) -> global___Digest:
        """The digest of the [Action][build.bazel.remote.execution.v2.Action]
        being executed.
        """
    stdout_stream_name: builtins.str
    """If set, the client can use this resource name with
    [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
    standard output from the endpoint hosting streamed responses.
    """
    stderr_stream_name: builtins.str
    """If set, the client can use this resource name with
    [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
    standard error from the endpoint hosting streamed responses.
    """
    @property
    def partial_execution_metadata(self) -> global___ExecutedActionMetadata:
        """The client can read this field to view details about the ongoing
        execution.
        """
    def __init__(
        self,
        *,
        stage: global___ExecutionStage.Value.ValueType = ...,
        action_digest: global___Digest | None = ...,
        stdout_stream_name: builtins.str = ...,
        stderr_stream_name: builtins.str = ...,
        partial_execution_metadata: global___ExecutedActionMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "partial_execution_metadata", b"partial_execution_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "partial_execution_metadata", b"partial_execution_metadata", "stage", b"stage", "stderr_stream_name", b"stderr_stream_name", "stdout_stream_name", b"stdout_stream_name"]) -> None: ...

global___ExecuteOperationMetadata = ExecuteOperationMetadata

@typing_extensions.final
class WaitExecutionRequest(google.protobuf.message.Message):
    """A request message for
    [WaitExecution][build.bazel.remote.execution.v2.Execution.WaitExecution].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the [Operation][google.longrunning.Operation]
    returned by [Execute][build.bazel.remote.execution.v2.Execution.Execute].
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___WaitExecutionRequest = WaitExecutionRequest

@typing_extensions.final
class GetActionResultRequest(google.protobuf.message.Message):
    """A request message for
    [ActionCache.GetActionResult][build.bazel.remote.execution.v2.ActionCache.GetActionResult].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    INLINE_STDOUT_FIELD_NUMBER: builtins.int
    INLINE_STDERR_FIELD_NUMBER: builtins.int
    INLINE_OUTPUT_FILES_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def action_digest(self) -> global___Digest:
        """The digest of the [Action][build.bazel.remote.execution.v2.Action]
        whose result is requested.
        """
    inline_stdout: builtins.bool
    """A hint to the server to request inlining stdout in the
    [ActionResult][build.bazel.remote.execution.v2.ActionResult] message.
    """
    inline_stderr: builtins.bool
    """A hint to the server to request inlining stderr in the
    [ActionResult][build.bazel.remote.execution.v2.ActionResult] message.
    """
    @property
    def inline_output_files(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A hint to the server to inline the contents of the listed output files.
        Each path needs to exactly match one file path in either `output_paths` or
        `output_files` (DEPRECATED since v2.1) in the
        [Command][build.bazel.remote.execution.v2.Command] message.
        """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function that was used to compute the action digest.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the action digest hash and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        action_digest: global___Digest | None = ...,
        inline_stdout: builtins.bool = ...,
        inline_stderr: builtins.bool = ...,
        inline_output_files: collections.abc.Iterable[builtins.str] | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "digest_function", b"digest_function", "inline_output_files", b"inline_output_files", "inline_stderr", b"inline_stderr", "inline_stdout", b"inline_stdout", "instance_name", b"instance_name"]) -> None: ...

global___GetActionResultRequest = GetActionResultRequest

@typing_extensions.final
class UpdateActionResultRequest(google.protobuf.message.Message):
    """A request message for
    [ActionCache.UpdateActionResult][build.bazel.remote.execution.v2.ActionCache.UpdateActionResult].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    ACTION_DIGEST_FIELD_NUMBER: builtins.int
    ACTION_RESULT_FIELD_NUMBER: builtins.int
    RESULTS_CACHE_POLICY_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def action_digest(self) -> global___Digest:
        """The digest of the [Action][build.bazel.remote.execution.v2.Action]
        whose result is being uploaded.
        """
    @property
    def action_result(self) -> global___ActionResult:
        """The [ActionResult][build.bazel.remote.execution.v2.ActionResult]
        to store in the cache.
        """
    @property
    def results_cache_policy(self) -> global___ResultsCachePolicy:
        """An optional policy for the results of this execution in the remote cache.
        The server will have a default policy if this is not provided.
        This may be applied to both the ActionResult and the associated blobs.
        """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function that was used to compute the action digest.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the action digest hash and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        action_digest: global___Digest | None = ...,
        action_result: global___ActionResult | None = ...,
        results_cache_policy: global___ResultsCachePolicy | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "action_result", b"action_result", "results_cache_policy", b"results_cache_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_digest", b"action_digest", "action_result", b"action_result", "digest_function", b"digest_function", "instance_name", b"instance_name", "results_cache_policy", b"results_cache_policy"]) -> None: ...

global___UpdateActionResultRequest = UpdateActionResultRequest

@typing_extensions.final
class FindMissingBlobsRequest(google.protobuf.message.Message):
    """A request message for
    [ContentAddressableStorage.FindMissingBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    BLOB_DIGESTS_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def blob_digests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Digest]:
        """A list of the blobs to check. All digests MUST use the same digest
        function.
        """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function of the blobs whose existence is checked.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the blob digest hashes and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        blob_digests: collections.abc.Iterable[global___Digest] | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["blob_digests", b"blob_digests", "digest_function", b"digest_function", "instance_name", b"instance_name"]) -> None: ...

global___FindMissingBlobsRequest = FindMissingBlobsRequest

@typing_extensions.final
class FindMissingBlobsResponse(google.protobuf.message.Message):
    """A response message for
    [ContentAddressableStorage.FindMissingBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.FindMissingBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MISSING_BLOB_DIGESTS_FIELD_NUMBER: builtins.int
    @property
    def missing_blob_digests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Digest]:
        """A list of the blobs requested *not* present in the storage."""
    def __init__(
        self,
        *,
        missing_blob_digests: collections.abc.Iterable[global___Digest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["missing_blob_digests", b"missing_blob_digests"]) -> None: ...

global___FindMissingBlobsResponse = FindMissingBlobsResponse

@typing_extensions.final
class BatchUpdateBlobsRequest(google.protobuf.message.Message):
    """A request message for
    [ContentAddressableStorage.BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Request(google.protobuf.message.Message):
        """A request corresponding to a single blob that the client wants to upload."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DIGEST_FIELD_NUMBER: builtins.int
        DATA_FIELD_NUMBER: builtins.int
        COMPRESSOR_FIELD_NUMBER: builtins.int
        @property
        def digest(self) -> global___Digest:
            """The digest of the blob. This MUST be the digest of `data`. All
            digests MUST use the same digest function.
            """
        data: builtins.bytes
        """The raw binary data."""
        compressor: global___Compressor.Value.ValueType
        """The format of `data`. Must be `IDENTITY`/unspecified, or one of the
        compressors advertised by the
        [CacheCapabilities.supported_batch_compressors][build.bazel.remote.execution.v2.CacheCapabilities.supported_batch_compressors]
        field.
        """
        def __init__(
            self,
            *,
            digest: global___Digest | None = ...,
            data: builtins.bytes = ...,
            compressor: global___Compressor.Value.ValueType = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["digest", b"digest"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["compressor", b"compressor", "data", b"data", "digest", b"digest"]) -> None: ...

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    REQUESTS_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def requests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchUpdateBlobsRequest.Request]:
        """The individual upload requests."""
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function that was used to compute the digests of the
    blobs being uploaded.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the blob digest hashes and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        requests: collections.abc.Iterable[global___BatchUpdateBlobsRequest.Request] | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest_function", b"digest_function", "instance_name", b"instance_name", "requests", b"requests"]) -> None: ...

global___BatchUpdateBlobsRequest = BatchUpdateBlobsRequest

@typing_extensions.final
class BatchUpdateBlobsResponse(google.protobuf.message.Message):
    """A response message for
    [ContentAddressableStorage.BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Response(google.protobuf.message.Message):
        """A response corresponding to a single blob that the client tried to upload."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DIGEST_FIELD_NUMBER: builtins.int
        STATUS_FIELD_NUMBER: builtins.int
        @property
        def digest(self) -> global___Digest:
            """The blob digest to which this response corresponds."""
        @property
        def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
            """The result of attempting to upload that blob."""
        def __init__(
            self,
            *,
            digest: global___Digest | None = ...,
            status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["digest", b"digest", "status", b"status"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["digest", b"digest", "status", b"status"]) -> None: ...

    RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def responses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchUpdateBlobsResponse.Response]:
        """The responses to the requests."""
    def __init__(
        self,
        *,
        responses: collections.abc.Iterable[global___BatchUpdateBlobsResponse.Response] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["responses", b"responses"]) -> None: ...

global___BatchUpdateBlobsResponse = BatchUpdateBlobsResponse

@typing_extensions.final
class BatchReadBlobsRequest(google.protobuf.message.Message):
    """A request message for
    [ContentAddressableStorage.BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    DIGESTS_FIELD_NUMBER: builtins.int
    ACCEPTABLE_COMPRESSORS_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def digests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Digest]:
        """The individual blob digests. All digests MUST use the same digest
        function.
        """
    @property
    def acceptable_compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Compressor.Value.ValueType]:
        """A list of acceptable encodings for the returned inlined data, in no
        particular order. `IDENTITY` is always allowed even if not specified here.
        """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function of the blobs being requested.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the blob digest hashes and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        digests: collections.abc.Iterable[global___Digest] | None = ...,
        acceptable_compressors: collections.abc.Iterable[global___Compressor.Value.ValueType] | None = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["acceptable_compressors", b"acceptable_compressors", "digest_function", b"digest_function", "digests", b"digests", "instance_name", b"instance_name"]) -> None: ...

global___BatchReadBlobsRequest = BatchReadBlobsRequest

@typing_extensions.final
class BatchReadBlobsResponse(google.protobuf.message.Message):
    """A response message for
    [ContentAddressableStorage.BatchReadBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchReadBlobs].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Response(google.protobuf.message.Message):
        """A response corresponding to a single blob that the client tried to download."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DIGEST_FIELD_NUMBER: builtins.int
        DATA_FIELD_NUMBER: builtins.int
        COMPRESSOR_FIELD_NUMBER: builtins.int
        STATUS_FIELD_NUMBER: builtins.int
        @property
        def digest(self) -> global___Digest:
            """The digest to which this response corresponds."""
        data: builtins.bytes
        """The raw binary data."""
        compressor: global___Compressor.Value.ValueType
        """The format the data is encoded in. MUST be `IDENTITY`/unspecified,
        or one of the acceptable compressors specified in the `BatchReadBlobsRequest`.
        """
        @property
        def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
            """The result of attempting to download that blob."""
        def __init__(
            self,
            *,
            digest: global___Digest | None = ...,
            data: builtins.bytes = ...,
            compressor: global___Compressor.Value.ValueType = ...,
            status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["digest", b"digest", "status", b"status"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["compressor", b"compressor", "data", b"data", "digest", b"digest", "status", b"status"]) -> None: ...

    RESPONSES_FIELD_NUMBER: builtins.int
    @property
    def responses(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchReadBlobsResponse.Response]:
        """The responses to the requests."""
    def __init__(
        self,
        *,
        responses: collections.abc.Iterable[global___BatchReadBlobsResponse.Response] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["responses", b"responses"]) -> None: ...

global___BatchReadBlobsResponse = BatchReadBlobsResponse

@typing_extensions.final
class GetTreeRequest(google.protobuf.message.Message):
    """A request message for
    [ContentAddressableStorage.GetTree][build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    ROOT_DIGEST_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def root_digest(self) -> global___Digest:
        """The digest of the root, which must be an encoded
        [Directory][build.bazel.remote.execution.v2.Directory] message
        stored in the
        [ContentAddressableStorage][build.bazel.remote.execution.v2.ContentAddressableStorage].
        """
    page_size: builtins.int
    """A maximum page size to request. If present, the server will request no more
    than this many items. Regardless of whether a page size is specified, the
    server may place its own limit on the number of items to be returned and
    require the client to retrieve more items using a subsequent request.
    """
    page_token: builtins.str
    """A page token, which must be a value received in a previous
    [GetTreeResponse][build.bazel.remote.execution.v2.GetTreeResponse].
    If present, the server will use that token as an offset, returning only
    that page and the ones that succeed it.
    """
    digest_function: global___DigestFunction.Value.ValueType
    """The digest function that was used to compute the digest of the root
    directory.

    If the digest function used is one of MD5, MURMUR3, SHA1, SHA256,
    SHA384, SHA512, or VSO, the client MAY leave this field unset. In
    that case the server SHOULD infer the digest function using the
    length of the root digest hash and the digest functions announced
    in the server's capabilities.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        root_digest: global___Digest | None = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        digest_function: global___DigestFunction.Value.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["root_digest", b"root_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest_function", b"digest_function", "instance_name", b"instance_name", "page_size", b"page_size", "page_token", b"page_token", "root_digest", b"root_digest"]) -> None: ...

global___GetTreeRequest = GetTreeRequest

@typing_extensions.final
class GetTreeResponse(google.protobuf.message.Message):
    """A response message for
    [ContentAddressableStorage.GetTree][build.bazel.remote.execution.v2.ContentAddressableStorage.GetTree].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIRECTORIES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    @property
    def directories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Directory]:
        """The directories descended from the requested root."""
    next_page_token: builtins.str
    """If present, signifies that there are more results which the client can
    retrieve by passing this as the page_token in a subsequent
    [request][build.bazel.remote.execution.v2.GetTreeRequest].
    If empty, signifies that this is the last page of results.
    """
    def __init__(
        self,
        *,
        directories: collections.abc.Iterable[global___Directory] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["directories", b"directories", "next_page_token", b"next_page_token"]) -> None: ...

global___GetTreeResponse = GetTreeResponse

@typing_extensions.final
class GetCapabilitiesRequest(google.protobuf.message.Message):
    """A request message for
    [Capabilities.GetCapabilities][build.bazel.remote.execution.v2.Capabilities.GetCapabilities].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name"]) -> None: ...

global___GetCapabilitiesRequest = GetCapabilitiesRequest

@typing_extensions.final
class ServerCapabilities(google.protobuf.message.Message):
    """A response message for
    [Capabilities.GetCapabilities][build.bazel.remote.execution.v2.Capabilities.GetCapabilities].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CACHE_CAPABILITIES_FIELD_NUMBER: builtins.int
    EXECUTION_CAPABILITIES_FIELD_NUMBER: builtins.int
    DEPRECATED_API_VERSION_FIELD_NUMBER: builtins.int
    LOW_API_VERSION_FIELD_NUMBER: builtins.int
    HIGH_API_VERSION_FIELD_NUMBER: builtins.int
    @property
    def cache_capabilities(self) -> global___CacheCapabilities:
        """Capabilities of the remote cache system."""
    @property
    def execution_capabilities(self) -> global___ExecutionCapabilities:
        """Capabilities of the remote execution system."""
    @property
    def deprecated_api_version(self) -> buildgrid._protos.build.bazel.semver.semver_pb2.SemVer:
        """Earliest RE API version supported, including deprecated versions."""
    @property
    def low_api_version(self) -> buildgrid._protos.build.bazel.semver.semver_pb2.SemVer:
        """Earliest non-deprecated RE API version supported."""
    @property
    def high_api_version(self) -> buildgrid._protos.build.bazel.semver.semver_pb2.SemVer:
        """Latest RE API version supported."""
    def __init__(
        self,
        *,
        cache_capabilities: global___CacheCapabilities | None = ...,
        execution_capabilities: global___ExecutionCapabilities | None = ...,
        deprecated_api_version: buildgrid._protos.build.bazel.semver.semver_pb2.SemVer | None = ...,
        low_api_version: buildgrid._protos.build.bazel.semver.semver_pb2.SemVer | None = ...,
        high_api_version: buildgrid._protos.build.bazel.semver.semver_pb2.SemVer | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cache_capabilities", b"cache_capabilities", "deprecated_api_version", b"deprecated_api_version", "execution_capabilities", b"execution_capabilities", "high_api_version", b"high_api_version", "low_api_version", b"low_api_version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cache_capabilities", b"cache_capabilities", "deprecated_api_version", b"deprecated_api_version", "execution_capabilities", b"execution_capabilities", "high_api_version", b"high_api_version", "low_api_version", b"low_api_version"]) -> None: ...

global___ServerCapabilities = ServerCapabilities

@typing_extensions.final
class DigestFunction(google.protobuf.message.Message):
    """The digest function used for converting values into keys for CAS and Action
    Cache.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Value:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ValueEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DigestFunction._Value.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: DigestFunction._Value.ValueType  # 0
        """It is an error for the server to return this value."""
        SHA256: DigestFunction._Value.ValueType  # 1
        """The SHA-256 digest function."""
        SHA1: DigestFunction._Value.ValueType  # 2
        """The SHA-1 digest function."""
        MD5: DigestFunction._Value.ValueType  # 3
        """The MD5 digest function."""
        VSO: DigestFunction._Value.ValueType  # 4
        """The Microsoft "VSO-Hash" paged SHA256 digest function.
        See https://github.com/microsoft/BuildXL/blob/master/Documentation/Specs/PagedHash.md .
        """
        SHA384: DigestFunction._Value.ValueType  # 5
        """The SHA-384 digest function."""
        SHA512: DigestFunction._Value.ValueType  # 6
        """The SHA-512 digest function."""
        MURMUR3: DigestFunction._Value.ValueType  # 7
        """Murmur3 128-bit digest function, x64 variant. Note that this is not a
        cryptographic hash function and its collision properties are not strongly guaranteed.
        See https://github.com/aappleby/smhasher/wiki/MurmurHash3 .
        """
        SHA256TREE: DigestFunction._Value.ValueType  # 8
        """The SHA-256 digest function, modified to use a Merkle tree for
        large objects. This permits implementations to store large blobs
        as a decomposed sequence of 2^j sized chunks, where j >= 10,
        while being able to validate integrity at the chunk level.

        Furthermore, on systems that do not offer dedicated instructions
        for computing SHA-256 hashes (e.g., the Intel SHA and ARMv8
        cryptographic extensions), SHA256TREE hashes can be computed more
        efficiently than plain SHA-256 hashes by using generic SIMD
        extensions, such as Intel AVX2 or ARM NEON.

        SHA256TREE hashes are computed as follows:

        - For blobs that are 1024 bytes or smaller, the hash is computed
          using the regular SHA-256 digest function.

        - For blobs that are more than 1024 bytes in size, the hash is
          computed as follows:

          1. The blob is partitioned into a left (leading) and right
             (trailing) blob. These blobs have lengths m and n
             respectively, where m = 2^k and 0 < n <= m.

          2. Hashes of the left and right blob, Hash(left) and
             Hash(right) respectively, are computed by recursively
             applying the SHA256TREE algorithm.

          3. A single invocation is made to the SHA-256 block cipher with
             the following parameters:

                 M = Hash(left) || Hash(right)
                 H = {
                     0xcbbb9d5d, 0x629a292a, 0x9159015a, 0x152fecd8,
                     0x67332667, 0x8eb44a87, 0xdb0c2e0d, 0x47b5481d,
                 }

             The values of H are the leading fractional parts of the
             square roots of the 9th to the 16th prime number (23 to 53).
             This differs from plain SHA-256, where the first eight prime
             numbers (2 to 19) are used, thereby preventing trivial hash
             collisions between small and large objects.

          4. The hash of the full blob can then be obtained by
             concatenating the outputs of the block cipher:

                 Hash(blob) = a || b || c || d || e || f || g || h

             Addition of the original values of H, as normally done
             through the use of the Davies-Meyer structure, is not
             performed. This isn't necessary, as the block cipher is only
             invoked once.

        Test vectors of this digest function can be found in the
        accompanying sha256tree_test_vectors.txt file.
        """
        BLAKE3: DigestFunction._Value.ValueType  # 9
        """The BLAKE3 hash function.
        See https://github.com/BLAKE3-team/BLAKE3.
        """

    class Value(_Value, metaclass=_ValueEnumTypeWrapper): ...
    UNKNOWN: DigestFunction.Value.ValueType  # 0
    """It is an error for the server to return this value."""
    SHA256: DigestFunction.Value.ValueType  # 1
    """The SHA-256 digest function."""
    SHA1: DigestFunction.Value.ValueType  # 2
    """The SHA-1 digest function."""
    MD5: DigestFunction.Value.ValueType  # 3
    """The MD5 digest function."""
    VSO: DigestFunction.Value.ValueType  # 4
    """The Microsoft "VSO-Hash" paged SHA256 digest function.
    See https://github.com/microsoft/BuildXL/blob/master/Documentation/Specs/PagedHash.md .
    """
    SHA384: DigestFunction.Value.ValueType  # 5
    """The SHA-384 digest function."""
    SHA512: DigestFunction.Value.ValueType  # 6
    """The SHA-512 digest function."""
    MURMUR3: DigestFunction.Value.ValueType  # 7
    """Murmur3 128-bit digest function, x64 variant. Note that this is not a
    cryptographic hash function and its collision properties are not strongly guaranteed.
    See https://github.com/aappleby/smhasher/wiki/MurmurHash3 .
    """
    SHA256TREE: DigestFunction.Value.ValueType  # 8
    """The SHA-256 digest function, modified to use a Merkle tree for
    large objects. This permits implementations to store large blobs
    as a decomposed sequence of 2^j sized chunks, where j >= 10,
    while being able to validate integrity at the chunk level.

    Furthermore, on systems that do not offer dedicated instructions
    for computing SHA-256 hashes (e.g., the Intel SHA and ARMv8
    cryptographic extensions), SHA256TREE hashes can be computed more
    efficiently than plain SHA-256 hashes by using generic SIMD
    extensions, such as Intel AVX2 or ARM NEON.

    SHA256TREE hashes are computed as follows:

    - For blobs that are 1024 bytes or smaller, the hash is computed
      using the regular SHA-256 digest function.

    - For blobs that are more than 1024 bytes in size, the hash is
      computed as follows:

      1. The blob is partitioned into a left (leading) and right
         (trailing) blob. These blobs have lengths m and n
         respectively, where m = 2^k and 0 < n <= m.

      2. Hashes of the left and right blob, Hash(left) and
         Hash(right) respectively, are computed by recursively
         applying the SHA256TREE algorithm.

      3. A single invocation is made to the SHA-256 block cipher with
         the following parameters:

             M = Hash(left) || Hash(right)
             H = {
                 0xcbbb9d5d, 0x629a292a, 0x9159015a, 0x152fecd8,
                 0x67332667, 0x8eb44a87, 0xdb0c2e0d, 0x47b5481d,
             }

         The values of H are the leading fractional parts of the
         square roots of the 9th to the 16th prime number (23 to 53).
         This differs from plain SHA-256, where the first eight prime
         numbers (2 to 19) are used, thereby preventing trivial hash
         collisions between small and large objects.

      4. The hash of the full blob can then be obtained by
         concatenating the outputs of the block cipher:

             Hash(blob) = a || b || c || d || e || f || g || h

         Addition of the original values of H, as normally done
         through the use of the Davies-Meyer structure, is not
         performed. This isn't necessary, as the block cipher is only
         invoked once.

    Test vectors of this digest function can be found in the
    accompanying sha256tree_test_vectors.txt file.
    """
    BLAKE3: DigestFunction.Value.ValueType  # 9
    """The BLAKE3 hash function.
    See https://github.com/BLAKE3-team/BLAKE3.
    """

    def __init__(
        self,
    ) -> None: ...

global___DigestFunction = DigestFunction

@typing_extensions.final
class ActionCacheUpdateCapabilities(google.protobuf.message.Message):
    """Describes the server/instance capabilities for updating the action cache."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPDATE_ENABLED_FIELD_NUMBER: builtins.int
    update_enabled: builtins.bool
    def __init__(
        self,
        *,
        update_enabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["update_enabled", b"update_enabled"]) -> None: ...

global___ActionCacheUpdateCapabilities = ActionCacheUpdateCapabilities

@typing_extensions.final
class PriorityCapabilities(google.protobuf.message.Message):
    """Allowed values for priority in
    [ResultsCachePolicy][build.bazel.remoteexecution.v2.ResultsCachePolicy] and
    [ExecutionPolicy][build.bazel.remoteexecution.v2.ResultsCachePolicy]
    Used for querying both cache and execution valid priority ranges.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class PriorityRange(google.protobuf.message.Message):
        """Supported range of priorities, including boundaries."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MIN_PRIORITY_FIELD_NUMBER: builtins.int
        MAX_PRIORITY_FIELD_NUMBER: builtins.int
        min_priority: builtins.int
        """The minimum numeric value for this priority range, which represents the
        most urgent task or longest retained item.
        """
        max_priority: builtins.int
        """The maximum numeric value for this priority range, which represents the
        least urgent task or shortest retained item.
        """
        def __init__(
            self,
            *,
            min_priority: builtins.int = ...,
            max_priority: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["max_priority", b"max_priority", "min_priority", b"min_priority"]) -> None: ...

    PRIORITIES_FIELD_NUMBER: builtins.int
    @property
    def priorities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PriorityCapabilities.PriorityRange]: ...
    def __init__(
        self,
        *,
        priorities: collections.abc.Iterable[global___PriorityCapabilities.PriorityRange] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["priorities", b"priorities"]) -> None: ...

global___PriorityCapabilities = PriorityCapabilities

@typing_extensions.final
class SymlinkAbsolutePathStrategy(google.protobuf.message.Message):
    """Describes how the server treats absolute symlink targets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Value:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ValueEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SymlinkAbsolutePathStrategy._Value.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN: SymlinkAbsolutePathStrategy._Value.ValueType  # 0
        """Invalid value."""
        DISALLOWED: SymlinkAbsolutePathStrategy._Value.ValueType  # 1
        """Server will return an `INVALID_ARGUMENT` on input symlinks with absolute
        targets.
        If an action tries to create an output symlink with an absolute target, a
        `FAILED_PRECONDITION` will be returned.
        """
        ALLOWED: SymlinkAbsolutePathStrategy._Value.ValueType  # 2
        """Server will allow symlink targets to escape the input root tree, possibly
        resulting in non-hermetic builds.
        """

    class Value(_Value, metaclass=_ValueEnumTypeWrapper): ...
    UNKNOWN: SymlinkAbsolutePathStrategy.Value.ValueType  # 0
    """Invalid value."""
    DISALLOWED: SymlinkAbsolutePathStrategy.Value.ValueType  # 1
    """Server will return an `INVALID_ARGUMENT` on input symlinks with absolute
    targets.
    If an action tries to create an output symlink with an absolute target, a
    `FAILED_PRECONDITION` will be returned.
    """
    ALLOWED: SymlinkAbsolutePathStrategy.Value.ValueType  # 2
    """Server will allow symlink targets to escape the input root tree, possibly
    resulting in non-hermetic builds.
    """

    def __init__(
        self,
    ) -> None: ...

global___SymlinkAbsolutePathStrategy = SymlinkAbsolutePathStrategy

@typing_extensions.final
class Compressor(google.protobuf.message.Message):
    """Compression formats which may be supported."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Value:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ValueEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Compressor._Value.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IDENTITY: Compressor._Value.ValueType  # 0
        """No compression. Servers and clients MUST always support this, and do
        not need to advertise it.
        """
        ZSTD: Compressor._Value.ValueType  # 1
        """Zstandard compression."""
        DEFLATE: Compressor._Value.ValueType  # 2
        """RFC 1951 Deflate. This format is identical to what is used by ZIP
        files. Headers such as the one generated by gzip are not
        included.

        It is advised to use algorithms such as Zstandard instead, as
        those are faster and/or provide a better compression ratio.
        """
        BROTLI: Compressor._Value.ValueType  # 3
        """Brotli compression."""

    class Value(_Value, metaclass=_ValueEnumTypeWrapper): ...
    IDENTITY: Compressor.Value.ValueType  # 0
    """No compression. Servers and clients MUST always support this, and do
    not need to advertise it.
    """
    ZSTD: Compressor.Value.ValueType  # 1
    """Zstandard compression."""
    DEFLATE: Compressor.Value.ValueType  # 2
    """RFC 1951 Deflate. This format is identical to what is used by ZIP
    files. Headers such as the one generated by gzip are not
    included.

    It is advised to use algorithms such as Zstandard instead, as
    those are faster and/or provide a better compression ratio.
    """
    BROTLI: Compressor.Value.ValueType  # 3
    """Brotli compression."""

    def __init__(
        self,
    ) -> None: ...

global___Compressor = Compressor

@typing_extensions.final
class CacheCapabilities(google.protobuf.message.Message):
    """Capabilities of the remote cache system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_FUNCTIONS_FIELD_NUMBER: builtins.int
    ACTION_CACHE_UPDATE_CAPABILITIES_FIELD_NUMBER: builtins.int
    CACHE_PRIORITY_CAPABILITIES_FIELD_NUMBER: builtins.int
    MAX_BATCH_TOTAL_SIZE_BYTES_FIELD_NUMBER: builtins.int
    SYMLINK_ABSOLUTE_PATH_STRATEGY_FIELD_NUMBER: builtins.int
    SUPPORTED_COMPRESSORS_FIELD_NUMBER: builtins.int
    SUPPORTED_BATCH_UPDATE_COMPRESSORS_FIELD_NUMBER: builtins.int
    @property
    def digest_functions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___DigestFunction.Value.ValueType]:
        """All the digest functions supported by the remote cache.
        Remote cache may support multiple digest functions simultaneously.
        """
    @property
    def action_cache_update_capabilities(self) -> global___ActionCacheUpdateCapabilities:
        """Capabilities for updating the action cache."""
    @property
    def cache_priority_capabilities(self) -> global___PriorityCapabilities:
        """Supported cache priority range for both CAS and ActionCache."""
    max_batch_total_size_bytes: builtins.int
    """Maximum total size of blobs to be uploaded/downloaded using
    batch methods. A value of 0 means no limit is set, although
    in practice there will always be a message size limitation
    of the protocol in use, e.g. GRPC.
    """
    symlink_absolute_path_strategy: global___SymlinkAbsolutePathStrategy.Value.ValueType
    """Whether absolute symlink targets are supported."""
    @property
    def supported_compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Compressor.Value.ValueType]:
        """Compressors supported by the "compressed-blobs" bytestream resources.
        Servers MUST support identity/no-compression, even if it is not listed
        here.

        Note that this does not imply which if any compressors are supported by
        the server at the gRPC level.
        """
    @property
    def supported_batch_update_compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Compressor.Value.ValueType]:
        """Compressors supported for inlined data in
        [BatchUpdateBlobs][build.bazel.remote.execution.v2.ContentAddressableStorage.BatchUpdateBlobs]
        requests.
        """
    def __init__(
        self,
        *,
        digest_functions: collections.abc.Iterable[global___DigestFunction.Value.ValueType] | None = ...,
        action_cache_update_capabilities: global___ActionCacheUpdateCapabilities | None = ...,
        cache_priority_capabilities: global___PriorityCapabilities | None = ...,
        max_batch_total_size_bytes: builtins.int = ...,
        symlink_absolute_path_strategy: global___SymlinkAbsolutePathStrategy.Value.ValueType = ...,
        supported_compressors: collections.abc.Iterable[global___Compressor.Value.ValueType] | None = ...,
        supported_batch_update_compressors: collections.abc.Iterable[global___Compressor.Value.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["action_cache_update_capabilities", b"action_cache_update_capabilities", "cache_priority_capabilities", b"cache_priority_capabilities"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_cache_update_capabilities", b"action_cache_update_capabilities", "cache_priority_capabilities", b"cache_priority_capabilities", "digest_functions", b"digest_functions", "max_batch_total_size_bytes", b"max_batch_total_size_bytes", "supported_batch_update_compressors", b"supported_batch_update_compressors", "supported_compressors", b"supported_compressors", "symlink_absolute_path_strategy", b"symlink_absolute_path_strategy"]) -> None: ...

global___CacheCapabilities = CacheCapabilities

@typing_extensions.final
class ExecutionCapabilities(google.protobuf.message.Message):
    """Capabilities of the remote execution system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DIGEST_FUNCTION_FIELD_NUMBER: builtins.int
    EXEC_ENABLED_FIELD_NUMBER: builtins.int
    EXECUTION_PRIORITY_CAPABILITIES_FIELD_NUMBER: builtins.int
    SUPPORTED_NODE_PROPERTIES_FIELD_NUMBER: builtins.int
    DIGEST_FUNCTIONS_FIELD_NUMBER: builtins.int
    digest_function: global___DigestFunction.Value.ValueType
    """Legacy field for indicating which digest function is supported by the
    remote execution system. It MUST be set to a value other than UNKNOWN.
    Implementations should consider the repeated digest_functions field
    first, falling back to this singular field if digest_functions is unset.
    """
    exec_enabled: builtins.bool
    """Whether remote execution is enabled for the particular server/instance."""
    @property
    def execution_priority_capabilities(self) -> global___PriorityCapabilities:
        """Supported execution priority range."""
    @property
    def supported_node_properties(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Supported node properties."""
    @property
    def digest_functions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___DigestFunction.Value.ValueType]:
        """All the digest functions supported by the remote execution system.
        If this field is set, it MUST also contain digest_function.

        Even if the remote execution system announces support for multiple
        digest functions, individual execution requests may only reference
        CAS objects using a single digest function. For example, it is not
        permitted to execute actions having both MD5 and SHA-256 hashed
        files in their input root.

        The CAS objects referenced by action results generated by the
        remote execution system MUST use the same digest function as the
        one used to construct the action.
        """
    def __init__(
        self,
        *,
        digest_function: global___DigestFunction.Value.ValueType = ...,
        exec_enabled: builtins.bool = ...,
        execution_priority_capabilities: global___PriorityCapabilities | None = ...,
        supported_node_properties: collections.abc.Iterable[builtins.str] | None = ...,
        digest_functions: collections.abc.Iterable[global___DigestFunction.Value.ValueType] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["execution_priority_capabilities", b"execution_priority_capabilities"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["digest_function", b"digest_function", "digest_functions", b"digest_functions", "exec_enabled", b"exec_enabled", "execution_priority_capabilities", b"execution_priority_capabilities", "supported_node_properties", b"supported_node_properties"]) -> None: ...

global___ExecutionCapabilities = ExecutionCapabilities

@typing_extensions.final
class ToolDetails(google.protobuf.message.Message):
    """Details for the tool used to call the API."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_NAME_FIELD_NUMBER: builtins.int
    TOOL_VERSION_FIELD_NUMBER: builtins.int
    tool_name: builtins.str
    """Name of the tool, e.g. bazel."""
    tool_version: builtins.str
    """Version of the tool used for the request, e.g. 5.0.3."""
    def __init__(
        self,
        *,
        tool_name: builtins.str = ...,
        tool_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tool_name", b"tool_name", "tool_version", b"tool_version"]) -> None: ...

global___ToolDetails = ToolDetails

@typing_extensions.final
class RequestMetadata(google.protobuf.message.Message):
    """An optional Metadata to attach to any RPC request to tell the server about an
    external context of the request. The server may use this for logging or other
    purposes. To use it, the client attaches the header to the call using the
    canonical proto serialization:

    * name: `build.bazel.remote.execution.v2.requestmetadata-bin`
    * contents: the base64 encoded binary `RequestMetadata` message.
    Note: the gRPC library serializes binary headers encoded in base64 by
    default (https://github.com/grpc/grpc/blob/master/doc/PROTOCOL-HTTP2.md#requests).
    Therefore, if the gRPC library is used to pass/retrieve this
    metadata, the user may ignore the base64 encoding and assume it is simply
    serialized as a binary message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_DETAILS_FIELD_NUMBER: builtins.int
    ACTION_ID_FIELD_NUMBER: builtins.int
    TOOL_INVOCATION_ID_FIELD_NUMBER: builtins.int
    CORRELATED_INVOCATIONS_ID_FIELD_NUMBER: builtins.int
    ACTION_MNEMONIC_FIELD_NUMBER: builtins.int
    TARGET_ID_FIELD_NUMBER: builtins.int
    CONFIGURATION_ID_FIELD_NUMBER: builtins.int
    @property
    def tool_details(self) -> global___ToolDetails:
        """The details for the tool invoking the requests."""
    action_id: builtins.str
    """An identifier that ties multiple requests to the same action.
    For example, multiple requests to the CAS, Action Cache, and Execution
    API are used in order to compile foo.cc.
    """
    tool_invocation_id: builtins.str
    """An identifier that ties multiple actions together to a final result.
    For example, multiple actions are required to build and run foo_test.
    """
    correlated_invocations_id: builtins.str
    """An identifier to tie multiple tool invocations together. For example,
    runs of foo_test, bar_test and baz_test on a post-submit of a given patch.
    """
    action_mnemonic: builtins.str
    """A brief description of the kind of action, for example, CppCompile or GoLink.
    There is no standard agreed set of values for this, and they are expected to vary between different client tools.
    """
    target_id: builtins.str
    """An identifier for the target which produced this action.
    No guarantees are made around how many actions may relate to a single target.
    """
    configuration_id: builtins.str
    """An identifier for the configuration in which the target was built,
    e.g. for differentiating building host tools or different target platforms.
    There is no expectation that this value will have any particular structure,
    or equality across invocations, though some client tools may offer these guarantees.
    """
    def __init__(
        self,
        *,
        tool_details: global___ToolDetails | None = ...,
        action_id: builtins.str = ...,
        tool_invocation_id: builtins.str = ...,
        correlated_invocations_id: builtins.str = ...,
        action_mnemonic: builtins.str = ...,
        target_id: builtins.str = ...,
        configuration_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["tool_details", b"tool_details"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["action_id", b"action_id", "action_mnemonic", b"action_mnemonic", "configuration_id", b"configuration_id", "correlated_invocations_id", b"correlated_invocations_id", "target_id", b"target_id", "tool_details", b"tool_details", "tool_invocation_id", b"tool_invocation_id"]) -> None: ...

global___RequestMetadata = RequestMetadata
