"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2020 The Bazel Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import buildgrid._protos.google.rpc.status_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Qualifier(google.protobuf.message.Message):
    """The Remote Asset API provides a mapping from a URI and Qualifiers to
    Digests.

    Multiple URIs may be used to refer to the same content.  For example, the
    same tarball may exist at multiple mirrors and thus be retrievable from
    multiple URLs.  When URLs are used, these should refer to actual content as
    Fetch service implementations may choose to fetch the content directly
    from the origin.  For example, the HEAD of a git repository's active branch
    can be referred to as:

        uri: https://github.com/bazelbuild/remote-apis.git

    URNs may be used to strongly identify content, for instance by using the
    uuid namespace identifier: urn:uuid:f81d4fae-7dec-11d0-a765-00a0c91e6bf6.
    This is most applicable to named content that is Push'd, where the URN
    serves as an agreed-upon key, but carries no other inherent meaning.

    Service implementations may choose to support only URLs, only URNs for
    Push'd content, only other URIs for which the server and client agree upon
    semantics of, or any mixture of the above.

    Qualifiers are used to disambiguate or sub-select content that shares a URI.
    This may include specifying a particular commit or branch, in the case of
    URIs referencing a repository; they could also be used to specify a
    particular subdirectory of a repository or tarball. Qualifiers may also be
    used to ensure content matches what the client expects, even when there is
    no ambiguity to be had - for example, a qualifier specifying a checksum
    value.

    In cases where the semantics of the request are not immediately clear from
    the URL and/or qualifiers - e.g. dictated by URL scheme - it is recommended
    to use an additional qualifier to remove the ambiguity. The `resource_type`
    qualifier is recommended for this purpose.

    Qualifiers may be supplied in any order.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The "name" of the qualifier, for example "resource_type".
    No separation is made between 'standard' and 'nonstandard'
    qualifiers, in accordance with https://tools.ietf.org/html/rfc6648,
    however implementers *SHOULD* take care to avoid ambiguity.
    """
    value: builtins.str
    """The "value" of the qualifier. Semantics will be dictated by the name."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "value", b"value"]) -> None: ...

global___Qualifier = Qualifier

@typing_extensions.final
class FetchBlobRequest(google.protobuf.message.Message):
    """A request message for
    [Fetch.FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    OLDEST_CONTENT_ACCEPTED_FIELD_NUMBER: builtins.int
    URIS_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """The timeout for the underlying fetch, if content needs to be retrieved from
        origin.

        If unset, the server *MAY* apply an implementation-defined timeout.

        If set, and the user-provided timeout exceeds the RPC deadline, the server
        *SHOULD* keep the fetch going after the RPC completes, to be made
        available for future Fetch calls. The server may also enforce (via clamping
        and/or an INVALID_ARGUMENT error) implementation-defined minimum and
        maximum timeout values.

        If this timeout is exceeded on an attempt to retrieve content from origin
        the client will receive DEADLINE_EXCEEDED in [FetchBlobResponse.status].
        """
    @property
    def oldest_content_accepted(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The oldest content the client is willing to accept, as measured from the
        time it was Push'd or when the underlying retrieval from origin was
        started.
        Upon retries of Fetch requests that cannot be completed within a single
        RPC, clients *SHOULD* provide the same value for subsequent requests as the
        original, to simplify combining the request with the previous attempt.

        If unset, the client *SHOULD* accept content of any age.
        """
    @property
    def uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The URI(s) of the content to fetch. These may be resources that the server
        can directly fetch from origin, in which case multiple URIs *SHOULD*
        represent the same content available at different locations (such as an
        origin and secondary mirrors). These may also be URIs for content known to
        the server through other mechanisms, e.g. pushed via the [Push][build.bazel.remote.asset.v1.Push]
        service.

        Clients *MUST* supply at least one URI. Servers *MAY* match any one of the
        supplied URIs.
        """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Qualifiers sub-specifying the content to fetch - see comments on
        [Qualifier][build.bazel.remote.asset.v1.Qualifier].
        The same qualifiers apply to all URIs.

        Specified qualifier names *MUST* be unique.
        """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
        oldest_content_accepted: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        uris: collections.abc.Iterable[builtins.str] | None = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["oldest_content_accepted", b"oldest_content_accepted", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name", "oldest_content_accepted", b"oldest_content_accepted", "qualifiers", b"qualifiers", "timeout", b"timeout", "uris", b"uris"]) -> None: ...

global___FetchBlobRequest = FetchBlobRequest

@typing_extensions.final
class FetchBlobResponse(google.protobuf.message.Message):
    """A response message for
    [Fetch.FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    URI_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    BLOB_DIGEST_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
        """If the status has a code other than `OK`, it indicates that the operation
        was unable to be completed for reasons outside the servers' control.
        The possible fetch errors include:
        * `DEADLINE_EXCEEDED`: The operation could not be completed within the
          specified timeout.
        * `NOT_FOUND`: The requested asset was not found at the specified location.
        * `PERMISSION_DENIED`: The request was rejected by a remote server, or
          requested an asset from a disallowed origin.
        * `ABORTED`: The operation could not be completed, typically due to a
          failed consistency check.
        * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
          perform the requested operation. The client may retry after a delay.
        """
    uri: builtins.str
    """The uri from the request that resulted in a successful retrieval, or from
    which the error indicated in `status` was obtained.
    """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Any qualifiers known to the server and of interest to clients."""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """A minimum timestamp the content is expected to be available through.
        Servers *MAY* omit this field, if not known with confidence.
        """
    @property
    def blob_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The result of the fetch, if the status had code `OK`.
        The digest of the file's contents, available for download through the CAS.
        """
    def __init__(
        self,
        *,
        status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        uri: builtins.str = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        blob_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["blob_digest", b"blob_digest", "expires_at", b"expires_at", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["blob_digest", b"blob_digest", "expires_at", b"expires_at", "qualifiers", b"qualifiers", "status", b"status", "uri", b"uri"]) -> None: ...

global___FetchBlobResponse = FetchBlobResponse

@typing_extensions.final
class FetchDirectoryRequest(google.protobuf.message.Message):
    """A request message for
    [Fetch.FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    OLDEST_CONTENT_ACCEPTED_FIELD_NUMBER: builtins.int
    URIS_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """The timeout for the underlying fetch, if content needs to be retrieved from
        origin. This value is allowed to exceed the RPC deadline, in which case the
        server *SHOULD* keep the fetch going after the RPC completes, to be made
        available for future Fetch calls.

        If this timeout is exceeded on an attempt to retrieve content from origin
        the client will receive DEADLINE_EXCEEDED in [FetchDirectoryResponse.status].
        """
    @property
    def oldest_content_accepted(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The oldest content the client is willing to accept, as measured from the
        time it was Push'd or when the underlying retrieval from origin was
        started.
        Upon retries of Fetch requests that cannot be completed within a single
        RPC, clients *SHOULD* provide the same value for subsequent requests as the
        original, to simplify combining the request with the previous attempt.

        If unset, the client *SHOULD* accept content of any age.
        """
    @property
    def uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The URI(s) of the content to fetch. These may be resources that the server
        can directly fetch from origin, in which case multiple URIs *SHOULD*
        represent the same content available at different locations (such as an
        origin and secondary mirrors). These may also be URIs for content known to
        the server through other mechanisms, e.g. pushed via the [Push][build.bazel.remote.asset.v1.Push]
        service.

        Clients *MUST* supply at least one URI. Servers *MAY* match any one of the
        supplied URIs.
        """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Qualifiers sub-specifying the content to fetch - see comments on
        [Qualifier][build.bazel.remote.asset.v1.Qualifier].
        The same qualifiers apply to all URIs.

        Specified qualifier names *MUST* be unique.
        """
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
        oldest_content_accepted: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        uris: collections.abc.Iterable[builtins.str] | None = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["oldest_content_accepted", b"oldest_content_accepted", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["instance_name", b"instance_name", "oldest_content_accepted", b"oldest_content_accepted", "qualifiers", b"qualifiers", "timeout", b"timeout", "uris", b"uris"]) -> None: ...

global___FetchDirectoryRequest = FetchDirectoryRequest

@typing_extensions.final
class FetchDirectoryResponse(google.protobuf.message.Message):
    """A response message for
    [Fetch.FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STATUS_FIELD_NUMBER: builtins.int
    URI_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    EXPIRES_AT_FIELD_NUMBER: builtins.int
    ROOT_DIRECTORY_DIGEST_FIELD_NUMBER: builtins.int
    @property
    def status(self) -> buildgrid._protos.google.rpc.status_pb2.Status:
        """If the status has a code other than `OK`, it indicates that the operation
        was unable to be completed for reasons outside the servers' control.
        The possible fetch errors include:
        * `DEADLINE_EXCEEDED`: The operation could not be completed within the
          specified timeout.
        * `NOT_FOUND`: The requested asset was not found at the specified location.
        * `PERMISSION_DENIED`: The request was rejected by a remote server, or
          requested an asset from a disallowed origin.
        * `ABORTED`: The operation could not be completed, typically due to a
          failed consistency check.
        * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to
          perform the requested operation. The client may retry after a delay.
        """
    uri: builtins.str
    """The uri from the request that resulted in a successful retrieval, or from
    which the error indicated in `status` was obtained.
    """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Any qualifiers known to the server and of interest to clients."""
    @property
    def expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """A minimum timestamp the content is expected to be available through.
        Servers *MAY* omit this field, if not known with confidence.
        """
    @property
    def root_directory_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The result of the fetch, if the status had code `OK`.
        the root digest of a directory tree, suitable for fetching via
        [ContentAddressableStorage.GetTree].
        """
    def __init__(
        self,
        *,
        status: buildgrid._protos.google.rpc.status_pb2.Status | None = ...,
        uri: builtins.str = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
        expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        root_directory_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expires_at", b"expires_at", "root_directory_digest", b"root_directory_digest", "status", b"status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["expires_at", b"expires_at", "qualifiers", b"qualifiers", "root_directory_digest", b"root_directory_digest", "status", b"status", "uri", b"uri"]) -> None: ...

global___FetchDirectoryResponse = FetchDirectoryResponse

@typing_extensions.final
class PushBlobRequest(google.protobuf.message.Message):
    """A request message for
    [Push.PushBlob][build.bazel.remote.asset.v1.Push.PushBlob].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    URIS_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    EXPIRE_AT_FIELD_NUMBER: builtins.int
    BLOB_DIGEST_FIELD_NUMBER: builtins.int
    REFERENCES_BLOBS_FIELD_NUMBER: builtins.int
    REFERENCES_DIRECTORIES_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The URI(s) of the content to associate. If multiple URIs are specified, the
        pushed content will be available to fetch by specifying any of them.
        """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Qualifiers sub-specifying the content that is being pushed - see comments
        on [Qualifier][build.bazel.remote.asset.v1.Qualifier].
        The same qualifiers apply to all URIs.
        """
    @property
    def expire_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """A time after which this content should stop being returned via [FetchBlob][build.bazel.remote.asset.v1.Fetch.FetchBlob].
        Servers *MAY* expire content early, e.g. due to storage pressure.
        """
    @property
    def blob_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """The blob to associate."""
    @property
    def references_blobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest]:
        """Referenced blobs or directories that need to not expire before expiration
        of this association, in addition to `blob_digest` itself.
        These fields are hints - clients *MAY* omit them, and servers *SHOULD*
        respect them, at the risk of increased incidents of Fetch responses
        indirectly referencing unavailable blobs.
        """
    @property
    def references_directories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest]: ...
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        uris: collections.abc.Iterable[builtins.str] | None = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
        expire_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        blob_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
        references_blobs: collections.abc.Iterable[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest] | None = ...,
        references_directories: collections.abc.Iterable[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["blob_digest", b"blob_digest", "expire_at", b"expire_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["blob_digest", b"blob_digest", "expire_at", b"expire_at", "instance_name", b"instance_name", "qualifiers", b"qualifiers", "references_blobs", b"references_blobs", "references_directories", b"references_directories", "uris", b"uris"]) -> None: ...

global___PushBlobRequest = PushBlobRequest

@typing_extensions.final
class PushBlobResponse(google.protobuf.message.Message):
    """A response message for
    [Push.PushBlob][build.bazel.remote.asset.v1.Push.PushBlob].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PushBlobResponse = PushBlobResponse

@typing_extensions.final
class PushDirectoryRequest(google.protobuf.message.Message):
    """A request message for
    [Push.PushDirectory][build.bazel.remote.asset.v1.Push.PushDirectory].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_NAME_FIELD_NUMBER: builtins.int
    URIS_FIELD_NUMBER: builtins.int
    QUALIFIERS_FIELD_NUMBER: builtins.int
    EXPIRE_AT_FIELD_NUMBER: builtins.int
    ROOT_DIRECTORY_DIGEST_FIELD_NUMBER: builtins.int
    REFERENCES_BLOBS_FIELD_NUMBER: builtins.int
    REFERENCES_DIRECTORIES_FIELD_NUMBER: builtins.int
    instance_name: builtins.str
    """The instance of the execution system to operate against. A server may
    support multiple instances of the execution system (with their own workers,
    storage, caches, etc.). The server MAY require use of this field to select
    between them in an implementation-defined fashion, otherwise it can be
    omitted.
    """
    @property
    def uris(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The URI(s) of the content to associate. If multiple URIs are specified, the
        pushed content will be available to fetch by specifying any of them.
        """
    @property
    def qualifiers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Qualifier]:
        """Qualifiers sub-specifying the content that is being pushed - see comments
        on [Qualifier][build.bazel.remote.asset.v1.Qualifier].
        The same qualifiers apply to all URIs.
        """
    @property
    def expire_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """A time after which this content should stop being returned via
        [FetchDirectory][build.bazel.remote.asset.v1.Fetch.FetchDirectory].
        Servers *MAY* expire content early, e.g. due to storage pressure.
        """
    @property
    def root_directory_digest(self) -> buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest:
        """Directory to associate"""
    @property
    def references_blobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest]:
        """Referenced blobs or directories that need to not expire before expiration
        of this association, in addition to `root_directory_digest` itself.
        These fields are hints - clients *MAY* omit them, and servers *SHOULD*
        respect them, at the risk of increased incidents of Fetch responses
        indirectly referencing unavailable blobs.
        """
    @property
    def references_directories(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest]: ...
    def __init__(
        self,
        *,
        instance_name: builtins.str = ...,
        uris: collections.abc.Iterable[builtins.str] | None = ...,
        qualifiers: collections.abc.Iterable[global___Qualifier] | None = ...,
        expire_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        root_directory_digest: buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest | None = ...,
        references_blobs: collections.abc.Iterable[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest] | None = ...,
        references_directories: collections.abc.Iterable[buildgrid._protos.build.bazel.remote.execution.v2.remote_execution_pb2.Digest] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["expire_at", b"expire_at", "root_directory_digest", b"root_directory_digest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["expire_at", b"expire_at", "instance_name", b"instance_name", "qualifiers", b"qualifiers", "references_blobs", b"references_blobs", "references_directories", b"references_directories", "root_directory_digest", b"root_directory_digest", "uris", b"uris"]) -> None: ...

global___PushDirectoryRequest = PushDirectoryRequest

@typing_extensions.final
class PushDirectoryResponse(google.protobuf.message.Message):
    """A response message for
    [Push.PushDirectory][build.bazel.remote.asset.v1.Push.PushDirectory].
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___PushDirectoryResponse = PushDirectoryResponse
